<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);


// Check that the setup folder, plus the files in it, are writable.
$folder = realpath (".");
$writable = is_writable ($folder);
foreach (new DirectoryIterator ($folder) as $fileInfo) {
  if ($writable) {
    if ($fileInfo->isDot ()) continue;
    if ($fileInfo->isDir ()) continue;
    $basename = $fileInfo->getFilename();
    $filename = "$folder/$basename";
    $writable = is_writable ($filename);
  }
}
if (!$writable) {
  header ("Location: readonly.php");
  die;
}


// Remove the MySQL database credentials.
@unlink ("credentials.php");


?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Bibledit-Web Installation</title>
<link rel="stylesheet" href="stylesheet.css" type="text/css" />
</head>
<body>
<h1><img src="../assets/bibledit.png"> <a href="http://bibledit.org/">Bibledit-Web</a></h1>
<p>Welcome to the Bibledit-Web installation.</p>
<p>You may do a clean installation of Bibledit-Web, or you may upgrade an existing installation of version 1.3.</p>
<p>
  <a href="step.php" class="button button-large">Clean installation</a>
  <a href="database.php" class="button button-large">Upgrade from 1.3</a>
</p>
</body>
</html>
