<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");


$database_users = Database_Users::getInstance (); 
$database_logs = Database_Logs::getInstance ();
$database_notes = Database_Notes::getInstance ();
$notes_logic = Notes_Logic::getInstance ();


$action = $_POST ['a'];


// The server reads the credentials provides by the client.
// It checks the credentials, omits any admins, and finds Bibles the users have access to,
// It returns those Bibles to the client.
if ($action == "bibles") {

  $users = $_POST ['u'];
  $users = hex2bin ($users);
  $users = unserialize ($users);

  $md5s = $_POST ['p'];
  $md5s = unserialize ($md5s);

  $bibles = array ();

  foreach ($users as $key => $user) {
    if ($database_users->usernameExists ($user)) {
      $md5 = $md5s [$key];
      if ($md5 == $database_users->getmd5 ($user)) {
        $level = $database_users->getUserLevel ($user);
        if ($level < Filter_Roles::ADMIN_LEVEL) {
          $bibles = array_merge ($bibles, Access_Bible::bibles ($user));
        } else {
          $database_logs->log ("A client provides admin credentials: Skipping", Filter_Roles::MANAGER_LEVEL);
        }
      } else {
        $database_logs->log ("A client provides incorrect password for user $username", Filter_Roles::MANAGER_LEVEL);
      }
    } else {
      $database_logs->log ("A client requests Bibles for non existing user $username", Filter_Roles::MANAGER_LEVEL);
    }
  }
  $bibles = array_values ($bibles);
  $bibles = serialize ($bibles);
  echo $bibles;

} else if ($action == "notes") {

  $bibles = $_POST ['b'];
  $bibles = hex2bin ($bibles);
  $bibles = unserialize ($bibles);

  $lowId = $_POST ['l'];
  $highId = $_POST ['h'];

  $identifiers = $database_notes->getNotesInRangeForBibles ($lowId, $highId, $bibles);
  $checksum = Sync_Logic::checksum ($identifiers);
  $response ['t'] = count ($identifiers);
  $response ['c'] = $checksum;
  echo serialize ($response);

} else if ($action == "identifiers") {

  $bibles = $_POST ['b'];
  $bibles = hex2bin ($bibles);
  $bibles = unserialize ($bibles);

  $lowId = $_POST ['l'];
  $highId = $_POST ['h'];

  $identifiers = $database_notes->getNotesInRangeForBibles ($lowId, $highId, $bibles);
  $checksums = array ();
  foreach ($identifiers as $identifier) {
    $checksum = $database_notes->getChecksum ($identifier);
    $checksums [] = $checksum;
  }
  $response ['i'] = $identifiers;
  $response ['c'] = $checksums;
  echo serialize ($response);

} else if ($action == "fetch") {

  $identifier = $_POST ['i'];

  // Update search and checksum.
  $database_notes->updateSearchFields ($identifier);
  $database_notes->updateChecksum ($identifier);

  $modified = $database_notes->getModified ($identifier);
  $assignees = $database_notes->getAssignees ($identifier);
  $subscribers = $database_notes->getSubscribers ($identifier);
  $bible = $database_notes->getBible ($identifier);
  $passages = $database_notes->getPassages ($identifier);
  $status = $database_notes->getRawStatus ($identifier);
  $severity = $database_notes->getRawSeverity ($identifier);
  $summary = $database_notes->getSummary ($identifier);
  $contents = $database_notes->getContents ($identifier);

  $database_logs->log ("Client requested a note from server" . ": " . $summary, Filter_Roles::MANAGER_LEVEL);

  $response = array (
    'm'  => $modified,
    'a'  => $assignees,
    'sub' => $subscribers,
    'b'  => $bible,
    'p'  => $passages,
    'st' => $status,
    'se' => $severity,
    'sum' => $summary,
    'c'  => $contents
  );

  echo serialize ($response);
  
} else {

  echo "The server did not recognize the sync action and has discarded it";
  
}


?>
