#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <opencv2/opencv.hpp>
#include "myonlinetimer.h"
#include "myofflinetimer.h"

#include <QMainWindow>
#include <QComboBox>



namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);

    ~MainWindow();

    cv::VideoCapture CAPTURE;
    int CAMERAID;
    bool RESET;
    bool ONLINE_STATE;
    bool SCALE_ENABLE;
    bool FILTER_ENABLE;

    MyOnlineTimer OnlineTimer1;

    QString old_dirpath;
    void WarningMessageBox(QString msg);
    void ErrorMessageBox(QString msg);

    MyOfflineTimer OfflineTimer1;

    void save_init_file(QString str);
    void load_init_file(void);
private slots:
    void on_comboBox_currentIndexChanged(int index);


    void on_pushButton_runonline_clicked();


    void on_pushButton_reset_clicked();

    void on_checkBox_scale_colormap_clicked(bool checked);

    void on_checkBox_filtering_clicked(bool checked);

    void on_pushButton_save_image_sequence_clicked();

    void on_pushButton_select_output_path_clicked();

    void on_actionAbout_triggered();

private:
    Ui::MainWindow *ui;
    void AddItem2QComboBox(QComboBox* combo, QString itemName);
};

#endif // MAINWINDOW_H
