
MESSAGE(STATUS "Package Backup running...")
INCLUDE(CPackSourceConfig.cmake)
MESSAGE(STATUS "Package Backup gets date...")
# get the date
EXECUTE_PROCESS(COMMAND date +%d%b%Y-%Hh%M
		TIMEOUT 5
		RESULT_VARIABLE DATE_RES
		OUTPUT_VARIABLE DATE_OUT 
		ERROR_VARIABLE  DATE_ERR
		OUTPUT_STRIP_TRAILING_WHITESPACE)
# run cpack
MESSAGE(STATUS "Package Backup running cpack...")
EXECUTE_PROCESS(COMMAND cpack -G TGZ --config CPackSourceConfig.cmake
		TIMEOUT 3600
		WORKING_DIRECTORY ${CMAKE_BINARY_DIR})	
MESSAGE("Copy ${CPACK_SOURCE_PACKAGE_FILE_NAME}.tar.gz -->  ${CPACK_SOURCE_PACKAGE_FILE_NAME}-${DATE_OUT}.tar.gz")
EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E copy ${CPACK_SOURCE_PACKAGE_FILE_NAME}.tar.gz ${CPACK_SOURCE_PACKAGE_FILE_NAME}-${DATE_OUT}.tar.gz)
MESSAGE(STATUS "Package backup done in: ${CPACK_SOURCE_PACKAGE_FILE_NAME}-${DATE_OUT}.tar.gz")
