/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.gui.IzPanelLayout;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.Log;
import com.izforge.izpack.util.VariableSubstitutor;
import java.awt.Component;
import java.io.File;

public class SimpleFinishPanel
extends IzPanel {
    private static final long serialVersionUID = 3689911781942572085L;
    private VariableSubstitutor vs;

    public SimpleFinishPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData, new IzPanelLayout());
        this.vs = new VariableSubstitutor(installData.getVariables());
    }

    public boolean isValidated() {
        return true;
    }

    public void panelActivate() {
        this.parent.lockNextButton();
        this.parent.lockPrevButton();
        this.parent.setQuitButtonText(this.parent.langpack.getString("FinishPanel.done"));
        this.parent.setQuitButtonIcon("done");
        if (this.idata.installSuccess) {
            this.add(LabelFactory.create(this.parent.icons.getImageIcon("check")));
            this.add(IzPanelLayout.createVerticalStrut(5));
            this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.success"), this.parent.icons.getImageIcon("preferences"), 10), "nextLine");
            this.add(IzPanelLayout.createVerticalStrut(5));
            if (this.idata.uninstallOutJar != null) {
                String string = this.translatePath("$INSTALL_PATH") + File.separator + "Uninstaller";
                this.add((Component)LabelFactory.create(this.parent.langpack.getString("FinishPanel.uninst.info"), this.parent.icons.getImageIcon("preferences"), 10), "nextLine");
                this.add((Component)LabelFactory.create(string, this.parent.icons.getImageIcon("empty"), 10), "nextLine");
            }
        } else {
            this.add(LabelFactory.create(this.parent.langpack.getString("FinishPanel.fail"), this.parent.icons.getImageIcon("stop"), 10));
        }
        this.getLayoutHelper().completeLayout();
        Log.getInstance().informUser();
    }

    private String translatePath(String string) {
        string = this.vs.substitute(string, null);
        return string.replace('/', File.separatorChar);
    }
}

