<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

function parse_smilies($text)
{
  // alle smilie-codes durch entsprechende img-tags ersetzen
  global $smilies;
  $text = str_replace(":?:",       "<img src=\"./gfx/smilies/".$smilies."/question.png\"  alt=\":?:\" />",       $text);
  $text = str_replace(":)",        "<img src=\"./gfx/smilies/".$smilies."/smile.png\"     alt=\":)\" />",        $text);
  $text = str_replace(":D",        "<img src=\"./gfx/smilies/".$smilies."/biggrin.png\"   alt=\":D\" />",        $text);
  $text = str_replace(":(",        "<img src=\"./gfx/smilies/".$smilies."/sad.png\"       alt=\":(\" />",        $text);
  $text = str_replace(";)",        "<img src=\"./gfx/smilies/".$smilies."/wink.png\"      alt=\";)\" />",        $text);
  $text = str_replace(":o",        "<img src=\"./gfx/smilies/".$smilies."/surprised.png\" alt=\":o\" />",        $text);
  $text = str_replace(":shock:",   "<img src=\"./gfx/smilies/".$smilies."/shock.png\"     alt=\":shock:\" />",   $text);
  $text = str_replace(":S",        "<img src=\"./gfx/smilies/".$smilies."/confused.png\"  alt=\":S\" />",        $text);
  $text = str_replace("8)",        "<img src=\"./gfx/smilies/".$smilies."/cool.png\"      alt=\"8)\" />",        $text);
  $text = str_replace(":lol:",     "<img src=\"./gfx/smilies/".$smilies."/lol.png\"       alt=\":lol:\" />",     $text);
  $text = str_replace(":x",        "<img src=\"./gfx/smilies/".$smilies."/mad.png\"       alt=\":x:\" />",       $text);
  $text = str_replace(":P",        "<img src=\"./gfx/smilies/".$smilies."/tongue.png\"    alt=\":P\" />",        $text);
  $text = str_replace(":blush:",   "<img src=\"./gfx/smilies/".$smilies."/blush.png\"     alt=\":blush:\" />",   $text);
  $text = str_replace(":cry:",     "<img src=\"./gfx/smilies/".$smilies."/cry.png\"       alt=\":cry:\" />",     $text);
  $text = str_replace(":evil:",    "<img src=\"./gfx/smilies/".$smilies."/evil.png\"      alt=\":evil:\" />",    $text);
  $text = str_replace(":twisted:", "<img src=\"./gfx/smilies/".$smilies."/twisted.png\"   alt=\":twisted:\" />", $text);
  $text = str_replace(":roll:",    "<img src=\"./gfx/smilies/".$smilies."/roll.png\"      alt=\":roll:\" />",    $text);
  $text = str_replace(":!:",       "<img src=\"./gfx/smilies/".$smilies."/exclaim.png\"   alt=\":!:\" />",       $text);
  $text = str_replace(":idea:",    "<img src=\"./gfx/smilies/".$smilies."/idea.png\"      alt=\":idea:\" />",    $text);
  $text = str_replace(":arrow:",   "<img src=\"./gfx/smilies/".$smilies."/arrow.png\"     alt=\":arrow:\" />",   $text);
  $text = str_replace(":|",        "<img src=\"./gfx/smilies/".$smilies."/neutral.png\"   alt=\":|\" />",        $text);
  $text = str_replace(":mrgreen:", "<img src=\"./gfx/smilies/".$smilies."/mrgreen.png\"   alt=\":mrgreen:\" />", $text);

  return $text;
}
?>