<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["admin"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if(!isset($_POST["kategorie_erstellen"]) and !isset($_POST["kategorie_bearbeiten"]) and !isset($_POST["kategorie_loeschen"]) and !isset($_POST["frage_erstellen"]) and !isset($_POST["frage_bearbeiten"]) and !isset($_POST["frage_loeschen"]))
{
  ?>
  <h3>FAQ verwalten</h3>
  <table class="maintable">
  <form name="form1" method="POST" action="index.php?action=admincp&amp;show=faq">
  <tr class="rowberschrift">
    <td colspan="2">Kategorie erstellen</td>
  </tr>
  <tr class="row2">
    <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>&nbsp;</td><td><input name="kategorie_erstellen" type="submit" value="erstellen" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Kategorie bearbeiten</td>
  </tr>
  <tr class="row2">
    <td>Kategorie:</td><td><select class="inputtext" name="kat_kategorie" size="1">
    <?php
    $kategorien = sql_select("id, titel", "faq_kategorien", "ORDER BY sort ASC");
    while($kategorie = sql_fetch_assoc($kategorien))
    {
      ?><option value="<?php echo $kategorie["id"] ?>"><?php echo $kategorie["id"]." - ".$kategorie["titel"] ?></option><?php
    }
    ?>
    </select></td>
  </tr>
  <tr class="row2">
    <td>&nbsp;</td><td><input name="kategorie_bearbeiten" type="submit" value="bearbeiten" /> <input name="kategorie_loeschen" type="submit" value="lschen" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Frage erstellen</td>
  </tr>
  <tr class="row2">
    <td>Frage:</td><td><input class="inputtext" name="frage" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>BB-Code:</td><td><?php $formname = "form1"; $textname = "antwort"; include("./bbcode_inputs.php") ?></td>
  </tr>
  <tr class="row2">
    <td>Antwort:</td><td><textarea class="inputtext" name="antwort" cols="39" rows="5"></textarea></td>
  </tr>
  <tr class="row2">
    <td>BB-Code aktivieren</td><td><input name="bbcode" type="radio" value="1"<?php if($user["auto_bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($user["auto_bbcode"] == 0) echo " checked" ?> />Nein</td>
  </tr>
  <tr class="row2">
    <td>Smilies aktivieren</td><td><input name="smilies" type="radio" value="1"<?php if($user["auto_smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($user["auto_smilies"] == 0) echo " checked" ?> />Nein</td>
  </tr>
  <tr class="row2">
    <td>Kategorie:</td><td><select class="inputtext" name="frg_kategorie" size="1">
    <?php
    $kategorien = sql_select("id, titel", "faq_kategorien", "ORDER BY sort ASC");
    while($kategorie = sql_fetch_assoc($kategorien))
    {
      ?><option value="<?php echo $kategorie["id"] ?>"><?php echo $kategorie["id"]." - ".$kategorie["titel"] ?></option><?php
    }
    ?>
    </select></td>
  </tr>
  <tr class="row2">
    <td>&nbsp;</td><td><input name="frage_erstellen" type="submit" value="erstellen" /></td>
  </tr>
  <tr class="rowberschrift">
    <td colspan="2">Frage bearbeiten</td>
  </tr>
  <tr class="row2">
    <td>Frage:</td><td><select class="inputtext" name="edit_frage" size="1">
    <?php
    $fragen = sql_select("id, frage", "faq_fragen", "ORDER BY kategorie, sort ASC");
    while($frage = sql_fetch_assoc($fragen))
    {
      ?><option value="<?php echo $frage["id"] ?>"><?php echo $frage["id"]." - ".$frage["frage"] ?></option><?php
    }
    ?>
    </select></td>
  </tr>
  <tr class="row2">
    <td>&nbsp;</td><td><input name="frage_bearbeiten" type="submit" value="bearbeiten" /> <input name="frage_loeschen" type="submit" value="lschen" /></td>
  </tr>
  </table>
  <?php
}

//****************************** kategorie_erstellen ************************************
if(isset($_POST["kategorie_erstellen"]))
{
  // neue kategorie erstellen
  if(trim($_POST["titel"]) == "") fehler("Sie mssen einen Titel fr die Kategorie angeben!");
  // hchsten sort-wert erausfinden
  $maxsort = sql_num_rows(sql_select("id", "faq_kategorien", ""));

  $werte = array(
      "titel" => htmlspecialchars($_POST["titel"]),
      "sort"  => $maxsort + 1
      );
  sql_insert("faq_kategorien", $werte);
  ?>
  <h3>Kategorie erstellen</h3>
  <?php
  redir("index.php?action=admincp&show=faq", "Die Kategorie wurde erfolgreich erstellt!");
}

//****************************** kategorie_bearbeiten ***********************************
if(isset($_POST["kategorie_bearbeiten"]))
{
  $kategorie = sql_fetch_assoc(sql_select("*", "faq_kategorien", "WHERE id=".$_POST["kat_kategorie"]));
  ?><h3>Kategorie bearbeiten</h3><?php
  // kategorie bearbeiten
  if(!isset($_POST["bearbeiten_knopf2"]) and !isset($_POST["move_up"]) and !isset($_POST["move_down"]))
  {
    // formular anzeigen
    ?>
    <form method="POST" action="index.php?action=admincp&amp;show=faq">
    <input name="kategorie_bearbeiten" type="hidden" value="1" />
    <input name="kat_kategorie" type="hidden" value="<?php echo $_POST["kat_kategorie"] ?>" />
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2">Kategorie bearbeiten</td>
    </tr>
    <tr class="row2">
      <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" value="<?php echo $kategorie["titel"] ?>" /></td>
    </tr>
    <tr class="row2">
      <td>&nbsp;</td><td><input name="bearbeiten_knopf2" type="submit" value="bearbeiten" /></td>
    </tr>
    <tr class="row2">
      <td>Sortierung:</td><td><input name="move_up" type="submit" value="nach oben" /> <input name="move_down" type="submit" value="nach unten" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  if(isset($_POST["bearbeiten_knopf2"]))
  {
    // nderungen speichern
    if(trim($_POST["titel"]) == "") fehler("Sie mssen einen Titel fr die Kategorie angeben!");
    $werte = array("titel" => htmlspecialchars($_POST["titel"]));
    sql_update("faq_kategorien", $werte, "WHERE id=".$kategorie["id"]);
    redir("index.php?action=admincp&show=faq", "Die Kategorie wurde bearbeitet!");
  }
  if(isset($_POST["move_up"]))
  {
    // kategorie nach oben bewegen
    if($kategorie["sort"] == 1)
    {
      redir("index.php?action=admincp&show=faq", "Die Kategorie ist bereits ganz oben!", false);
    }
    else
    {
      $tauschkategorie = sql_fetch_assoc(sql_select("id", "faq_kategorien", "WHERE sort=".($kategorie["sort"] - 1)));
      $werte = array("sort" => $kategorie["sort"] - 1);
      sql_update("faq_kategorien", $werte, "WHERE id=".$kategorie["id"]);
      $werte = array("sort" => $kategorie["sort"]);
      sql_update("faq_kategorien", $werte, "WHERE id=".$tauschkategorie["id"]);
      redir("index.php?action=admincp&show=faq", "Die Kategorie wurde nach oben bewegt!");
    }
  }
  if(isset($_POST["move_down"]))
  {
    // kategorie nach unten bewegen
    $maxsort = sql_num_rows(sql_select("id", "faq_kategorien", ""));
    if($kategorie["sort"] == $maxsort)
    {
      redir("index.php?action=admincp&show=faq", "Die Kategorie ist bereits ganz unten!", false);
    }
    else
    {
      $tauschkategorie = sql_fetch_assoc(sql_select("id", "faq_kategorien", "WHERE sort=".($kategorie["sort"] + 1)));
      $werte = array("sort" => $kategorie["sort"] + 1);
      sql_update("faq_kategorien", $werte, "WHERE id=".$kategorie["id"]);
      $werte = array("sort" => $kategorie["sort"]);
      sql_update("faq_kategorien", $werte, "WHERE id=".$tauschkategorie["id"]);
      redir("index.php?action=admincp&show=faq", "Die Kategorie wurde nach unten bewegt!");
    }
  }
}

//***************************** kategorie_loeschen **************************************
if(isset($_POST["kategorie_loeschen"]))
{
  $kategorie = sql_fetch_assoc(sql_select("*", "faq_kategorien", "WHERE id=".$_POST["kat_kategorie"]));
  ?><h3>Kategorie lschen</h3><?php
  if(!isset($_POST["loeschen_bestaetigen"]))
  {
    // sicher ?
    ?>
    Sind Sie sicher, dass Sie die Kategorie <b>"<?php echo $kategorie["titel"] ?>"</b>
    (ID: <?php echo $kategorie["id"] ?>) lschen wollen?<br />
    Alle enthaltenen Fragen werden gelscht!<br />
    <form method="POST" action="index.php?action=admincp&amp;show=faq">
    <input name="kategorie_loeschen" type="hidden" value="1" />
    <input name="kat_kategorie" type="hidden" value="<?php echo $kategorie["id"] ?>" />
    <input name="loeschen_bestaetigen" type="submit" value="lschen" />
    </form>
    <?php
  }
  else
  {
    // kategorie aus der db lschen
    // alle fragen der kategorie lschen
    sql_delete("faq_fragen", "WHERE kategorie=".$kategorie["id"]);
    // kategorie lschen
    sql_delete("faq_kategorien", "WHERE id=".$kategorie["id"]);
    redir("index.php?action=admincp&show=faq", "Die Kategorie und alle enthaltenen Fragen wurden gelscht!");
  }
}

//******************************** frage_erstellen **************************************
if(isset($_POST["frage_erstellen"]))
{
  // neue kategorie erstellen
  // hchsten sort-wert erausfinden
  $maxsort = sql_num_rows(sql_select("id", "faq_fragen", "WHERE kategorie=".$_POST["frg_kategorie"]));

  $werte = array(
      "kategorie" => $_POST["frg_kategorie"],
      "frage"     => htmlspecialchars($_POST["frage"]),
      "antwort"   => htmlspecialchars($_POST["antwort"]),
      "bbcode"    => $_POST["bbcode"],
      "smilies"   => $_POST["smilies"],
      "sort"      => $maxsort + 1
      );
  sql_insert("faq_fragen", $werte);
  ?>
  <h3>Frage erstellen</h3>
  <?php
  redir("index.php?action=admincp&show=faq", "Die Frage wurde erfolgreich erstellt!");
}

//******************************** frage_bearbeiten *************************************
if(isset($_POST["frage_bearbeiten"]))
{
  $frage = sql_fetch_assoc(sql_select("*", "faq_fragen", "WHERE id=".$_POST["edit_frage"]));
  ?><h3>Frage bearbeiten</h3><?php
  // kategorie bearbeiten
  if(!isset($_POST["bearbeiten_knopf2"]) and !isset($_POST["move_up"]) and !isset($_POST["move_down"]))
  {
    // formular anzeigen
    ?>
    <form name="form1" method="POST" action="index.php?action=admincp&amp;show=faq">
    <input name="frage_bearbeiten" type="hidden" value="1" />
    <input name="edit_frage" type="hidden" value="<?php echo $_POST["edit_frage"] ?>" />
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2">Frage</td>
    </tr>
    <tr class="row2">
      <td>Frage:</td><td><input class="inputtext" name="frage" type="text" size="40" value="<?php echo $frage["frage"] ?>" /></td>
    </tr>
    <tr class="row2">
      <td>BB-Code:</td><td><?php $formname = "form1"; $textname = "antwort"; include("./bbcode_inputs.php") ?></td>
    </tr>
    <tr class="row2">
      <td>Antwort:</td><td><textarea class="inputtext" name="antwort" cols="39" rows="10"><?php echo $frage["antwort"] ?></textarea></td>
    </tr>
    <tr class="rowberschrift">
      <td colspan="2">Optionen</td>
    </tr>
    <tr class="row2">
      <td>BB-Code aktivieren:</td><td><input name="bbcode" type="radio" value="1"<?php if($frage["bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($frage["bbcode"] == 0) echo " checked" ?> />Nein</td>
    </tr>
    <tr class="row2">
      <td>Smilies aktivieren:</td><td><input name="smilies" type="radio" value="1"<?php if($frage["smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($frage["smilies"] == 0) echo " checked" ?> />Nein</td>
    </tr>
    <tr class="row2">
      <td>Kategorie:</td><td><select class="inputtext" name="kategorie" size="1">
      <?php
      $kategorien = sql_select("id, titel", "faq_kategorien", "ORDER BY sort ASC");
      while($kategorie = sql_fetch_assoc($kategorien))
      {
        ?><option value="<?php echo $kategorie["id"] ?>"<?php if($kategorie["id"] == $frage["kategorie"]) echo " selected" ?>><?php echo $kategorie["id"]." - ".$kategorie["titel"] ?></option><?php
      }
      ?>
      </select></td>
    </tr>
    <tr class="row2">
      <td>&nbsp;</td><td><input name="bearbeiten_knopf2" type="submit" value="bearbeiten" /></td>
    </tr>
    <tr class="row2">
      <td>Sortierung:</td><td><input name="move_up" type="submit" value="nach oben" /> <input name="move_down" type="submit" value="nach unten" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  if(isset($_POST["bearbeiten_knopf2"]))
  {
    // nderungen speichern
    // wurde die kategorie gendert?
    if($_POST["kategorie"] != $frage["kategorie"])
    {
      // ja -> als letztes sort-element anhngen und elemente aus der alten kategorie aufrcken
      $maxsort = sql_num_rows(sql_select("id", "faq_fragen", "WHERE kategorie=".$_POST["kategorie"]));
      $sort = $maxsort + 1;
      $sql = "UPDATE ".$conf["sql_prefix"]."_faq_fragen SET sort=sort-1 WHERE sort>".$frage["sort"]." and kategorie=".$frage["kategorie"].";";
      if($conf["sql_typ"] == "mysql") mysql_query($sql, $link) or dbfehler();
      if($conf["sql_typ"] == "postgresql") pg_query($link, $sql) or dbfehler();
    }
    else
    {
      $sort = $frage["sort"];
    }

    $werte = array(
        "kategorie" => $_POST["kategorie"],
        "frage"     => htmlspecialchars($_POST["frage"]),
        "antwort"   => htmlspecialchars($_POST["antwort"]),
        "bbcode"    => $_POST["bbcode"],
        "smilies"   => $_POST["smilies"],
        "sort"      => $sort
        );
    sql_update("faq_fragen", $werte, "WHERE id=".$frage["id"]);
    redir("index.php?action=admincp&show=faq", "Die Frage wurde bearbeitet!");
  }
  if(isset($_POST["move_up"]))
  {
    // frage nach oben bewegen
    if($frage["sort"] == 1)
    {
      redir("index.php?action=admincp&show=faq", "Die Frage ist bereits ganz oben!", false);
    }
    else
    {
      $tauschfrage = sql_fetch_assoc(sql_select("id", "faq_fragen", "WHERE sort=".($frage["sort"] - 1)));
      $werte = array("sort" => $frage["sort"] - 1);
      sql_update("faq_fragen", $werte, "WHERE id=".$frage["id"]);
      $werte = array("sort" => $frage["sort"]);
      sql_update("faq_fragen", $werte, "WHERE id=".$tauschfrage["id"]);
      redir("index.php?action=admincp&show=faq", "Die Frage wurde nach oben bewegt!");
    }
  }
  if(isset($_POST["move_down"]))
  {
    // frage nach unten bewegen
    $maxsort = sql_num_rows(sql_select("id", "faq_fragen", "WHERE kategorie=".$frage["kategorie"]));
    if($frage["sort"] == $maxsort)
    {
      redir("index.php?action=admincp&show=faq", "Die Frage ist bereits ganz unten!", false);
    }
    else
    {
      $tauschfrage = sql_fetch_assoc(sql_select("id", "faq_fragen", "WHERE sort=".($frage["sort"] + 1)));
      $werte = array("sort" => $frage["sort"] + 1);
      sql_update("faq_fragen", $werte, "WHERE id=".$frage["id"]);
      $werte = array("sort" => $frage["sort"]);
      sql_update("faq_fragen", $werte, "WHERE id=".$tauschfrage["id"]);
      redir("index.php?action=admincp&show=faq", "Die Frage wurde nach unten bewegt!");
    }
  }
}

//******************************* frage_loeschen ****************************************
if(isset($_POST["frage_loeschen"]))
{
  $frage = sql_fetch_assoc(sql_select("*", "faq_fragen", "WHERE id=".$_POST["edit_frage"]));
  ?><h3>Frage lschen</h3><?php
  if(!isset($_POST["loeschen_bestaetigen"]))
  {
    // sicher ?
    ?>
    Sind Sie sicher, dass Sie die Frage <b>"<?php echo $frage["frage"] ?>"</b>
    (ID: <?php echo $frage["id"] ?>) lschen wollen?<br />
    <form method="POST" action="index.php?action=admincp&amp;show=faq">
    <input name="frage_loeschen" type="hidden" value="1" />
    <input name="edit_frage" type="hidden" value="<?php echo $frage["id"] ?>" />
    <input name="loeschen_bestaetigen" type="submit" value="lschen" />
    </form>
    <?php
  }
  else
  {
    // frage aus der db lschen
    sql_delete("faq_fragen", "WHERE id=".$frage["id"]);
    // nachfolgende sort-werte aufrcken
    $sql = "UPDATE ".$conf["sql_prefix"]."_faq_fragen SET sort=sort-1 WHERE sort>".$frage["sort"]." and kategorie=".$frage["kategorie"].";";
    if($conf["sql_typ"] == "mysql") mysql_query($sql, $link) or dbfehler();
    if($conf["sql_typ"] == "postgresql") pg_query($link, $sql) or dbfehler();
    redir("index.php?action=admincp&show=faq", "Die Frage wurde gelscht!");
  }
}