<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["memberlist"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");
?>
<h3>Mitglieder</h3>
<?php
// start und end werte fr LIMIT feststellen
if(!isset($_GET["seite"]))
{
  $seite = 1;
  $memberstart = 0;
}
else
{
  $seite = $_GET["seite"];
  $memberstart = ($seite - 1) * $einstellungen["membersperpage"];
}
$memberzahl = sql_num_rows(sql_select("id", "users", "", NULL, NULL));

// seiten-navigationsleiste
$seitenzahl = ceil($memberzahl/$einstellungen["membersperpage"]);
$strseite = "<b>Seite: ";
$startausgeblendet = false;
$endeausgeblendet = false;
for($i = 1; $i <= $seitenzahl; $i++)
{
  if($i < ($seite - 2))
  {
    if($startausgeblendet == false)
    {
      $strseite .= ".. ";
      $startausgeblendet = true;
    }
  }
  if($i > ($seite + 2))
  {
    if($endeausgeblendet == false)
    {
      $strseite .= ".. <a href=\"index.php?action=memberlist&amp;seite=".$seitenzahl."\">[letzte Seite]</a>";
      $endeausgeblendet = true;
    }
  }
  if($i <= ($seite + 2) and $i >= ($seite - 2))
  {
    if($i != $seite)
    {
      $strseite .= "<a href=\"index.php?action=memberlist&amp;seite=".$i."\">".$i."</a> ";
    }
    else
    {
      $strseite .= $i." ";
    }
  }
}
$strseite .= "</b><br /><br />";
echo $strseite;
?>
<table class="maintable" width="80%">
<tr class="rowberschrift">
    <td><b>Username</b></td>
    <td><b>eMail</b></td>
    <td><b>ICQ</b></td>
    <td><b>Reg-Datum</b></td>
    <td><b>Letzter Post</b></td>
</tr>
<?php
$result = sql_select("*", "users", "ORDER BY username ASC", $memberstart, $einstellungen["membersperpage"]);
// jede zeile aus der db holen und in die table einfgen
$zeile = 2;

while($ergebnis = sql_fetch_assoc($result))
{
  if($ergebnis["id"]!=1) // gast-eintrag bergehen
  {
    // letzten post herausfinden
    $postresult = sql_select("*", "posts", "WHERE autor_id=".$ergebnis["id"]." ORDER BY created DESC", NULL, NULL);
    $posts = sql_num_rows($postresult);
    if($posts!=0)
    {
      $lastpost = sql_fetch_assoc($postresult);
      $threadresult = sql_select("*", "threads", "WHERE id=".$lastpost["thread"], NULL, NULL);
      $threadergebnis = sql_fetch_assoc($threadresult);
      $lastpost = date("d.m.Y - H:i:s",$lastpost["created"] + $zeitoffset)." in<br /><a href=\"index.php?action=viewthread&amp;id=".$lastpost["thread"]."#".$lastpost["id"]."\">".$threadergebnis["titel"]."</a>";
    }
    else
    {
      $lastpost = "-";
    }

    echo "<tr class=\"row$zeile\">";
    echo "<td class=\"liste\"><a href=\"index.php?action=userinfo&amp;id=".$ergebnis["id"]."\">".htmlspecialchars($ergebnis["username"])."</td>\n";
    echo "<td class=\"liste\">"     . str_replace("@"," (at) ",$ergebnis["email"])    . "</td>\n";
    echo "<td class=\"liste\">"     . $ergebnis["icq"]      . "</td>\n";
    echo "<td class=\"liste\">"     . date("d.m.Y", $ergebnis["reg_since"] + $zeitoffset) . "<br />" . date("H:i:s", $ergebnis["reg_since"] + $zeitoffset) . "</td>\n";
    echo "<td class=\"liste\">"     . $lastpost . "</td>\n";
    echo "</tr>";

    $zeile++;
    if ($zeile>2) $zeile=1;
  }
}
?>
</table>
<br />
<?php echo $strseite ?>