<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

//header("Content-type: application/rss+xml");
header("Content-type: text/plain");

include("./config.php");
include("./sql.php");

$link = sql_connect();
$einstellungen = sql_fetch_assoc(sql_select("*", "einstellungen", "", NULL, NULL));

// board-rechte rausfinden
function getboardrechte($boardid)
{
  // hnlich wie oben
  global $user;

  $boardrechte["lesen"]      = false;
  $boardrechte["posts"]      = false;
  $boardrechte["threads"]    = false;
  $boardrechte["moderieren"] = false;

  // boardrechte abfragen
  $gruppenboardrechteresult = sql_select("*", "boardrechte", "WHERE gruppe_id=1 AND board_id=".$boardid, NULL, NULL);
  $gruppenboardrechte = sql_fetch_assoc($gruppenboardrechteresult);
  if($gruppenboardrechte["lesen"]      == 1) $boardrechte["lesen"]      = true;
  if($gruppenboardrechte["posts"]      == 1) $boardrechte["posts"]      = true;
  if($gruppenboardrechte["threads"]    == 1) $boardrechte["threads"]    = true;
  if($gruppenboardrechte["moderieren"] == 1) $boardrechte["moderieren"] = true;
  sql_free_result($gruppenboardrechteresult);

  return $boardrechte;
}

$posts = sql_select("id, thread, autor_id, autor_name", "posts", "ORDER BY created DESC", NULL, NULL);
$i = 1;
$thread = NULL;
$boardarray = explode(";", $einstellungen["rss_boards"]);

// alle threads mit neuen posts zusammenstellen
while(count($thread) < $einstellungen["rss_anzahl"] and $post = sql_fetch_assoc($posts))
{
  $postthread = sql_fetch_assoc(sql_select("id, titel, board", "threads", "WHERE id=".$post["thread"], NULL, NULL));
  $postboard = sql_fetch_assoc(sql_select("titel", "boards", "WHERE id=".$postthread["board"], NULL, NULL));

  if(in_array($postthread["board"], $boardarray))
  {
    $boardrechte = getboardrechte($postthread["board"]);
    if($boardrechte["lesen"] == true)
    {
      $tempthread["id"] = $postthread["id"];

      $tempthread["titel"] = $postthread["titel"];

      $tempthread["postid"] = $post["id"];

      $tempthread["board"] = $postboard["titel"];

      $posterresult = sql_select("*", "users", "WHERE id=".$post["autor_id"], NULL, NULL);
      if(sql_num_rows($posterresult)!=0)
      {
        //user ist in der datenbank
        $poster = sql_fetch_assoc($posterresult);
        if($poster["id"]!=1)
        {
          $tempthread["postautor"] = htmlspecialchars($poster["username"]);
        }
        else
        {
          // Gast
          $tempthread["postautor"] = htmlspecialchars($value["autor_name"]);
        }
      }
      else
      {
        //gelschter user
        $tempthread["postautor"] = htmlspecialchars($value["autor_name"]);
      }

      $schon_vorhanden = false;
      if($thread != NULL)
      {
        foreach($thread as $value)
        {
          if($value["id"] == $tempthread["id"]) $schon_vorhanden = true;
        }
      }

      if($schon_vorhanden == false)
      {
        $thread[$i] = $tempthread;
        $i++;
      }
    }
  }
}

echo "<"."?xml version=\"1.0\"?".">";
?>

<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://purl.org/rss/1.0/">

<channel rdf:about="<?php echo $einstellungen["adresse"] ?>rss.php">
  <title><?php echo $einstellungen["titel"] ?></title>
  <link><?php echo $einstellungen["adresse"] ?></link>
  <description>
    Die <?php echo $einstellungen["rss_anzahl"] ?> aktuellsten Threads mit neuen Posts in <?php echo $einstellungen["titel"] ?>
  </description>

  <items>
    <rdf:Seq>
      <rdf:li resource="<?php echo $einstellungen["adresse"] ?>index.php" />
      <?php
      if($thread != NULL)
      {
        foreach($thread as $value)
        {
          ?>
          <rdf:li resource="<?php echo $einstellungen["adresse"] ?>index.php?action=viewthread&amp;id=<?php echo $value["id"]."#".$value["postid"] ?>" />
          <?php
        }
      }
      ?>
    </rdf:Seq>
  </items>

</channel>

<item rdf:about="<?php echo $einstellungen["adresse"] ?>index.php">
  <title>Startseite</title>
  <link><?php echo $einstellungen["adresse"] ?>index.php</link>
  <description>
    <?php echo $einstellungen["titel"] ?> - Startseite
  </description>
</item>
<?php
if($thread != NULL)
{
  foreach($thread as $value)
  {
    ?>
    <item rdf:about="<?php echo $einstellungen["adresse"] ?>index.php?action=viewthread&amp;id=<?php echo $value["id"]."#".$value["postid"] ?>">
      <title><?php echo $value["board"]." -> ".$value["titel"] ?></title>
      <link><?php echo $einstellungen["adresse"] ?>index.php?action=viewthread&amp;id=<?php echo $value["id"]."#".$value["postid"] ?></link>
      <description>
        Autor: <?php echo $value["postautor"] ?>
      </description>
    </item>
    <?php
  }
}
?>

</rdf:RDF>