@echo off

REM  This file is part of EST (Efficient Symbolic Tools).
REM  Copyright (C) 2003, 2012
REM  UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia
REM
REM  EST is free software; you can redistribute it and/or modify
REM  it under the terms of the GNU General Public License as
REM  published by the Free Software Foundation; either version 2
REM  of the License, or (at your option) any later version.
REM
REM  EST is distributed in the hope that it will be useful,
REM  but WITHOUT ANY WARRANTY; without even the implied warranty of
REM  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
REM  GNU General Public License for more details.
REM
REM  You should have received a copy of the GNU General Public
REM  License along with this program; if not, write to the Free
REM  Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
REM  Boston, MA 02110-1301 USA.]

SET EDITION=est-2ed
FOR /F "USEBACKQ" %%T IN (`TYPE source\VERSION`) DO SET VVERSION=%%T
SET VERSION=%VVERSION:.=-%
SET OS=Win
SET BBINDIR="%cd%\bin"
SET BINDIR=%BBINDIR:\=/%
SET MYZIP="C:\Program Files\7-Zip\7z.exe" a
SET SFX="C:\Program Files\7-Zip\7zsd.sfx"

SET NAME=EST, 2nd Edition
SET RELEASE=Release: %VVERSION%  (%DATE%)

rm %EDITION%-%VERSION%-%OS%-mish.7z
rm %EDITION%-%VERSION%-%OS%-mish.exe
rm %EDITION%-%VERSION%-%OS%.7z
rm %EDITION%-%VERSION%-%OS%.exe
rm -fr bin

echo Creating %EDITION%-%VERSION%-%OS%-mish

cd source
make mish "BINDIR=%BINDIR%"
make clean "BINDIR=%BINDIR%"
cp COPYING ../bin
cp est2ed.tcl ../bin
cp pkgIndex.tcl ../bin
cp ../../myinterface/mi.tcl ../bin
cp ../../myinterface/miDialog.tcl ../bin
cp ../../bddview/bddview.tcl ../bin
cp bdd/bddDialog.tcl ../bin
cp pa/paDialog.tcl ../bin
cp versis/versisDialog.tcl ../bin
cp mc/mcDialog.tcl ../bin
cp strucval/strucvalDialog.tcl ../bin
cp ccs/ccsDialog.tcl ../bin
cp ../etc/est-bw.ico ../bin
make milocal "BINDIR=%BINDIR%"
cd ..

REM ..\mingw\info-zip\zip -o -q -r %EDITION%-%VERSION%-%OS%-mish.zip bin\*
REM ..\mingw\info-zip\zip -o -q %EDITION%-%VERSION%-%OS%-mish.zip etc\* -x .svn
REM ..\mingw\info-zip\zip -o -q %EDITION%-%VERSION%-%OS%-mish.zip data\* -x .svn
REM ..\mingw\info-zip\zip -o -q %EDITION%-%VERSION%-%OS%-mish.zip data\*\* -x .svn

%MYZIP% %EDITION%-%VERSION%-%OS%-mish.7z .\bin\*
%MYZIP% %EDITION%-%VERSION%-%OS%-mish.7z .\etc\* -x!.\etc\.svn
%MYZIP% %EDITION%-%VERSION%-%OS%-mish.7z .\data\* -x!.\data\.svn -x!.\data\*\.svn

echo Packaging %EDITION%-%VERSION%-%OS%-mish.exe ...

REM ..\mingw\FreeExtractor\MakeSFX /zip="%EDITION%-%VERSION%-%OS%-mish.zip" /sfx="%EDITION%-%VERSION%-%OS%-mish.exe" /title="Efficient Symbolic Tools package" /website="http://lms.uni-mb.si/EST/" /intro="%RELEASE%\n\nThis is binary distribution of %NAME%.\nThis is free software. See GNU GPL (version 2).\n\nYou need ActiveTcl installed on your computer.\nTo start the program click est.tcl in folder bin.\n\nFreeExtractor Wizard will make the following tasks:\n1. Files will be extracted into the target folder.\n2. A shortcut will be created on your desktop.\n\nNOTE: No registry entry will be changed and no file will be\n            created outside the target folder. You can uninstall\n            this software by simply deleting the target folder.\n\nRobert Meolic (meolic@uni-mb.si)" /defaultpath="C:\Program Files\%EDITION%" /shortcut="$desktop$\EST.LNK|$targetdir$\bin\est.tcl" /icon="etc\est-bw.ico" /overwrite

echo ;!@Install@!UTF-8! > cfg.cfg
echo Title="Efficient Symbolic Tools package" >> cfg.cfg
echo BeginPrompt="Efficient Symbolic Tools package (interactive version)\nVersion %VVERSION%\n\nThis is binary distribution of %NAME%.\n\nThis is free software. See GNU GPL (version 2).\n\nYou need ActiveTcl installed on your computer.\nTo start the program click est.tcl in folder bin.\n\nNOTE: No registry entry will be changed and no file will be\n           created outside the target folder. You can uninstall\n           this software by simply deleting the target folder.\n\nRobert Meolic (meolic@uni-mb.si)" >> cfg.cfg
echo ExtractPathText="Please, enter the target folder:" >> cfg.cfg
echo ExtractDialogText="Please, wait..." >> cfg.cfg
echo ExtractTitle="Extracting..." >> cfg.cfg
echo GUIFlags="8+32+64+256+4096" >> cfg.cfg
echo GUIMode="1" >> cfg.cfg
echo InstallPath="%ProgramFiles%\\est2ed" >> cfg.cfg
echo ;!@InstallEnd@! >> cfg.cfg

copy /b /y %SFX% + cfg.cfg + "%EDITION%-%VERSION%-%OS%-mish.7z" "%EDITION%-%VERSION%-%OS%-mish.exe"

rm %EDITION%-%VERSION%-%OS%-mish.7z
rm -fr bin

echo Creating %EDITION%-%VERSION%-%OS% ...

cd source
make lib "BINDIR=%BINDIR%"
make clean "BINDIR=%BINDIR%"
cp est.h ../bin
cd ../..

REM .\mingw\info-zip\zip -o -q -r %EDITION%\%EDITION%-%VERSION%-%OS%.zip %EDITION%\bin\*

%MYZIP% %EDITION%\%EDITION%-%VERSION%-%OS%.7z %EDITION%\bin\*

cd %EDITION%\source
make staticlib "BINDIR=%BINDIR%"
make clean "BINDIR=%BINDIR%"
cd ../..

REM .\mingw\info-zip\zip -o -q -r %EDITION%\%EDITION%-%VERSION%-%OS%.zip %EDITION%\bin\libest2.a
%MYZIP% %EDITION%\%EDITION%-%VERSION%-%OS%.7z %EDITION%\bin\libest2.a

cd %EDITION%
rm -fr bin

cd ..

REM .\mingw\info-zip\zip -o -q %EDITION%\%EDITION%-%VERSION%-%OS%.zip %EDITION%\projects\* -x .svn
REM .\mingw\info-zip\zip -o -q %EDITION%\%EDITION%-%VERSION%-%OS%.zip %EDITION%\projects\*\* -x .svn

%MYZIP% %EDITION%\%EDITION%-%VERSION%-%OS%.7z %EDITION%\projects\* -x!%EDITION%\projects\.svn -x!%EDITION%\projects\.svn -x!%EDITION%\projects\*\.svn

cd %EDITION%

echo Packaging %EDITION%-%VERSION%-%OS%.exe ...

echo ;!@Install@!UTF-8! > cfg.cfg
echo Title="Efficient Symbolic Tools package" >> cfg.cfg
echo BeginPrompt="Efficient Symbolic Tools package (libraries and projects)\nVersion %VVERSION%\n\nThis is free software. See GNU GPL (version 2).\n\nNOTE: No registry entry will be changed and no file will be\n           created outside the target folder. You can uninstall\n           this software by simply deleting the target folder.\n\nRobert Meolic (meolic@uni-mb.si)" >> cfg.cfg
echo ExtractPathText="Please, enter the target folder:" >> cfg.cfg
echo ExtractDialogText="Please, wait..." >> cfg.cfg
echo ExtractTitle="Extracting..." >> cfg.cfg
echo GUIFlags="8+32+64+256+4096" >> cfg.cfg
echo GUIMode="1" >> cfg.cfg
echo InstallPath="%ProgramFiles%\\libest2" >> cfg.cfg
echo ;!@InstallEnd@! >> cfg.cfg

copy /b /y %SFX% + cfg.cfg + "%EDITION%-%VERSION%-%OS%.7z" "%EDITION%-%VERSION%-%OS%.exe"

rm %EDITION%-%VERSION%-%OS%.7z
rm -f cfg.cfg

echo *******************
echo PACKAGES COMPLETED!
echo *******************
