# Use genStubs.tcl (/tools in TCL source package) to generate
# bddDecls.h and bddStubInit.c from this file.
#
# Procedure:
# touch bddDecls.h
# touch bddStubInit.c
# ./genStubs.tcl . bdd.decls
#
# Problem: if there are no arguments, you have to add parenthesis and
# remove some '*' in generated file bddDecls.h, moreover you have to
# remove '&' in generated file bddStubInit.c.

library bdd
interface bdd
declare 0 generic {
  int bdd_status
}
declare 1 generic {
  Bdd_Edge bdd_termTrue
}
declare 2 generic {
  Bdd_Edge bdd_termFalse
}
declare 3 generic {
  Bdd_Edge bdd_termNull
}
declare 4 generic {
  void Bdd_InitPkg()
}
declare 5 generic {
  void Bdd_ExitPkg()
}
declare 6 generic {
  void Bdd_AboutPkg()
}
declare 7 generic {
  Bdd_Edge Bdd_GetThen(Bdd_Edge f)
}
declare 8 generic {
  Bdd_Edge Bdd_GetElse(Bdd_Edge f)
}
declare 9 generic {
  Bdd_Variable Bdd_GetVariable(Bdd_Edge f)
}
declare 10 generic {
  Est_String Bdd_GetVariableName(Bdd_Edge f)
}
declare 11 generic {
  char Bdd_GetVariableChar(Bdd_Edge f)
}
declare 12 generic {
  Est_String Bdd_GetIthVariableName(int i)
}
declare 13 generic {
  int Bdd_GetVariableOrder(Bdd_Edge f)
}
declare 14 generic {
  Bdd_Edge Bdd_FoaTerminal(Est_String x)
}
declare 15 generic {
  Bdd_Edge Bdd_NOT(Bdd_Edge f)
}
declare 16 generic {
  Bdd_Edge Bdd_TransferMark(Bdd_Edge f, Est_Boolean mark)
}
declare 17 generic {
  Bdd_Edge Bdd_ITE(Bdd_Edge f, Bdd_Edge g, Bdd_Edge h)
}
declare 18 generic {
  Bdd_Edge Bdd_Restrict(Bdd_Edge f, Bdd_Variable v, Est_Boolean value)
}
declare 19 generic {
  Bdd_Edge Bdd_Compose(Bdd_Edge f, Bdd_Variable v, Bdd_Edge g)
}
declare 20 generic {
  Bdd_Edge Bdd_E(Bdd_Edge f, Bdd_Variable v)
}
declare 21 generic {
  Bdd_Edge Bdd_A(Bdd_Edge f, Bdd_Variable v)
}
declare 22 generic {
  void Bdd_IncCounter()
}
declare 23 generic {
  void Bdd_Fresh(Bdd_Edge f)
}
declare 24 generic {
  void Bdd_Fortify(Bdd_Edge f)
}
declare 25 generic {
  void Bdd_Garbage()
}
declare 26 generic {
  void Bdd_SystemStat(FILE *s)
}
declare 27 generic {
  int Bdd_FunctionStat(FILE *s, Bdd_Edge f)
}
declare 28 generic {
  Est_Boolean Bdd_FindFormula(Est_String x, Bdd_Edge *f)
}
declare 29 generic {
  void Bdd_AddFormula(Est_String x, Bdd_Edge f)
}
declare 30 generic {
  void Bdd_SaveFormula(Est_String prefix, Est_String name, Bdd_Edge f)
}
declare 31 generic {
  Bdd_Edge Bdd_ExtractBranch(Bdd_Edge f)
}
declare 32 generic {
  Bdd_Edge Bdd_Expand(Est_String fname, Bdd_Edge f)
}
declare 33 generic {
  Bdd_Edge Bdd_Expr(Est_String s)
}
declare 34 generic {
  void Bdd_WriteFunction(FILE *s, Est_String name)
}
declare 35 generic {
  void Bdd_WriteBDD(FILE *s, Est_String name)
}
declare 36 generic {
  int Bdd_WriteDot(FILE *s, Est_String name, int id)
}
declare 37 generic {
  int Bdd_WriteBDDView(FILE *s, Est_String name, int id)
}
declare 38 generic {
  int Bdd_WriteGraphML(FILE *s, Est_String name)
}
declare 39 generic {
  int Bdd_ReadGraphML(FILE *s)
}
declare 40 generic {
  Bdd_Edge Bdd_RelOp(Bdd_Edge f, Bdd_Edge g, Est_String format, Est_Boolean firsttime)
}
declare 41 generic {
  Bdd_Edge Bdd_RelOpSimple(Bdd_Edge f, Est_String format, Est_Boolean firsttime)
}
declare 42 generic {
  Bdd_Edge Bdd_RelOpComplex(Bdd_Edge f, Est_String format, Est_Boolean firsttime)
}
declare 43 generic {
  Bdd_Edge Bdd_NewState(Bdd_Edge f)
}
declare 44 generic {
  Bdd_Edge Bdd_NewState1(Bdd_Edge f, Est_String name)
}
declare 45 generic {
  Bdd_Edge Bdd_NewState2(Bdd_Edge f, Est_String name1, Est_String name2)
}
declare 46 generic {
  Bdd_Edge Bdd_NewEq(Bdd_Edge f, Bdd_Edge g)
}
