/**CFile*******************************************************************
  PackageName [ccs]
  Synopsis    [Package 'ccs' provides an extended CCS parser.]

  FileName    [ccsVerilog.l]
  Revision    [$Revision: 76 $]
  Date        [$Date: 2013-04-26 14:26:09 +0200 (pet, 26 apr 2013) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [File ccsVerilog.l is a flex file for Verilog parser.]
  SeeAlso     [ccs.h, ccsInt.h, ccsVerilog.y]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2013
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

MODULE          module
ENDMODULE       endmodule
INPUT           input
OUTPUT          output
WIRE            wire
ASSIGN          assign
FORK            fork
NOT             not|IV
AND             and|AN[2-4]
ANDINV          andinv
OR              or|OR[2-4]
ORINV           orinv
NAND            nand|ND[2-4]
NOR             nor|NR[2-4]
XOR             xor
C               c
CINV            cinv
ME              me
MEZ             mez
DFF             dff|FD1
TFF             tff
RSFF            rsff
JKFF            jkff
DQBFF           dff-wi
TQBFF           tff-wi
RSQBFF          rsff-wi
JKQBFF          jkff-wi
NAME            [-_A-Za-z0-9][-_A-Za-z0-9]*
COMMENT         \/\/.*

%%
  int ch, inComm;

"/*"              { for(inComm=1; inComm; )
                    { switch(ch=input())
 			{ case '\n' : break;
			  case '*'  : if (( ch=input()) == '/') inComm=0;
                                        else unput(ch);
				      break;
                        }
                    }
                  }

[ ]	          {/* preskok praznih mest */}

[\t\n\r]       	  {/* preskok praznega prostora */}

"'"	          {/* qoutes are ignored */}

"\""	          {/* qoutes are ignored */}

{MODULE}	  {return MODULE;}

{ENDMODULE}	  {return ENDMODULE;}

{INPUT}	          {return INPUT;}

{OUTPUT}	  {return OUTPUT;}

{WIRE}	          {return WIRE;}

{ASSIGN}	  {return ASSIGN;}

{FORK}	          {return FORK;}

{NOT}	          {return NOT;}

{AND}	          {return AND;}

{ANDINV}	  {return ANDINV;}

{OR}	          {return OR;}

{ORINV}	          {return ORINV;}

{NAND}	          {return NAND;}

{NOR}	          {return NOR;}

{XOR}	          {return XOR;}

{C}	          {return C;}

{CINV}	          {return CINV;}

{ME}	          {return ME;}

{MEZ}	          {return MEZ;}

{DFF}	          {return DFF;}

{TFF}	          {return TFF;}

{RSFF}	          {return RSFF;}

{JKFF}	          {return JKFF;}

{DQBFF}	          {return DQBFF;}

{TQBFF}	          {return TQBFF;}

{RSQBFF}	  {return RSQBFF;}

{JKQBFF}	  {return JKQBFF;}

{NAME}		  {
                   yylval.word = strdup(yytext);
                   return NAME;
                  }

"("	          {return yytext[0];}
")"	          {return yytext[0];}
"["	          {return yytext[0];}
"]"	          {return yytext[0];}
":"	          {return yytext[0];}
"="	          {return yytext[0];}
","	          {return yytext[0];}
";"	          {return yytext[0];}

{COMMENT}         {};

.                 {
                   return UNKNOWN;
                  }
%%
