#!/bin/sh
# the next line executes the program\
exec wish "$0" "$@"

# This is version 1.1

# Version 1.0 is given here due to the problems with
# "package ifneeded" in pkgIndex.tcl in the packages that use this.
package provide myinterface 1.0

# ############################################
# $Revision: 21 $
# $Date: 2013-03-25 10:16:58 +0100 (pon, 25 mar 2013) $
#
# This file (mi.tcl) is a Tcl/Tk script
# Author: Robert Meolic, meolic@uni-mb.si
#
# This file has been released into the public domain by
# the author.
#
# The author grants any entity the right to use this work
# for any purpose, without any conditions, unless such
# conditions are required by law.
#
# myinterface is used in EST project
# Homepage: http://lms.uni-mb.si/EST/
#
# Updates of myinterface from Robert Meolic
# are available in SVN repository:
# http://altair.uni-mb.si:8080/
# ############################################

global TITLE
global PROMPT
global VERSION
global ICONNAME

global MENU
global OUTPUTWINDOW
global INPUTWINDOW

global DEFAULTMENUFG
global DEFAULTMENUBG
global DEFAULTINPUTFG
global DEFAULTINPUTBG
global DEFAULTOUTPUTFG
global DEFAULTOUTPUTBG

global MENUFG
global MENUBG
global INPUTFG
global INPUTBG
global OUTPUTFG
global OUTPUTBG

global MENUITEMS
global BROWSETYPE

# if {$tcl_platform(osVersion) == "windows"} {
#   console show
# }

# puts $tcl_platform(platform)
# puts $tcl_platform(machine)
# puts $tcl_platform(os)
# puts $tcl_platform(osVersion)
# puts $tcl_patchLevel

if {![info exists TITLE]} {set TITLE "My Interface"}
if {![info exists PROMPT]} {set PROMPT "MI> "}
if {![info exists VERSION]} {set VERSION ""}
if {![info exists ICONNAME]} {set ICONNAME "My Interface"}

font create FONT -family Courier -size 12 -weight normal -slant roman
font create BUTTONFONT -family Helvetica -size 12 -weight bold -slant roman
font create MENUFONT -family Helvetica -size 12 -weight normal -slant roman
font create BIGFONT -family Helvetica -size 14 -weight normal -slant roman
font create BLACKFONT -family Helvetica -size 14 -weight bold -slant roman

wm title . $TITLE
wm iconname . $ICONNAME

. configure -highlightthickness 4

# ####################################################################
# MENU
# ####################################################################

option add *Menu.useMotifHelp true
option add *tearOff 0

menu .menuFrame
. configure -menu .menuFrame

set MENU .menuFrame
set MENUITEMS ""

# ####################################################################
# DIALOGS
# ####################################################################

if {[string compare [string range $tcl_patchLevel 0 2] "8.5"] == -1} {
  array set BROWSETYPE {}
} else {
  set BROWSETYPE [dict create ]
}

# ####################################################################
# OUTPUT
# ####################################################################

frame .output -borderwidth 0 -highlightthickness 0 -relief flat
pack .output -expand true -fill both
scrollbar .output.ys -borderwidth 0 -command ".output.t yview" -highlightthickness 0 -orient vertical
pack .output.ys -fill y -side right
text .output.t -borderwidth 0 -exportselection true -font FONT -height 24 -highlightthickness 0 -relief flat -selectbackground #ffffc0 -selectforeground #000040 -takefocus 0 -width 80 -yscrollcommand ".output.ys set"
pack .output.t -expand true -fill both -side left
set OUTPUTWINDOW .output.t

bind .output.t <ButtonPress-1> {
  .output.t configure -state disabled
}

bind .output.t <ButtonRelease-1> {
  .output.t configure -state normal
  .output.t mark set insert end
  focus .input.t
}

bind .output.t <ButtonPress-2> break
bind .output.t <ButtonRelease-2> break

bind .output.t <ButtonPress-3> break
bind .output.t <ButtonRelease-3> break

# ####################################################################
# INPUT
# ####################################################################

frame .input -borderwidth 1 -highlightthickness 0 -relief solid
pack .input -before .output -fill both -pady 4 -side bottom
text .input.t -borderwidth 0 -exportselection true -font FONT -height 4 -highlightthickness 0 -relief flat -selectbackground #ffffc0 -selectforeground #000040 -width 80 -wrap char
pack .input.t -fill both
set INPUTWINDOW .input.t

bind .input.t <Return> {
    getCommand [string trim [.input.t get limit end]]
    break
}

bind .input.t <Left> {
  if [.input.t compare insert <= limit] break
}

bind .input.t <BackSpace> {
  if [.input.t compare insert <= limit] break
}

bind .input.t <Up> {
  if { $HISTORYCURRENT > 0 } {
    .input.t delete limit end
    set HISTORYCURRENT [expr $HISTORYCURRENT - 1]
    .input.t insert insert [lindex $HISTORY $HISTORYCURRENT]
    .input.t see insert
  }
  break
}

bind .input.t <Down> {
  .input.t delete limit end
  if { $HISTORYCURRENT < $HISTORYNUMBER } {
    set HISTORYCURRENT [expr $HISTORYCURRENT + 1]
    .input.t insert insert [lindex $HISTORY $HISTORYCURRENT]
    .input.t see insert
  }
  break
}

bind .input.t <Home> {
  .input.t mark set insert limit
  break
}

bind .input.t <Prior> {
  .output.t yview scroll -1 pages
  break
}

bind .input.t <Next> {
  .output.t yview scroll 1 pages
  break
}

bind .input.t <Shift-Left> break
bind .input.t <Shift-Right> break
bind .input.t <Shift-Up> break
bind .input.t <Shift-Down> break
bind .input.t <Control-Any-Key> break

bind .input.t <Button1-Leave> break
bind .input.t <Button1-Enter> break
bind .input.t <ButtonPress-1> break
bind .input.t <ButtonRelease-1> break

bind .input.t <ButtonRelease-2> {inputPaste; break}
bind .input.t <ButtonRelease-3> break

bind .input.t <Button1-Motion> break
bind .input.t <Button2-Motion> break
bind .input.t <Button3-Motion> break

bind .input.t <Shift-1> break
bind .input.t <Shift-2> break
bind .input.t <Shift-3> break
bind .input.t <Control-1> break
bind .input.t <Control-2> break
bind .input.t <Control-3> break
bind .input.t <Double-1> break
bind .input.t <Double-2> break
bind .input.t <Double-3> break
bind .input.t <Triple-1> break
bind .input.t <Triple-2> break
bind .input.t <Triple-3> break

# ####################################################################
# ####################################################################

proc inputPaste {  } {
    set s ""
    catch { set s [selection get] }

    if {$s != ""} {
      set d [string first "\n" $s]
      while {$d != -1} {
        set l [string range $s 0 [expr $d - 1]]
        set s [string range $s [expr $d + 1] end]
        .input.t insert insert $l
        .input.t see insert
        getCommand $l
        set d [string first "\n" $s]
      }
      .input.t insert insert $s
      .input.t see insert
    }

}

proc evalCommand c {
    global HISTORY
    global HISTORYNUMBER
    global HISTORYCURRENT

    if {[string compare $c [lindex $HISTORY [expr $HISTORYNUMBER - 1]]]} {
      lappend HISTORY $c
      set HISTORYNUMBER [expr $HISTORYNUMBER + 1]
    }
    set HISTORYCURRENT $HISTORYNUMBER
    out ">"
    outline $c
    set code [catch {uplevel #0 $c} err]
    if {$code > 0} {
      out "TCL ERROR: "
      outline $err
    }

}

proc getCommand line {
    global PROMPT
    global INPUTLINE

    .input.t mark set insert end
    .input.t insert insert "\n"
    .input.t insert insert $PROMPT
    .input.t see insert
    .input.t mark set limit insert

    set d [expr [string length $line] - 1]
    if { $d >= 0} {
      if {[string index $line $d] == "\\"} {
        set INPUTLINE "$INPUTLINE [string trimright [string range $line 0 [expr $d - 1]]]"
      } else {
        set INPUTLINE "$INPUTLINE $line"
        evalCommand [string trimleft $INPUTLINE]
        set INPUTLINE ""
      }
    }

}

proc out line {
    .output.t insert insert $line
    .output.t see insert
    update idletasks
}

proc out1 line {
    .output.t insert insert $line
}

proc outline line {
    .output.t insert insert $line
    .output.t insert insert \n
    .output.t see insert
    update idletasks
}

proc getcolor { dest type } {
    global MENUFG
    global MENUBG
    global INPUTFG
    global INPUTBG
    global OUTPUTFG
    global OUTPUTBG

    switch -- $type {
        fg {switch -- $dest {
            input  {set color $INPUTFG}
            output {set color $OUTPUTFG}
            menu   {set color $MENUFG}
        }}
        bg {switch -- $dest {
            input  {set color $INPUTBG}
            output {set color $OUTPUTBG}
            menu   {set color $MENUBG}
        }}
    }

    return $color

}

proc setcolor { dest type color } {
    global INPUTWINDOW
    global OUTPUTWINDOW
    global MENU
    global MENUITEMS

    switch -- $type {
        fg {switch -- $dest {
            input {
                catch {$INPUTWINDOW configure -fg $color}
                catch {$INPUTWINDOW configure -insertbackground $color}
            }
            output {
                catch {$OUTPUTWINDOW configure -fg $color}
            }
            menu {
                catch {$MENU configure -fg $color}
                foreach item $MENUITEMS {
                  catch {$item configure -fg $color}
                }
            }
        }}
        bg {switch -- $dest {
            input {
                catch {$INPUTWINDOW configure -bg $color}
            }
            output {
                catch {$OUTPUTWINDOW configure -bg $color}
                catch {. configure -background $color}
                catch {. configure -highlightbackground $color}
                catch {. configure -highlightcolor $color}
            }
            menu {
                catch {$MENU configure -bg $color}
                foreach item $MENUITEMS {
                  $item configure -bg $color
                }
            }
        }}
    }

}

proc refresh {  } {
    global MENUFG
    global MENUBG
    global INPUTFG
    global INPUTBG
    global OUTPUTFG
    global OUTPUTBG
    global tcl_patchLevel

    if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] >= 0} {
      if {![string equal [tk windowingsystem] "aqua"]} {
        setcolor menu bg $MENUBG
        setcolor menu fg $MENUFG
      }
    }
    setcolor output bg $OUTPUTBG
    setcolor output fg $OUTPUTFG
    setcolor input bg $INPUTBG
    setcolor input fg $INPUTFG
}

proc print_log {  } {
    global OUTPUTWINDOW

    set f [open "est.log" w]
    puts $f [$OUTPUTWINDOW get 0.0 end]
    outline "Log has been stored in file est.log"
    close $f

}

proc print_selection {  } {
    global OUTPUTWINDOW

    if {[selection own] != ""} {
      set f [open "est.log" w]
      puts $f [selection get]
      outline "Selection has been stored in file est.log"
      close $f
    }

}

proc disable_input {  } {
    global INPUTWINDOW
    global OUTPUTWINDOW
    global MENU
    global MENUITEMS

    bind $OUTPUTWINDOW <ButtonPress-1> break
    bind $OUTPUTWINDOW <ButtonRelease-1> break
    bind $OUTPUTWINDOW <Button1-Motion> break

    $INPUTWINDOW configure -state disabled
    set i 1
    foreach item $MENUITEMS {
      $MENU entryconfigure $i -state disabled
      incr i
    }
}

proc enable_input {  } {
    global INPUTWINDOW
    global OUTPUTWINDOW
    global MENU
    global MENUITEMS

    bind $OUTPUTWINDOW <ButtonPress-1> {
      $OUTPUTWINDOW configure -state disabled
    }
    bind $OUTPUTWINDOW <Button1-Motion> {
    }
    bind .output.t <ButtonRelease-1> {
      $OUTPUTWINDOW configure -state normal
      $OUTPUTWINDOW mark set insert end
      focus $INPUTWINDOW
    }

    $INPUTWINDOW configure -state normal
    set i 1
    foreach item $MENUITEMS {
      $MENU entryconfigure $i -state normal
      incr i
    }
}

# ##########################################################
# xbrowse
# disabled because the implementation depends on BWidgets
# the node named root is the root of the tree and is not drawn
# Tree $t == create empty tree
# $t insert end parent node -text label == add item
# $t selection get == get item
# $t delete [$t nodes root] == delete complete tree
# ##########################################################

proc addTree {mylist t root} {
  set first [lindex $mylist 0]
  if { [llength $first] == 1 } {
    set nameX [join $first]

    #THIS IS USING BWIDGETS
    #$t insert end $root $nameX -text [join $first]

    addTree [lrange $mylist 1 end] $t $root
  } elseif { [llength $first] > 1 } {

    set firstname [lindex $first 0]
    while {[llength $firstname] > 1} {
      set firstname [lindex $firstname 0]
    }
    set firstname [join $firstname]

    set lastname [lindex $first end]
    while {[llength $lastname] > 1} {
      set lastname [lindex $lastname end]
    }
    set lastname [join $lastname]

    set nameX "$firstname.$lastname"

    #THIS IS USING BWIDGETS
    #$t insert end $root $nameX -text "$firstname ... $lastname" -fill darkblue

    addTree $first $t $nameX
    addTree [lrange $mylist 1 end] $t $root
  }
}

proc createTree {f list} {
  set MAXSIZE 8

  set n [llength $list]
  while {$n >= $MAXSIZE} {
    set g [expr $n / $MAXSIZE]
    for {set i 0} {$i < $g} {incr i} {
      set list [lreplace $list $i [expr $i + $MAXSIZE - 1] [lrange $list $i [expr $i + $MAXSIZE - 1]]]
    }
    set n [llength $list]
  }

  #THIS IS USING BWIDGETS
  #Tree $f.tree

  if {$list != ""} {
    addTree $list $f.tree root
    pack $f.tree -fill both -expand yes
  }

}

proc xbrowse { list } {

  toplevel .dialog
  wm title .dialog "Select"
  wm iconname .dialog "Select"
  wm geometry .dialog 640x480
  grab set .dialog

  frame .dialog.xbrowse -relief raised
  pack .dialog.xbrowse -expand yes -fill both

  createTree .dialog.xbrowse $list

  set x [expr {([winfo screenwidth .]-800)/2}]
  set y 60
  wm geometry .dialog +$x+$y

  frame .dialog.xbrowse.buttons -relief raised

  button .dialog.xbrowse.buttons.select -borderwidth 2 -command {

    #THIS IS USING BWIDGETS
    #set selecteditem [.dialog.xbrowse.tree selection get]

    if {$selecteditem != ""} {
      set selecteditem [join selecteditem]
      if {[.dialog.browseByName.tree nodes [join $selecteditem]] == ""} {
        outline "Selected: $selecteditem"
        destroy .dialog
      }
    }
  } -relief raised -text "Select" -width 6
  pack .dialog.xbrowse.buttons.select -padx 10 -side left

  button .dialog.xbrowse.buttons.cancel -borderwidth 2 -command {
    destroy .dialog
  } -relief raised -text "Cancel" -width 6
  pack .dialog.xbrowse.buttons.cancel -padx 10 -side right

  pack .dialog.xbrowse.buttons
}

# ##########################################################
# commonDialog
#
# BROWSE types defined in mi.tcl
#
# file%s        filename
# boolean%s     false or true
# term%s        list of given terminals
# optional%s    optional parameter, can be left out
# required%s    required parameter, if empty then use ""
# nonempty%s    required parameter, must not be equal to ""
#
# ##########################################################

if {[string compare [string range $tcl_patchLevel 0 2] "8.5"] == -1} {
  array set BROWSETYPE {file {{list {Select...}} {lindex $item 2} {fileBrowse $IFIELD}}}
  array set BROWSETYPE {boolean {{list {Select...}} {list false true} {termBrowse}}}
  array set BROWSETYPE {term {{list {Select...}} {lindex $item 2} {termBrowse}}}
  array set BROWSETYPE {optional {{lindex $item 3} {lindex $item 2} {paramBrowse optional}}}
  array set BROWSETYPE {required {{list} {lindex $item 2} {paramBrowse required}}}
  array set BROWSETYPE {nonempty {{list} {lindex $item 2} {paramBrowse nonempty}}}
} else {
  dict set BROWSETYPE file {{list {Select...}} {lindex $item 2} {fileBrowse $IFIELD}}
  dict set BROWSETYPE boolean {{list {Select...}} {list false true} {termBrowse}}
  dict set BROWSETYPE term {{list {Select...}} {lindex $item 2} {termBrowse}}
  dict set BROWSETYPE optional {{lindex $item 3} {lindex $item 2} {paramBrowse optional}}
  dict set BROWSETYPE required {{list} {lindex $item 2} {paramBrowse required}}
  dict set BROWSETYPE nonempty {{list} {lindex $item 2} {paramBrowse nonempty}}
}

proc refreshCmd { name1 name2 op } {
  global CMD
  global CMDEND
  global FIELD1
  global FIELD3
  global NFIELD

  for {set i 1} {$i<=$NFIELD} {incr i} {
    if {$FIELD3($i) == $FIELD1($i)} {set op "init"}
  }

  set cmd ""
  if {$op != "init"} {
    for {set i 1} {$i<=$NFIELD} {incr i} {
      set cmd1 [string trim $FIELD3($i)]
      if {([string index $cmd1 0] == "\[") && ([string index $cmd1 end] == "\]")} {
         #nop
      } else {
        set cmd1 [string map {\[ \\\[ \] \\\] \" \\\" \\ \\\\} $cmd1]
        set x [split $cmd1 " "]
        if {[lindex $x 0] == "process"} {
          set cmd1 "0 [lindex $x 1]"
        } else {
          if {[lindex $x 0] == "composition"} {
            set cmd1 "1 [lindex $x 1]"
          } else {
            if {[lindex $x 1] == "=="} {
              set cmd1 [lindex $x 0]
            } else {
              set num ""
              scan $FIELD3($i) "<%d>" num
              if {$num != ""} {
                set cmd1 $num
              } else {
                if {[llength $x] == 0} {
                  if {$FIELD1($i) != "~"} {
                    set cmd1 "\"\""
                  } else {
                    set cmd1 ""
              }
            } else {
                  if {[llength $x] > 1} {
                    set cmd1 "\"$cmd1\""
              }
        }
          }
            }
      }
        }
      }
      set cmd "$cmd $cmd1"
    }
  }

  .commonDialog.dialogFrame.input.input delete 0.0 end
  .commonDialog.dialogFrame.input.input insert end $CMD
  .commonDialog.dialogFrame.input.input insert end $cmd
  .commonDialog.dialogFrame.input.input insert end $CMDEND
}

proc fileBrowse { i } {
  global MENUFG
  global MENUBG
  global FIELD1
  global FIELD2
  global FIELD3
  global IFIELD
  global tcl_patchLevel

  if {[info exists FIELD3($IFIELD)]} {unset FIELD3($IFIELD)}
  set FIELD3($IFIELD) $FIELD1($IFIELD)

  button .commonDialog.dialogFrame.browse.$IFIELD.field -textvariable FIELD3($IFIELD) -font MENUFONT \
    -highlightthickness 0 -borderwidth 1 -relief solid -anchor w -padx 5 -width 30 \
    -command " \
         set filename \[tk_getOpenFile -title \"Select file...\" -filetypes \$FIELD2($i) -parent .commonDialog\] ;\
         if {\[string length \$filename\] != 0} {set FIELD3($i) \$filename} \
    "

  if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] >= 0} {
    if {![string equal [tk windowingsystem] "aqua"]} {
      .commonDialog.dialogFrame.browse.$IFIELD.field configure -foreground $MENUFG -background $MENUBG -activeforeground $MENUFG -activebackground $MENUBG
    }
  }

  if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] == -1} {
    trace variable FIELD3($IFIELD) w refreshCmd
  } else {
    trace add variable FIELD3($IFIELD) write refreshCmd
  }
}

proc termBrowse {  } {
  global MENUFG
  global MENUBG
  global FIELD1
  global FIELD2
  global FIELD3
  global IFIELD
  global tcl_patchLevel

  if {[info exists FIELD3($IFIELD)]} {unset FIELD3($IFIELD)}
  set FIELD3($IFIELD) $FIELD1($IFIELD)

  set list $FIELD2($IFIELD)

  set menu [eval tk_optionMenu .commonDialog.dialogFrame.browse.$IFIELD.field FIELD3($IFIELD) {$FIELD1($IFIELD)} $list]
  .commonDialog.dialogFrame.browse.$IFIELD.field configure -font MENUFONT -highlightthickness 0 -borderwidth 1 -indicatoron false -relief solid -anchor w -padx 5
  $menu configure -borderwidth 1 -font MENUFONT -activebackground #ffffc0 -activeforeground #000040 -activeborderwidth 1 -relief groove -tearoff 0

  if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] >= 0} {
    if {![string equal [tk windowingsystem] "aqua"]} {
      .commonDialog.dialogFrame.browse.$IFIELD.field configure -foreground $MENUFG -background $MENUBG -activeforeground $MENUFG -activebackground $MENUBG
      $menu configure -foreground $MENUFG -background $MENUBG
    }
  }

  if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] == -1} {
    trace variable FIELD3($IFIELD) w refreshCmd
  } else {
    trace add variable FIELD3($IFIELD) write refreshCmd
  }
}

proc paramBrowse { opt } {
  global MENUFG
  global MENUBG
  global FIELD1
  global FIELD2
  global FIELD3
  global IFIELD
  global tcl_patchLevel

  if {[info exists FIELD3($IFIELD)]} {unset FIELD3($IFIELD)}
  set FIELD3($IFIELD) $FIELD1($IFIELD)
  if {$opt == "optional"} {set FIELD1($IFIELD) "~"}
  if {$opt == "required"} {set FIELD1($IFIELD) "~~"}
  if {$opt == "nonempty"} {}

  entry .commonDialog.dialogFrame.browse.$IFIELD.field -textvariable FIELD3($IFIELD) -font MENUFONT -highlightthickness 0 -borderwidth 1 -relief solid -width $FIELD2($IFIELD) -state normal

  if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] >= 0} {
    if {![string equal [tk windowingsystem] "aqua"]} {
      .commonDialog.dialogFrame.browse.$IFIELD.field configure -foreground $MENUFG -background $MENUBG
    }
  }

  if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] == -1} {
    trace variable FIELD3($IFIELD) w refreshCmd
  } else {
    trace add variable FIELD3($IFIELD) write refreshCmd
  }

}

proc commonDialog {  } {
    global MENUFG
    global MENUBG
    global INPUTFG
    global INPUTBG
    global OUTPUTFG
    global OUTPUTBG
    global tcl_patchLevel

    global INPUTWINDOW
    global OUTPUTWINDOW
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global BROWSETYPE

    global FIELD1
    global FIELD2
    global IFIELD
    global NFIELD

    toplevel .commonDialog
    wm title .commonDialog $NAME
    wm iconname .commonDialog $NAME
    wm resizable .commonDialog false false

    if {[string compare [string range $tcl_patchLevel 0 2] "8.4"] >= 0} {
      if {[string equal [tk windowingsystem] "aqua"]} {
        focus -force .commonDialog
      }
    }
    grab set .commonDialog

    frame .commonDialog.dialogFrame -background $OUTPUTBG -relief raised
    pack .commonDialog.dialogFrame -fill x

    frame .commonDialog.dialogFrame.cmd -background $MENUBG -borderwidth 2 -relief raised
    label .commonDialog.dialogFrame.cmd.name -anchor w -font BIGFONT -background $MENUBG -foreground $MENUFG -text $NAME
    label .commonDialog.dialogFrame.cmd.syntax -anchor w -font BLACKFONT -background $MENUBG -foreground $MENUFG -text $SYNTAX
    pack .commonDialog.dialogFrame.cmd.name .commonDialog.dialogFrame.cmd.syntax -side left
    pack .commonDialog.dialogFrame.cmd -fill x -pady 4 -ipady 5

    label .commonDialog.dialogFrame.synopsis -anchor w -font BLACKFONT -background $OUTPUTBG -foreground $OUTPUTFG -relief flat -text "SYNOPSIS: $SYNOPSIS"
    pack .commonDialog.dialogFrame.synopsis -fill x -ipady 5

    frame .commonDialog.dialogFrame.browse -background $OUTPUTBG

    set IFIELD 0
    foreach item $BROWSE {
        incr IFIELD

        frame .commonDialog.dialogFrame.browse.$IFIELD -background $OUTPUTBG
        label .commonDialog.dialogFrame.browse.$IFIELD.text -font MENUFONT -background $OUTPUTBG -foreground $OUTPUTFG -relief flat -text "[lindex $item 1]:"

        set type [lindex $item 0]

        # FIELD1: Initial string/value
        # FIELD2: List of arguments/values (where applicable)
        # user setting for FIELD1 (i.e. [lindex $item 1]) is not used!

        if {[string compare [string range $tcl_patchLevel 0 2] "8.5"] == -1} {
          foreach {b1 b2} [array get BROWSETYPE]  {
            if {[string equal $b1 $type]} {
              set FIELD1($IFIELD) [eval [lindex $b2 0]]
              set FIELD2($IFIELD) [eval [lindex $b2 1]]
              eval [lindex $b2 2]
            }
          }
        } else {
          set FIELD1($IFIELD) [eval [lindex [dict get $BROWSETYPE $type] 0]]
          set FIELD2($IFIELD) [eval [lindex [dict get $BROWSETYPE $type] 1]]
          eval [lindex [dict get $BROWSETYPE $type] 2]
        }

        pack .commonDialog.dialogFrame.browse.$IFIELD.text -anchor s -side left
        pack .commonDialog.dialogFrame.browse.$IFIELD.field -anchor s -fill x -expand 1 -padx 5 -side left
        pack .commonDialog.dialogFrame.browse.$IFIELD -fill x -ipady 2
    }

    pack .commonDialog.dialogFrame.browse -anchor w -ipady 5

    label .commonDialog.dialogFrame.example -anchor w -background $OUTPUTBG -font MENUFONT -foreground $OUTPUTFG -relief flat -text "EXAMPLE: $EXAMPLE"
    pack .commonDialog.dialogFrame.example -fill x
    label .commonDialog.dialogFrame.explanation -anchor w -background $OUTPUTBG -font MENUFONT -foreground $OUTPUTFG -relief flat -text "EXPLANATION: $EXPLANATION"
    pack .commonDialog.dialogFrame.explanation -fill x
    frame .commonDialog.dialogFrame.input -background $OUTPUTBG
    pack .commonDialog.dialogFrame.input -fill x -ipady 10
    label .commonDialog.dialogFrame.input.text -background $OUTPUTBG -font MENUFONT -foreground $OUTPUTFG -text "INPUT LINE:"
    pack .commonDialog.dialogFrame.input.text -expand false -fill none -side left
    text .commonDialog.dialogFrame.input.input -background $INPUTBG -borderwidth 1 -foreground $INPUTFG -font FONT -height 1 -padx 4 -pady 4 -relief solid -width 60
    pack .commonDialog.dialogFrame.input.input -expand true -fill x -padx 5 -side right

    bind .commonDialog.dialogFrame.input.input <Return> break
    bind .commonDialog.dialogFrame.input.input <Up> break
    bind .commonDialog.dialogFrame.input.input <Down> break
    bind .commonDialog.dialogFrame.input.input <Shift-Left> break
    bind .commonDialog.dialogFrame.input.input <Shift-Right> break
    bind .commonDialog.dialogFrame.input.input <Shift-Up> break
    bind .commonDialog.dialogFrame.input.input <Shift-Down> break
    bind .commonDialog.dialogFrame.input.input <Control-Any-Key> break

    bind .commonDialog.dialogFrame.input.input <ButtonPress-2> break
    bind .commonDialog.dialogFrame.input.input <ButtonPress-3> break
    bind .commonDialog.dialogFrame.input.input <ButtonRelease-1> break
    bind .commonDialog.dialogFrame.input.input <ButtonRelease-2> break
    bind .commonDialog.dialogFrame.input.input <ButtonRelease-3> break
    bind .commonDialog.dialogFrame.input.input <Button1-Motion> break
    bind .commonDialog.dialogFrame.input.input <Button2-Motion> break
    bind .commonDialog.dialogFrame.input.input <Button3-Motion> break
    bind .commonDialog.dialogFrame.input.input <Shift-1> break
    bind .commonDialog.dialogFrame.input.input <Shift-2> break
    bind .commonDialog.dialogFrame.input.input <Shift-3> break
    bind .commonDialog.dialogFrame.input.input <Control-1> break
    bind .commonDialog.dialogFrame.input.input <Control-2> break
    bind .commonDialog.dialogFrame.input.input <Control-3> break
    bind .commonDialog.dialogFrame.input.input <Double-1> break
    bind .commonDialog.dialogFrame.input.input <Double-2> break
    bind .commonDialog.dialogFrame.input.input <Double-3> break
    bind .commonDialog.dialogFrame.input.input <Triple-1> break
    bind .commonDialog.dialogFrame.input.input <Triple-2> break
    bind .commonDialog.dialogFrame.input.input <Triple-3> break

    focus .commonDialog.dialogFrame.input.input

    set NFIELD $IFIELD
    refreshCmd "" "" init

    frame .commonDialog.dialogFrame.buttons -background $OUTPUTBG
    pack .commonDialog.dialogFrame.buttons -ipady 5
    button .commonDialog.dialogFrame.buttons.ok -background $MENUBG -borderwidth 2 -command {
      set l [string trim [.commonDialog.dialogFrame.input.input get 1.0 end]]
      $INPUTWINDOW insert insert $l
      $INPUTWINDOW see insert
      #getCommand $l #use this to execute commands immediately
      destroy .commonDialog
    } -font BUTTONFONT -foreground $MENUFG -relief raised -text OK -width 6
    pack .commonDialog.dialogFrame.buttons.ok -padx 10 -side left
    button .commonDialog.dialogFrame.buttons.cancel -background $MENUBG -borderwidth 2 -command {
      destroy .commonDialog
    } -font BUTTONFONT -foreground $MENUFG -relief raised -text Cancel -width 6
    pack .commonDialog.dialogFrame.buttons.cancel -padx 10 -side right
}

# ##########################################################
# mi_initPkg
# executed after gui construction
# ##########################################################

proc mi_initPkg { } {
  global PROMPT
  global INPUTLINE
  global HISTORY
  global HISTORYNUMBER
  global HISTORYCURRENT
  global MENU

  global DEFAULTMENUFG
  global DEFAULTMENUBG
  global DEFAULTINPUTFG
  global DEFAULTINPUTBG
  global DEFAULTOUTPUTFG
  global DEFAULTOUTPUTBG

  global MENUFG
  global MENUBG
  global INPUTFG
  global INPUTBG
  global OUTPUTFG
  global OUTPUTBG

  .input.t insert insert $PROMPT
  .input.t mark set limit insert
  .input.t mark gravity limit left

  set INPUTLINE ""
  set HISTORY {}
  set HISTORYNUMBER 0
  set HISTORYCURRENT 0

  set DEFAULTMENUFG #ffffff
  set DEFAULTMENUBG #008080
  set DEFAULTINPUTFG #ffffff
  set DEFAULTINPUTBG #008080
  set DEFAULTOUTPUTFG #ffffff
  set DEFAULTOUTPUTBG #408080

  set MENUFG $DEFAULTMENUFG
  set MENUBG $DEFAULTMENUBG
  set INPUTFG $DEFAULTINPUTFG
  set INPUTBG $DEFAULTINPUTBG
  set OUTPUTFG $DEFAULTOUTPUTFG
  set OUTPUTBG $DEFAULTOUTPUTBG

  refresh

  focus .input.t
}

# ##########################################################
# ##########################################################

mi_initPkg
