/*
 * Decompiled with CFR 0.152.
 */
package org.natto;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class StaticTools {
    public static boolean copyFileIfNeeded(File file, String thisDir) {
        boolean copyOK = true;
        try {
            String fullFn = file.getCanonicalPath();
            String fnOnly = file.getName();
            File futureFile = new File(thisDir, fnOnly);
            String fullfFn = futureFile.getCanonicalPath();
            if (!fullfFn.equals(fullFn)) {
                StaticTools.copyFileUsingStream(file, futureFile);
            }
        }
        catch (Exception e) {
            copyOK = false;
            e.printStackTrace();
        }
        return copyOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        OutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            if (is != null) {
                ((InputStream)is).close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    public static String join(Collection s, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static long getEpoch() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        long secondsSinceEpoch = calendar.getTimeInMillis() / 1000L;
        return secondsSinceEpoch;
    }

    public static String[] unZip(String zipFile) {
        return StaticTools.unZip(zipFile, false);
    }

    public static String[] unZip(String zipFile, boolean listOnly) {
        ArrayList<String> zipNames = new ArrayList<String>();
        byte[] buffer = new byte[1024];
        try {
            System.out.println("Checking " + zipFile);
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName = ze.getName();
                zipNames.add(fileName);
                if (!listOnly) {
                    int len;
                    File newFile = new File(fileName);
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        String[] fileArr = new String[zipNames.size()];
        zipNames.toArray(fileArr);
        return fileArr;
    }

    public static boolean fileIsELF(File file) {
        if (!file.exists()) {
            return false;
        }
        byte[] elfBytes = new byte[]{127, 69, 76, 70};
        byte[] fileBytes = new byte[4];
        try {
            FileInputStream fis = new FileInputStream(file);
            fis.read(fileBytes, 0, 4);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return Arrays.equals(elfBytes, fileBytes);
    }

    public static boolean fileIsELF(String fileName) {
        File file = new File(fileName);
        return StaticTools.fileIsELF(file);
    }

    static String execGet(String exeCmd, boolean stdErrToo) {
        String outPut = "";
        try {
            Process process = Runtime.getRuntime().exec(exeCmd);
            StreamReader reader = new StreamReader(process.getInputStream());
            StreamReader errReader = new StreamReader(process.getErrorStream());
            reader.start();
            errReader.start();
            process.waitFor();
            reader.join();
            errReader.join();
            outPut = reader.getResult();
            if (stdErrToo) {
                outPut = outPut + errReader.getResult();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outPut;
    }

    public static Properties getPropertiesFromFile(String fileName) {
        Properties myProp = new Properties();
        File propFile = new File(fileName);
        try {
            FileInputStream fis = new FileInputStream(propFile);
            myProp.load(fis);
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return myProp;
    }

    public static String getFileExt(String fname) {
        String myExt = null;
        int dotPos = fname.indexOf(".");
        if (dotPos > -1) {
            myExt = fname.substring(dotPos, fname.length());
        }
        return myExt;
    }

    public static String getFileContent(String fileName, int maxLines) {
        File readFile = new File(fileName);
        if (maxLines == 0) {
            maxLines = Integer.MAX_VALUE;
        }
        String retMe = "";
        int curLine = 0;
        if (readFile.exists() && readFile.canRead()) {
            try {
                FileInputStream fis = new FileInputStream(readFile);
                BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                String myLine = null;
                while ((myLine = br.readLine()) != null) {
                    retMe = retMe + myLine;
                    if (++curLine < maxLines) continue;
                }
                br.close();
                fis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        } else {
            return null;
        }
        return retMe;
    }

    public static String getFileContent(String fileName) {
        return StaticTools.getFileContent(fileName, 0);
    }

    static class StreamReader
    extends Thread {
        private InputStream is;
        private StringWriter sw = new StringWriter();

        public StreamReader(InputStream is) {
            this.is = is;
        }

        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getResult() {
            return this.sw.toString();
        }
    }
}

