import random
import sys
#travelling salesman, brute force
#Marko Niinimaki HEPIA 2013

#the nth_lexicographic_permutation from
#http://tafakuri.net/?p=68 from Project Euler by Mucheru  

usage = str(sys.argv[0])+" process_number nbrblocs cities_string\n"
cities = "abcdefghijk"

if sys.argv and len(sys.argv) > 3:
    cities = sys.argv[3]
else:
    #raise Exception("usage: " + usage)
    print "This program should be called: " + usage + \
          "This demo uses: 1 1 " + cities + "\n"

distances = dict()

def factorial(x): 
    if x==0 : 
        return 1
    else:
        return x * factorial(x-1)

def nth_lexicographic_permutation(initialPermutation, n):
     currPermutation=str(initialPermutation)
     if len(currPermutation) == 1: return initialPermutation
     residue = n
     # number of permutations starting with any one digit
     numSuffixPermutations = factorial(len(currPermutation) - 1)
     outputDigitIndex = 0
     if(numSuffixPermutations < residue):
         outputDigitIndex = residue / numSuffixPermutations
         #print str(residue)+" "+str(numSuffixPermutations)
         if (residue % numSuffixPermutations == 0):
             outputDigitIndex -= 1
         residue -= (outputDigitIndex * numSuffixPermutations)
     #print str(outputDigitIndex)+" "+str(numSuffixPermutations)
     indexDigit = currPermutation[outputDigitIndex]
     currPermutation = currPermutation.replace(indexDigit,'')
     return indexDigit + nth_lexicographic_permutation(currPermutation, residue)

def distance(permutation):
    tdist = 0
    for i in range(1,len(permutation)):
        city1 = permutation[i-1]
        city2 = permutation[i]
        fromto = city1+city2
        fromtodist = distances[fromto]
        tdist = tdist + fromtodist
    return tdist

#main


#make a distance hash
random.seed(100)
for frcity in cities:
    for tocity in cities:
        fromto = frcity+tocity
        tofrom = tocity+frcity
        if distances.has_key(fromto) or distances.has_key(tofrom):
            if distances.has_key(fromto): 
                distances[tofrom] = distances[fromto]
            else:
                distances[fromto] = distances[tofrom]
        else:
            distances[fromto] = random.randint(1,100)
        if (tocity == frcity):
            distances[fromto] = 0

#numcomputers is the number of computers working on this task
if sys.argv and len(sys.argv) > 3:
    numcomputers = int(sys.argv[2])
else:
    #raise Exception(usage)
    numcomputers = 1
#read param
mynumber = 0
if sys.argv and len(sys.argv) > 3:
    mynumber = sys.argv[1]
else:
    #raise Exception(usage)
    mynumber = 1
    #mynumber: which one of the computers is this

mynumber = int(mynumber)

if mynumber > numcomputers:
    raise Exception("max num is "+str(numcomputers))
#which block should this computer calculate
total = factorial(len(cities))
blocksize = total/numcomputers
starts = []
starts.append(1)
curblock=blocksize
while (curblock <= total):
    starts.append(curblock)
    curblock=curblock+blocksize

mystart = starts[mynumber-1]
myend = starts[mynumber]
#print str(starts)
#print "I am "+str(mynumber)+" calculating "+str(mystart)+ " to "+str(myend)



shortest = -1
shortestpath = ""
i = mystart
counter = 0
togo = myend-mystart
while i < myend:
    counter = counter+1
    if (counter % 100000 == 0):
        print "TELL done "+str(counter)+" out of "+str(togo)
        sys.stdout.flush()
    perm = nth_lexicographic_permutation(cities,i)
    dis = distance(perm)
    if (shortestpath == ""):
        shortestpath = perm
        shortest = dis
    if (dis < shortest):
        shortest = dis
        shortestpath = perm
    i = i+1

print "TELL " + str(shortest)+ " "+shortestpath


