% FUNCTION [...] = gf_global_function([operation [, args]])
%
%   General constructor for global_function objects.
%
%   Global function object is represented by three functions:
%   
%   * The function `val`.
%   * The function gradient `grad`.
%   * The function Hessian `hess`.
%   
%   this type of function is used as local and global enrichment function. The
%   global function Hessian is an optional parameter (only for fourth order
%   derivative problems).
%
%   * GF = gf_global_function('cutoff', int fn, scalar r, scalar r1, scalar r0)
%   Create a cutoff global function.
%
%   * GF = gf_global_function('crack', int fn)
%   Create a near-tip asymptotic global function for modelling cracks.
%
%   * GF = gf_global_function('parser', string val[, string grad[, string hess]])
%   Create a global function from strings `val`, `grad` and `hess`.
%
%   * GF = gf_global_function('product', global_function F, global_function G)
%   Create a product of two global functions.
%
%   * GF = gf_global_function('add', global_function gf1, global_function gf2)
%   Create a add of two global functions.
%
%
function [varargout]=gf_global_function(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('global_function', varargin{:});
  else
    gf_matlab('global_function', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
