% FUNCTION [...] = gf_mesh_im_set(mesh_im MI, [operation [, args]])
%
%   General function for modifying mesh_im objects
%   
%
%   * gf_mesh_im_set(mesh_im MI, 'integ',{integ im|int im_degree}[, ivec CVids])
%   Set the integration method.
%   
%   Assign an integration method to all convexes whose #ids are
%   listed in `CVids`. If `CVids` is not given, the integration is
%   assigned to all convexes. It is possible to assign a specific
%   integration method with an integration method handle `im` obtained
%   via gf_integ('IM_SOMETHING'), or to let getfem choose a suitable
%   integration method with `im_degree` (choosen such that polynomials
%   of `degree <= im_degree` are exactly integrated. If `im_degree=-1`,
%   then the dummy integration method IM_NONE will be used.)
%
%   * gf_mesh_im_set(mesh_im MI, 'adapt')
%   For a mesh_im levelset object only. Adapt the integration methods to a
%   change of the levelset function.
%
%
function [varargout]=gf_mesh_im_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mesh_im_set', varargin{:});
  else
    gf_matlab('mesh_im_set', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
