% FUNCTION [...] = gf_mdbrick_get(mdbrick MDB, [operation [, args]])
%
%   Get information from a brick, or launch the solver.
%   
%
%   * n = gf_mdbrick_get(mdbrick MDB, 'nbdof')
%   Get the total number of dof of the current problem.
%   
%   This is the sum of the brick specific dof plus the dof of the
%   parent bricks.
%
%   * d = gf_mdbrick_get(mdbrick MDB, 'dim')
%   Get the dimension of the main mesh (2 for a 2D mesh, etc).
%
%   * n = gf_mdbrick_get(mdbrick MDB, 'nb_constraints')
%   Get the total number of dof constraints of the current problem.
%   
%   This is the sum of the brick specific dof constraints plus the
%   dof constraints of the parent bricks.
%
%   * b = gf_mdbrick_get(mdbrick MDB, 'is_linear')
%   Return true if the problem is linear.
%
%   * b = gf_mdbrick_get(mdbrick MDB, 'is_symmetric')
%   Return true if the problem is symmetric.
%
%   * b = gf_mdbrick_get(mdbrick MDB, 'is_coercive')
%   Return true if the problem is coercive.
%
%   * b = gf_mdbrick_get(mdbrick MDB, 'is_complex')
%   Return true if the problem uses complex numbers.
%
%   * I = gf_mdbrick_get(mdbrick MDB, 'mixed_variables')
%   Identify the indices of mixed variables (typically the pressure,
%   etc.) in the tangent matrix.
%
%   * gf_mdbrick_get(mdbrick MDB, 'subclass')
%   Get the typename of the brick.
%
%   * gf_mdbrick_get(mdbrick MDB, 'param_list')
%   Get the list of parameters names.
%   
%   Each brick embeds a number of parameters (the Lame coefficients
%   for the linearized elasticity brick, the wave number for the
%   Helmholtz brick,...), described as a (scalar, or vector, tensor
%   etc) field on a mesh_fem. You can read/change the parameter values
%   with gf_mdbrick_get(mdbrick MDB, 'param') and gf_mdbrick_set(mdbrick MDB, 'param').
%
%   * gf_mdbrick_get(mdbrick MDB, 'param', string parameter_name)
%   Get the parameter value.
%   
%   When the parameter has been assigned a specific mesh_fem, it is returned
%   as a large array (the last dimension being the mesh_fem dof). When no
%   mesh_fem has been assigned, the parameter is considered to be constant
%   over the mesh.
%
%   * gf_mdbrick_get(mdbrick MDB, 'solve',mdstate mds[,...])
%   Run the standard getfem solver.
%   
%   Note that you should be able to use your own solver if you want
%   (it is possible to obtain the tangent matrix and its right hand
%   side with the gf_mdstate_get(mdstate MDS, 'tangent matrix') etc.).
%   
%   Various options can be specified:
%   
%   - 'noisy' or 'very noisy'
%   the solver will display some information showing the progress
%   (residual values etc.).
%   - 'max_iter', NIT
%   set the maximum iterations numbers.
%   - 'max_res', RES
%   set the target residual value.
%   - 'lsolver', SOLVERNAME
%   select explicitely the solver used for the linear systems (the
%   default value is 'auto', which lets getfem choose itself).
%   Possible values are 'superlu', 'mumps' (if supported),
%   'cg/ildlt', 'gmres/ilu' and 'gmres/ilut'.
%
%   * VM = gf_mdbrick_get(mdbrick MDB, 'von mises', mdstate mds, mesh_fem mfvm)
%   Compute the Von Mises stress on the mesh_fem `mfvm`.
%   
%   Only available on bricks where it has a meaning: linearized
%   elasticity, plasticity, nonlinear elasticity. Note that in 2D
%   it is not the "real" Von Mises (which should take into account
%   the 'plane stress' or 'plane strain' aspect), but a pure 2D Von
%   Mises.
%
%   * T = gf_mdbrick_get(mdbrick MDB, 'tresca', mdstate mds, mesh_fem mft)
%   Compute the Tresca stress criterion on the mesh_fem `mft`.
%   
%   Only available on bricks where it has a meaning: linearized
%   elasticity, plasticity, nonlinear elasticity.
%
%   * z = gf_mdbrick_get(mdbrick MDB, 'memsize')
%   Return the amount of memory (in bytes) used by the model brick.
%
%   * s = gf_mdbrick_get(mdbrick MDB, 'char')
%   Output a (unique) string representation of the mdbrick.
%   
%   This can be used to perform comparisons between two
%   different mdbrick objects.
%   This function is to be completed.
%   
%
%   * gf_mdbrick_get(mdbrick MDB, 'display')
%   displays a short summary for a mdbrick.
%
%
function [varargout]=gf_mdbrick_get(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdbrick_get', varargin{:});
  else
    gf_matlab('mdbrick_get', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
