% FUNCTION [...] = gf_mdstate_set(mdstate MDS, [operation [, args]])
%
%   Modify a model state object.
%   
%
%   * gf_mdstate_set(mdstate MDS, 'compute_reduced_system')
%   Compute the reduced system from the tangent matrix and constraints.
%
%   * gf_mdstate_set(mdstate MDS, 'compute_reduced_residual')
%   Compute the reduced residual from the residual and constraints.
%
%   * gf_mdstate_set(mdstate MDS, 'compute_residual', mdbrick B)
%   Compute the residual for the brick `B`.
%
%   * gf_mdstate_set(mdstate MDS, 'compute_tangent_matrix', mdbrick B)
%   Update the tangent matrix from the brick `B`.
%
%   * gf_mdstate_set(mdstate MDS, 'state', vec U)
%   Update the internal state with the vector `U`.
%
%   * gf_mdstate_set(mdstate MDS, 'clear')
%   Clear the model state.
%
%
function [varargout]=gf_mdstate_set(varargin)
  if (nargout),
    [varargout{1:nargout}]=gf_matlab('mdstate_set', varargin{:});
  else
    gf_matlab('mdstate_set', varargin{:});
    if (exist('ans', 'var') == 1), varargout{1}=ans; end;
  end;
% autogenerated mfile;
