#!/bin/bash

# Configuration
LIBGTASRC="$HOME/src/gta/sources/gta/libgta"
ZLIB_VERSION=1.2.7
BZIP2_VERSION=1.0.6
XZ_VERSION=5.0.4

set -e

function build_package ()
{
CROSSSHORTNAME="$1"
CROSSPREFIX="$2"

unset CPPFLAGS
unset CFLAGS
unset CXXFLAGS
unset LDFLAGS
D="`pwd`"
TMPD="`mktemp -d`"
cd "$TMPD"

tar xjvf "$D/zlib-$ZLIB_VERSION.tar.bz2"
cd zlib-$ZLIB_VERSION
make -f win32/Makefile.gcc PREFIX=$CROSSPREFIX- SHARED_MODE=1
make install -f win32/Makefile.gcc INCLUDE_PATH="$TMPD/install/include" LIBRARY_PATH="$TMPD/install/lib" BINARY_PATH="$TMPD/install/bin" SHARED_MODE=1
cd ..
ln -s ../bin/zlib1.dll install/lib/libz.dll

tar xzvf "$D/bzip2-$BZIP2_VERSION.tar.gz"
cd bzip2-$BZIP2_VERSION
sed -i 's,sys\\stat\.h,sys/stat.h,g' bzip2.c
sed -i 's,#ifdef _WIN32,#if 0,g' bzlib.h
make libbz2.a PREFIX="$TMPD/install" CC=$CROSSPREFIX-gcc AR=$CROSSPREFIX-ar RANLIB=$CROSSPREFIX-ranlib
$CROSSPREFIX-dlltool --export-all-symbols -D libbz2.dll -e exports.o -l libbz2.dll.a blocksort.o huffman.o crctable.o randtable.o compress.o decompress.o bzlib.o
$CROSSPREFIX-gcc -shared -o libbz2.dll blocksort.o huffman.o crctable.o randtable.o compress.o decompress.o bzlib.o exports.o
install -d "$TMPD/install/include"
install -m664 bzlib.h "$TMPD/install/include"
install -d "$TMPD/install/lib"
install -m664 libbz2.a "$TMPD/install/lib"
install -m664 libbz2.dll.a "$TMPD/install/lib"
install -d "$TMPD/install/bin"
install -m664 libbz2.dll "$TMPD/install/bin"
cd ..
ln -s ../bin/libbz2.dll install/lib/libbz2.dll

tar xzvf "$D/xz-$XZ_VERSION.tar.gz"
cd xz-$XZ_VERSION
./configure --host=$CROSSPREFIX --prefix="$TMPD/install" --disable-threads --disable-nls --disable-rpath
make -C src/liblzma install-strip
cd ../install/bin
LIBLZMADLL="`ls -1 liblzma-*.dll`"
cd ../..
ln -s ../bin/"$LIBLZMADLL" install/lib/liblzma.dll
rm install/lib/liblzma.la
rm -r install/lib/pkgconfig
rm -r install/share

# Build
mkdir build
cd build
# 1. Only the DLLs
"$LIBGTASRC"/configure --host=$CROSSPREFIX --build="`"$LIBGTASRC"/build-aux/config.guess`" \
	--prefix="$TMPD/install" CFLAGS="-W -Wall -O2" \
	--docdir="$TMPD"/install/doc --disable-reference --disable-static --disable-rpath --disable-la-file
make
make install-strip
# 2. Only the static libs
"$LIBGTASRC"/configure --host=$CROSSPREFIX --build="`"$LIBGTASRC"/build-aux/config.guess`" \
	--prefix="$TMPD"/install CFLAGS="-W -Wall -O2" \
	--docdir="$TMPD"/install/doc --disable-shared --disable-rpath --disable-la-file
make
make install-strip
cd ..
rm -r install/lib/pkgconfig
ln -s ../bin/libgta-0.dll install/lib/libgta.dll

# Modify installation
cp install/lib/libz.dll.a install/lib/libz.lib
cp install/lib/libbz2.dll.a install/lib/libbz2.lib
cp install/lib/liblzma.dll.a install/lib/liblzma.lib
cp install/lib/libgta.dll.a install/lib/libgta.lib
VERSION="`grep " GTA_VERSION " install/include/gta/gta_version.h | sed -e 's/.*"\(.*\)"/\1/'`"
for i in AUTHORS COPYING NEWS README; do
	cp "$LIBGTASRC"/"$i" install/doc
	recode ../crlf install/doc/"$i"
done
cd "$LIBGTASRC"/..
git log --date=iso --stat libgta > "$TMPD/install/doc/ChangeLog"
cd "$TMPD"
recode ../crlf install/doc/ChangeLog
cat > install/README.txt <<EOF
This package contains libgta and its prerequisites libz, libbz2, and liblzma.

See http://gta.nongnu.org/ for more information on this software.

This package was produced on a GNU/Linux system using
1) The gcc $CROSSPREFIX cross-compiler package
2) The following library packages:
   http://zlib.net/zlib-$ZLIB_VERSION.tar.bz2
   http://www.bzip.org/$BZIP2_VERSION/bzip2-$BZIP2_VERSION.tar.gz
   http://tukaani.org/xz/xz-$XZ_VERSION.tar.gz
3) The script doc/build-package.sh
EOF
recode ../crlf install/README.txt
cat > install/README-VisualStudio.txt <<EOF
To use the DLLs in Visual Studio, please use the linker option /OPT:NOREF.

You can change this setting at Project Properties -> Configuration Properties
-> Linker -> Optimization -> References -> Keep Unreferenced Data (/OPT:NOREF).

This is the default in Debug mode, but Release mode usually sets /OPT:REF
instead.

The reason for this is a bug in binutils/dlltool; see
http://sourceware.org/bugzilla/show_bug.cgi?id=12633

This will probably be fixed in future versions.
EOF
recode ../crlf install/README-VisualStudio.txt
cp "$D/build.sh" install/doc/build-package.sh
find install -type f -exec chmod 644 {} \;
find install -type d -exec chmod 755 {} \;

# Make archive
cp -a install libgta-"$VERSION"-$CROSSSHORTNAME
zip -9 -v -r libgta-"$VERSION"-$CROSSSHORTNAME.zip libgta-"$VERSION"-$CROSSSHORTNAME
cp libgta-"$VERSION"-$CROSSSHORTNAME.zip "$D"
chmod 644 "$D"/libgta-"$VERSION"-$CROSSSHORTNAME.zip

# Cleanup
cd "$D"
echo "Work directory was $TMPD"
#rm -rf "$TMPD"
}


# Preparation
if [ ! -d "$LIBGTASRC" ]; then
	echo "Please edit this script and set the path to your libgta sources."
	exit 1
fi
if [ ! -f zlib-$ZLIB_VERSION.tar.bz2 ]; then
	wget http://zlib.net/zlib-$ZLIB_VERSION.tar.bz2
fi
if [ ! -f bzip2-$BZIP2_VERSION.tar.gz ]; then
	wget http://www.bzip.org/$BZIP2_VERSION/bzip2-$BZIP2_VERSION.tar.gz
fi
if [ ! -f xz-$XZ_VERSION.tar.gz ]; then
	wget http://tukaani.org/xz/xz-$XZ_VERSION.tar.gz
fi

# Cross compiler to use
build_package w32 i686-w64-mingw32
build_package w64 x86_64-w64-mingw32
