<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<?php
if (isset($display) && $display=="man") {
?>
<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $manual_page['title'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $manual_page['man'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_man'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['man'])) {
				foreach($lang['man'] as $key => $i):
				?>
				<p>
					<?php
					if (isset($manual_page) && $manual_page['man_id'] == $key) {
						echo $i[1];
					}
					else {
					?>
					<a href="spl_view.php?man=1&amp;man_id=<?php echo $key;?>"><?php echo $i[1];?></a><br />
					<?php }?>
				</p>
				<?php
				endforeach;
				}
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<?
}
else {
?>

	<div class="col_left1">
		<?php 
		if (isset($_SESSION['user_firstname'])) {
		?>
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_welcome'] . " " . $_SESSION['user_firstname'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_introduction'];?><br />
					</div>
				</div>
			</div>
			
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
			
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_membership'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_membership_introduction'];?><br />
						<p>
							<a href="my_membership.php"><?php echo $lang['href_membership'];?></a><br />
						</p>
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
			
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_profile'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_profile_introduction'];?><br />
						<p>
							<a href="my_profile.php"><?php echo $lang['href_profile'];?></a><br />
						</p>
					</div>
				</div>
			</div>
			
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
		
		<?php
		}
		else {
		?>
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_welcome'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_public_introduction'];?><br />
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
		<?php }?>
	</div>
	
	<div class="col_right1">
		<?php 
		if (isset($_SESSION['user_firstname'])) {
			if ($this->user_acs->checkPermission($resource_ids['network'], $privilege_ids['allow_access'])) { //resourece_id, Priv_id
			?>
				<div class="box">
					<div class="box_top">
						<?php echo $lang['hdr_friends'];?><br />
					</div>
					
					<div class="box_mid">
						<div class="content">
							<?php echo $lang['txt_friends_introduction'];?><br />
							<p>
							<a href="sn_invite.php"><?php echo $lang['href_friends'];?></a><br />
							</p>
						</div>
					</div>
				</div>
				
				<div class="box_bottom">
					<span class="box_bottom_right"></span>
					<span class="box_bottom_left"></span>
				</div>
			<?php }?>
			
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_help'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_help_introduction'];?><br />
						<p>
							<a href="spl_view.php?man=1"><?php echo $lang['href_help1'];?></a><br />
						</p>
					</div>
				</div>
			</div>
			
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
		<?php
		}
		else {
		?>
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_login'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<form action="spl_view.php" method="post">
						
						<p>
							<input type="hidden" name="http_referer" value="<?php if (isset($http_referer)) { echo $http_referer;}?>" />
							<label for="id_email"><?php echo $lang['txt_email'];?></label><br />
						</p>
						
						<p>
							<input id="id_email" type="text" name="email" size="20" value="" style="width: 140px" /><br />
						</p>
						
						<p>
							<label for="id_password"><?php echo $lang['txt_password'];?></label><br />
						</p>
						
						<p>
							<input id="id_password" type="password" name="password" size="12" value="" style="width: 100px" /><br />
						</p>
						
						<p>
							<?php echo $lang['txt_login_note'];?><br />
						</p>
						
						<p align="right">
							<input type="submit" name="login" value="enter" class="button_urgent" /><br />
						</p>
						
						</form>
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
			
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_password'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_new_password'];?><br />
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
		<?php }?>
			
		<div class="box">
			<div class="box_top">
				<?php echo $lang['hdr_about_Igloo'];?><br />
			</div>
			
			<div class="box_mid">
					<div class="content">
					<?php echo $lang['txt_about_Igloo'];?><br />
				
					<p align="right">
						<a href="http://www.barnraiser.org/" title="Igloo is created by Barnraiser. Click to visit our web site."><img src="<?php echo $templatePath;?>img/igloo_small.png" width="90" height="46" alt="" border="0" /></a><br />
					</p>
				</div>
			</div>
		</div>
			
		<div class="box_bottom">
			<span class="box_bottom_right"></span>
			<span class="box_bottom_left"></span>
		</div>
		
		<div class="box">
			<div class="box_top">
				<?php echo $lang['hdr_credits'];?><br />
			</div>
			
			<div class="box_mid">
				<div class="content">
					<?php echo $lang['txt_credits'];?><br />
				</div>
			</div>
		</div>
			
		<div class="box_bottom">
			<span class="box_bottom_right"></span>
			<span class="box_bottom_left"></span>
		</div>
	</div>
<?php }?>
