<?php

// -----------------------------------------------------------------------
// This file is part of Igloo
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "structure";
include "inc/header.inc.php";

//ACS check
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['administration'], $c_acs['arr_acs']['privilege']['allow_membership'])) { //resourece_id, Priv_id
	header("Location: " . $_SESSION['user_homepage'] . "?" . strip_tags(SID));
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_acs.lang.php');


//setup useradmin (extends user)
require_once('class/User.class.php');
require_once('class/UserAdmin.class.php');
$user = new UserAdmin($db, $date);



//process requests
if (isset($_POST['update_user'])) {
	$frmdata['user_file_allocation'] = $frmdata['user_file_allocation']*1000;
	$user->user_id = $frmdata['user_id'];
	$user->updateAdminUser($frmdata);
	
	if (empty($user->log)) {
		return header("Location: node_user.php?user_id=" . $frmdata['user_id'] . "&" . strip_tags(SID));
		exit;
	}
	
	
}
elseif (isset($_REQUEST['edit_user'])) {
	$user->user_id = $_REQUEST['user_id'];
	$output_user = $user->getUser();
	
	$display = "edit_user";
}
elseif (isset($_REQUEST['user_id'])) {
	$user->user_id = $_REQUEST['user_id'];
	$output_user = $user->getUser();
	$output_profile = $user->selProfile();
	
	//setup file
	$file->noimage = $c_node['file']['image']['thumb'][1]['noimage'];
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	
	if (isset($output_profile['file_id'])) {
		$file->file_id = $output_profile['file_id'];
		$output_profile['image'] = $file->getFileRecord();
	}
	elseif (isset($output_profile)) {
		$output_profile['image']['file_title'] = "";
		$output_profile['image']['file'] = $file->noimage;
	}

	$display = "view_user";
}
else {
	$user->order_by = "u.user_firstname";
	$output_users = $user->selUsers();
}




//move to template
if (!empty($output_users)) {
	$body->set('users', $output_users);
}

if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_profile)) {
   $body->set('profile', $output_profile);
}

include "inc/footer.inc.php";

?>
