<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

//Note setlocale(); is set in the User.class.php at login this will affect date output.

class Date {
	// CLASS FUNCTIONS
	// Date
	// formatDate
	// dateDropdown
	// getMonthString
	// getMonthTime
	// getDayString
	// getDayTime
	// getToday
	// cutDate
	// cutTime
	// formatFormDateTime


	// Date --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 19th April 2004
	//
	function Date() {
		//no setup required
	}
	
	
	
	// formatDate --------------------------------------------------------------------
	// Set the format of the date based on the style requested.
	// tom calthrop - 19th April 2004
	//
	function formatDate($datetime, $style = null)  {
		if (isset($datetime) && $datetime != "0000-00-00 00:00:00") {

			$y = substr($datetime,0,4);
			$m = substr($datetime,5,2);
			$d = substr($datetime,8,2);
			$h = substr($datetime,11,2);
			$i = substr($datetime,14,2);
			
			if (isset($style)) {
			    if ($style == 1) {
			        //$datetime = date("M-d-Y H:i", mktime($h,$i,0, $m, $d, $y));
					$datetime = strftime("%b-%d-%Y %H:%M", mktime($h,$i,0, $m, $d, $y));
			    }
				elseif ($style == 2) {
			        //$datetime = date("M-d", mktime(0,0,0, $m, $d, $y));
					$datetime = strftime("%b-%d", mktime(0,0,0, $m, $d, $y));
			    }
				elseif ($style == 3) {
			        //time only
					$datetime = strftime("%H:%M", mktime($h,$i,0, $m, $d, $y));
			    }
				elseif ($style == 4) {
			        //weekly
					$datetime = strftime("%a %H:%M", mktime($h,$i,0, $m, $d, $y));
			    }
				elseif ($style == 5) {
			        //monthly
					$datetime = strftime("%d %H:%M", mktime($h,$i,0, $m, $d, $y));
			    }
				elseif ($style == 6) {
			        //yearly
					$datetime = strftime("%b-%d %H:%M", mktime($h,$i,0, $m, $d, $y));
			    }

			}
			else {
				//default datetime format
				//$datetime = date("M-d-Y", mktime(0,0,0, $m, $d, $y));
				$datetime = strftime("%b-%d-%Y", mktime(0,0,0, $m, $d, $y));
			}

			return $datetime;
		}
	}//EO formatDate

	
	
	// dateDropdown --------------------------------------------------------------------
	// if $showtime is set we show time as well
	// tom calthrop - 19th April 2004
	//
	function dateDropdown ($current = null, $showtime = null, $prefix = null, $minus_year = null, $years = null, $special = null) {

		if (isset($prefix)) {
		    $prefix = $prefix . "_";
		}
		else {
		    $prefix = "";
		}

		$date  = date('Y-m-d h:i:s');
		$year  = substr($date, 0,4);
		$month = substr($date, 5,2);
		$day   = substr($date, 8,2);

		$current_year = substr($current, 0,4);
		$current_month = substr($current, 5,2);
		$current_day = substr($current, 8,2);

		if (isset($showtime)) {
		    $hr   = substr($date, 11,2);
			$min   = substr($date, 14,2);

			$current_hr = substr($current, 11,2);
			$current_min = substr($current, 14,2);
		}

		//get the start year
		if (isset($minus_year)) {
		    $value = $year - $minus_year;
		}
		else {
			$value = 1900;
		}

		//get the number of years shown
		if (isset($years)) {
		    $year = $value + $years;
		}


		if(empty($special)) {
			$output = "<select name='" . $prefix . "year' class='formInput'>";
			//while($value<=$year)
			for($i = $value; $i<=$year; $i++)
			{
				$selected = "";

				if ($current_year == $i) {
					$selected = " selected";
				}


				$output .= "<option value=" . $i . $selected . ">" . $i;
				unset ($selected);
				//$value++;
			}
			$output .= "</select>&nbsp;";

			$output .= "<select name='" . $prefix . "month' class='formInput'>";
		}
		else
			$output = "<select name='" . $prefix . "month' class='formInput'>";

		for($i=1; $i<=12; $i++)
		{
			$selected = "";

			if ($current_month == $i) {
			    $selected = " selected";
			}

			if($i<10)
				$value = "0".$i;
			else
				$value = $i;

			$output .= "<option value=" . $value . $selected . ">" . $value;
			unset ($selected);
		}
		$output .= "</select>&nbsp;";

		if(!empty($special) & $special==9)
			$output = "<select name='" . $prefix . "day' class='formInput'>";
		else
			$output .= "<select name='" . $prefix . "day' class='formInput'>";

		for($i=1; $i<=31; $i++)
		{
			$selected = "";

			if ($current_day == $i) {
			    $selected = " selected";
			}

			if($i<10)
				$value = "0".$i;
			else
				$value = $i;
			$output .= "<option value=" . $value . $selected . ">" . $value;
			unset ($selected);

		}
		$output .= "</select>&nbsp;";

		if (isset($showtime) & empty($special)) {
			$output .= "<select name='" . $prefix . "hour' class='formInput'>";
			for($i=0; $i<=23; $i++)
			{
				$selected = "";

				if ($current_hr == $i) {
				    $selected = " selected";
				}

				if($i<10)
					$value = "0".$i;
				else
					$value = $i;

				$output .= "<option value=" . $value . $selected . ">" . $value;
				unset ($selected);
			}
			$output .= "</select>&nbsp;";

			$output .= "<select name='" . $prefix . "minute' class='formInput'>";
			for($i=0; $i<=59; $i++)
			{
				$selected = "";

				if ($current_min == $i) {
				    $selected = " selected";
				}

				if($i<10)
					$value = "0".$i;
				else
					$value = $i;

				$output .= "<option value=" . $value . $selected . ">" . $value;
				unset ($selected);
			}
			$output .= "</select>&nbsp;";

		}


		return $output;
	}//EO dateDropdown
	
	
	
	// getMonthString --------------------------------------------------------------------
	// tom calthrop - 19th April 2004
	//
	function getMonthString($time) {
		//return date("F Y", $time);
		return strftime(" %B %Y", $time);
	}// getMonthString
	
	
	
	// getMonthTime --------------------------------------------------------------------
	// tom calthrop - 19th April 2004
	//
	function getMonthTime($time, $shift) {
		$d = date("d", $time);
		$m = date("m", $time)+$shift;
		$y = date("Y", $time);

		if(date("m", $time)+$shift<1)
		{
			$m = 12;
			$y = date("Y", $time)-1;
		}


		$time = mktime(0, 0, 0, $m, $d,  $y);

		return $time;
	}//EO getMonthTime
	
	
	
	// getDayString --------------------------------------------------------------------
	// tom calthrop - 19th April 2004
	//
	function getDayString($time, $shift="") {
		if(!empty($shift))
			$time = strtotime("$shift day", $time);
		return strftime("%A %e %B %Y", $time);
	}//EO getDayString
	
	
	
	// getDayTime --------------------------------------------------------------------
	// tom calthrop - 19th April 2004
	//
	function getDayTime($time, $shift) {
		$da = date("d", $time);
		$mo = date("m", $time);
		$yr = date("Y", $time);
		$hr = date("G", $time);
		$mi = date("i", $time);
		$se = date("s", $time);

		$time = strtotime("$shift day", mktime($hr, $mi, $se, $mo, $da,  $yr));

		return $time;
	}//EO getDayTime
	
	
	
	// getToday --------------------------------------------------------------------
	// used in the top of the template to display todays date
	// tom calthrop - 19th April 2004
	//
	function getToday() {
		$today  = date('Y-m-d');

		return $today;
	}//EO getToday
	
	
	// cutDate --------------------------------------------------------------------
	// formats date as dd-mm-yyyy for forms
	// tom calthrop - 25th March 2004
	//
	function cutDate($date) {
		$date = substr($date,0,10);
		$date = substr('/', '-', $date);
		return $date;
	}//EO getToday
	
	
	// cutTime --------------------------------------------------------------------
	// formats date as hh:mm for forms
	// tom calthrop - 25th March 2004
	//
	function cutTime($time) {
		$time = substr($time,11,15);
		return $time;
	}//EO cutTime
	
	
	// formatFormDateTime --------------------------------------------------------------------
	// checks date data from form
	// tom calthrop - 28th March 2005
	//
	function formatFormDateTime($date, $time=null, $date_only=null) {
		$date = trim($date);
		$dt = preg_split("/[-]+/", $date);
		
		//check month
		if (empty($dt[1]) || !is_numeric($dt[1]) || $dt[1]>12) {
			$dt_error[] = "month error";
		}
		
	
		//check day
		if (empty($dt[2]) || !is_numeric($dt[2]) || $dt[2]>31) {
			$dt_error[] = "day error";
		}
	
		//check year
		if (empty($dt[0]) || !is_numeric($dt[0]) || $dt[0]<=1970 || strlen($dt[0]) != 4) {
			$dt_error[] = "year error";
		}
		
		if (!empty($dt_error)) {
			$GLOBALS['am_error_log'][] = array(34, null, null);
		}
		
		if (isset($time)) {
			$time = trim($time);
			$tm = preg_split("/[:]+/", $time);
			
			//check hour
			if (!isset($tm[0]) || $tm[0]>24 || $tm[0]<0) {
				$dt_error[] = "hour error";
			}
			
			//check minutes
			if (!isset($tm[1]) || $tm[1]>59 || $tm[1]<0) {
				$dt_error[] = "min error";
			}
		}
		else {
			$tm = array(0,0);
		}
		
		if (!empty($dt_error)) {
			$GLOBALS['am_error_log'][] = array(35, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			if (isset($date_only)) {
				return date("Y-m-d", mktime($tm[0], $tm[1], 0,  $dt[1], $dt[2], $dt[0]));
			}
			else {
				return date("Y-m-d H:i:s", mktime($tm[0], $tm[1], 0,  $dt[1], $dt[2], $dt[0]));
			}
		}
	}//EO formatFormDateTime
	
	
	// setAlarmTime --------------------------------------------------
	// takes a date and removes X minute to get the alarm time
	// tom calthrop - 11th September 2005
	//
	function setAlarmTime($origin_datetime, $minus_minutes) {
		
		$year  = substr($origin_datetime, 0,4);
		$month = substr($origin_datetime, 5,2);
		$day   = substr($origin_datetime, 8,2);
		$hr   = substr($origin_datetime, 11,2);
		$min   = substr($origin_datetime, 14,2);
		
		return date("Y-m-d H:i:s", mktime($hr, $min, 0, $month, $day,  $year)-(60*$minus_minutes));
	
	} //EO setAlarmTime
	
	
	// getAlarmMinutes --------------------------------------------------
	// works the difference between two times and returns the result in minutes
	// tom calthrop - 11th September 2005
	//
	function getAlarmMinutes($start_datetime, $alarm_datetime) {
		
		$year  = substr($start_datetime, 0,4);
		$month = substr($start_datetime, 5,2);
		$day   = substr($start_datetime, 8,2);
		$hr   = substr($start_datetime, 11,2);
		$min   = substr($start_datetime, 14,2);
		
		$start = mktime($hr, $min, 0, $month, $day,  $year);
		
		$year  = substr($alarm_datetime, 0,4);
		$month = substr($alarm_datetime, 5,2);
		$day   = substr($alarm_datetime, 8,2);
		$hr   = substr($alarm_datetime, 11,2);
		$min   = substr($alarm_datetime, 14,2);
		
		$alarm = mktime($hr, $min, 0, $month, $day,  $year);
		
		return ($start-$alarm)/60;;
		
		
	} //EO getAlarmMinutes
}
