/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.model;

import java.io.File;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import net.jatec.ironmailer.framework.StringTools;
import net.jatec.ironmailer.model.ModelException;
import org.apache.log4j.Logger;

public class FileAttachment {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$model$FileAttachment == null ? (class$net$jatec$ironmailer$model$FileAttachment = FileAttachment.class$((String)"net.jatec.ironmailer.model.FileAttachment")) : class$net$jatec$ironmailer$model$FileAttachment));
    private File file;
    private long size;
    private String sizeAsString;
    private String name;
    private MimeBodyPart mimeBodyPart;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$FileAttachment;

    public FileAttachment(File file) throws ModelException {
        this.file = file;
        this.size = file.length();
        this.sizeAsString = StringTools.sizeToString((long)this.size);
        this.name = file.getName();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("FileAttachment() created with name=" + this.name + ", size=" + this.sizeAsString));
        }
        try {
            this.mimeBodyPart = new MimeBodyPart();
            this.mimeBodyPart.setFileName(this.name);
            this.mimeBodyPart.setDataHandler(new DataHandler((DataSource)new FileDataSource(file)));
        }
        catch (MessagingException messagingException) {
            throw new ModelException("model initialized with crap", (Throwable)messagingException);
        }
    }

    public void destroy() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"destroy() called");
        }
        try {
            if (!this.file.delete()) {
                this.log.warn((Object)("trying to delete temporary file " + this.name + " failed for unknown reason"));
            }
        }
        catch (Exception exception) {
            this.log.warn((Object)("trying to delete temporary file " + this.name + " failed with exception: " + exception.toString()));
        }
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public String getSizeAsString() {
        return this.sizeAsString;
    }

    public MimeBodyPart getMimeBodyPart() {
        return this.mimeBodyPart;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

