<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:template match="page/entry">
 <content>
   <table height="100%" width="100%">
	
     <tr valign="top">
	<td>
          <!-- Stuff containing user information -->
	  <table cellpadding="3" cellspacing="10" width="100%">
	   <tr>
	      <td class="welcome" align="center">
                   <i18n:text>mainwindow_text1</i18n:text>,&#160;<xsl:value-of select="user"/>
	      </td>
	   </tr>
	   <tr>
	      <td class="welcome" align="center">
	          <xsl:choose>
		    <xsl:when test="userpreferencesstate/isAvailable">
		       <i18n:text>setupuser_available</i18n:text>
		    </xsl:when>
		    <xsl:when test="userpreferencesstate/isEmpty">
		       <i18n:text>setupuser_empty</i18n:text>
		    </xsl:when>
		    <xsl:otherwise>
		       <i18n:text>setupuser_notavailable</i18n:text>
		    </xsl:otherwise>
		  </xsl:choose>
	      </td>
	   </tr>
           <tr>
                <td class="infotext" align="center">
		   <span class="bold">
			<xsl:value-of
  select="headertext1"/>&#160;<xsl:value-of select="url"/> 
		   </span>
		</td>
            </tr>
	  <tr>
	     <td class="infotext" align="center">Hits: <xsl:value-of select="hits"></xsl:value-of>
             </td>
	  </tr>
         </table>
        </td>
     </tr>

     <tr valign="bottom">
       <td>
         <!-- Version info -->
	 <table width="100%">
	  <tr valign="bottom">
	    <td class="infotext" align="center">

		   <i18n:translate>
	              <i18n:text>general_versioninfo</i18n:text>
	              <i18n:param><xsl:value-of select="normalize-space(version-info/number)"/></i18n:param>
	              <i18n:param><xsl:value-of select="normalize-space(version-info/date)"/></i18n:param>
                   </i18n:translate>

	      
	    </td>
	  </tr>
         </table>
       </td>
     </tr>

   </table> 
 
  </content>
</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>


</xsl:stylesheet>
