<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0"
 xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:template match="page">

<html>
 <head>
  <title><i18n:text>generalexception_title</i18n:text></title>
  <meta content="AUTHOR" value="jwk"/>
  <link type="text/css" href="ironmailercss" rel="stylesheet" />
 </head>

 <body class="body_bg">

  <table name="errortab" border="0" cellpadding="10" cellspacing="5"
  width="80%" align="center">

    <tr>
        <td>
		<img alt="logo" src="images/application_logo_small.png"/>
	</td>
	<td>
	  <table cellpadding="3" cellspacing="5">
	    <tr>
           	<td class="bold_red">
		     <i18n:text>general_error</i18n:text>
		</td>
	    </tr>
	    <xsl:if test="extra">
	      <tr>
	        <td class="simpletext">
		  <xsl:choose>
		    <xsl:when test="extra/isUserInstallation">
		       <i18n:translate>
			 <i18n:text>general_userinstallationerror</i18n:text>
			 <i18n:param><xsl:value-of select="normalize-space(extra/admin)"/></i18n:param>
			 <i18n:param><xsl:value-of select="normalize-space(extra/user)"/></i18n:param>
			 <i18n:param><xsl:value-of select="normalize-space(extra/message)"/></i18n:param>
		       </i18n:translate>
		    </xsl:when>
		    <xsl:when test="extra/isBackend">
		       <i18n:text>general_backenderror</i18n:text>
		    </xsl:when>
		  </xsl:choose>
		  <xsl:value-of select="normalize-space(extra)"/>
		</td>
	      </tr>
	    </xsl:if>

	    <tr>
	      <td class="simpletext">
	         <i18n:text>generalexception_loginmessage</i18n:text><br/>
	         <a target="_parent">
		   <xsl:attribute name="href">
                      <xsl:value-of select="concat(normalize-space(login/path),normalize-space(login/link_to_login))"/>
	           </xsl:attribute>
	           <i18n:text>general_login_link_label</i18n:text>
                 </a>	      
	      </td>
	    </tr>

	    <xsl:if test="contact">
	    <tr>
	      <td class="infotext">
		        <xsl:variable name="mailempfaenger" select="normalize-space(contact/email)"/>
                        <xsl:variable name="mailsubject"
                        select="concat(normalize-space(error/header),' - ',normalize-space(error/content))"/>
                        <xsl:variable name="mail" select="concat('mailto:',$mailempfaenger,'?subject=IronMailer: ',$mailsubject)"/>
	      		<i18n:text>internalerror_contact_prefix</i18n:text>
			  &#160;
	       		<a>
        	  	  <xsl:attribute name="href"><xsl:value-of
        	  	  select="$mail"/></xsl:attribute>
			  <i18n:text>internalerror_admin_name</i18n:text>
			  &#160;(<xsl:value-of select="$mailempfaenger"/>)
	       		</a>,
	      		<i18n:text>internalerror_contact_suffix</i18n:text>
	      		<br />
		   </td>
		 </tr>
	     </xsl:if>

		 <tr>
		   <td class="infotext">
		      	&#160;&#160;&#160;
			<xsl:value-of select="normalize-space(error/content)"/>
		   </td>
	  	</tr>
	</table>
       </td>
      </tr>
  </table>
	
	
	<xsl:comment>Error content: <xsl:value-of select="error/content"/></xsl:comment>
	<xsl:comment>Error stack: <xsl:value-of select="error/stack"/></xsl:comment>

 </body>
</html>

</xsl:template>


</xsl:stylesheet>
