<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002-2005 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
   xmlns:error="http://apache.org/cocoon/error/2.1" 
   xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
   xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
   version="1.0">

<!-- 
   @author jwk
   Dynamischer Inhalt (Sprache usw.) ist mit dieser
   Version von Cocoon (2.0) noch nicht ohne grosse Aufwand moeglich; 
   dies wird im Anschluss bei der neuesten Version von Cocoon nochmals
   aufgegriffen. Insbesondere der request-uri sollte moeglichst noch in der
   Fehlermeldung zu finden sein.
  -->
<xsl:param name="home" select="string('')"/>
<xsl:param name="uri"/>

<!-- Note: these parameters are accessible in this stylesheet:
     {$home}
     {$uri}
  -->

<xsl:template match="page">

<xsl:variable name="usermessage">
          <xsl:choose>
            <xsl:when test="normalize-space(error:notify/error:message)">
               <xsl:value-of
            select="concat(normalize-space(error:notify/error:message),' / ',normalize-space(error:notify/error:description))" />
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="normalize-space(error:notify/error:description)" />
            </xsl:otherwise>
          </xsl:choose>
</xsl:variable>


<html>
  <head>
    <title><i18n:text>internalerror_title</i18n:text></title>
    <link type="text/css" href="{$home}/ironmailercss" rel="stylesheet" />
    <meta http-equiv="expires" content="0" />
  </head>

  <body class="body_bg">

  <table name="errortab" border="0" width="770" height="85" cellpadding="0" cellspacing="0">

	<table width="100%" border="0" cellspacing="0" cellpadding="0">

	<tr>
		<td width="113" align="center" valign="top">
			<img alt="logo" src="{$home}/images/application_logo_small.png"/>
		</td>
		<td width="657" height="74"  align="center" valign="top">
		</td>
	</tr>
	</table>

	<!-- body table -->
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td width="113" align="center" valign="top">
		</td>
           	<td width="657">
	    	  <p class="bold_red">
		        <xsl:value-of
        	  	  select="normalize-space(internal/title)"/>
                  </p>
	    	  <p>
                    <xsl:choose>
		      <xsl:when test="internal/contact">
		        <xsl:variable name="mailempfaenger" select="normalize-space(internal/contact/email)"/>
                        <xsl:variable name="mailsubject" select="$usermessage"/>
                        <xsl:variable name="mail" select="concat('mailto:',$mailempfaenger,'?subject=IronMailer: ',$mailsubject)"/>
	      		<i18n:text>internalerror_contact_prefix</i18n:text>
			  &#160;
	       		<a>
        	  	  <xsl:attribute name="href"><xsl:value-of
        	  	  select="$mail"/></xsl:attribute>
			  <i18n:text>internalerror_admin_name</i18n:text>
			  &#160;(<xsl:value-of select="$mailempfaenger"/>)
	       		</a>,
	      		<i18n:text>internalerror_contact_suffix</i18n:text>
			  &#160;
	      		<br />
		      	&#160;&#160;&#160; 
		      </xsl:when>
		      <xsl:otherwise>
		         <i18n:text>internalerror_nocontact_message</i18n:text><br/>
		         <a target="_parent">
			   <xsl:attribute name="href">
	                      <xsl:value-of select="concat(normalize-space(internal/nocontact/path),normalize-space(internal/nocontact/link_to_login))"/>
		           </xsl:attribute>
		           <i18n:text>general_login_link_label</i18n:text>
	                 </a>
		      </xsl:otherwise>
		     </xsl:choose>
		   </p>

		   <p>
	        	<i>
		   	   <xsl:value-of select="$usermessage"/>
	       		</i>
	      		<br />
	    	   </p>
	  	</td>
        </tr>

	</table>
  </table>

  </body>

  <xsl:comment>
    type: <xsl:value-of select="error:notify/error:type"/>
  </xsl:comment>
  <xsl:comment>
    title: <xsl:value-of select="error:notify/error:title"/>
  </xsl:comment>
  <xsl:comment>
    source: <xsl:value-of select="error:notify/error:source"/>
  </xsl:comment>
  <xsl:comment>
    sender: <xsl:value-of select="error:notify/error:sender"/>
  </xsl:comment>
  <xsl:comment>
    message: <xsl:value-of select="error:notify/error:message"/>
  </xsl:comment>
  <xsl:comment>
    description: <xsl:value-of select="error:notify/error:description"/>
  </xsl:comment>
  <xsl:comment>
    Stack: <xsl:value-of select="translate(error:notify/error:extra[2],'&#13;',' ')"/>
  </xsl:comment>
  <xsl:comment>
    Extra 0: <xsl:value-of select="error:notify/error:extra[0]"/>
  </xsl:comment>
  <xsl:comment>
    Extra 1: <xsl:value-of select="error:notify/error:extra[1]"/>
  </xsl:comment>

</html>

</xsl:template>
</xsl:stylesheet>
