<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
>

<xsl:template match="page">
   <xsl:variable name="projecthome_link"
	  select="'http://ironmailer.org'"/>
   <xsl:variable name="companyhome_link"
	  select="'http://www.jatec.net'"/>
   <xsl:variable name="partner_link"
	  select="'http://www.politux.org'"/>

<html>
   <head>
	<title><i18n:text>login_titletext</i18n:text></title>
	<meta content="AUTHOR" value="wk"/>
	<link type="text/css" href="ironmailercss" rel="stylesheet" />
   </head>
   <body class="login_bg" onload="document.loginform.username.focus();">

     <form name="loginform" method="post" action="welcome">
      <input value="login" name="act" type="hidden"/>

      <!-- outer formatting table -->
      <table class="field_light_bg" align="center" cellspacing="0"
      width="430">
         <tr>
            <td>
	       <img alt="logo" hspace="5" src="images/ironmailer_logo_titlebar.png"/>
	    </td>
	    <td>
	        <!-- inner table, containing main stuff (login data) -->
		<table align="center" cellpadding="5" cellspacing="0"
      border="0"  width="100%" style="margin-top:20px;margin-bottom:20px">
	           <!-- username entry field -->
		   <tr>
		      <td class="smalltext" align="right">
		          <i18n:text>Username</i18n:text>
		      </td>
		      <td class="smalltext" colspan="2">
			 <input class="smalltext" size="15" name="username" type="text"/>
		      </td>
		   </tr>
		   <!-- password entry field -->   
		   <tr>
		      <td class="smalltext" align="right">
		         <i18n:text>Password</i18n:text>
		      </td>
		      <td class="smalltext" colspan="2">
			 <input class="smalltext" size="15" name="password" type="password"/>
		      </td>
		   </tr>
		   <!-- row with action buttons -->
		   <tr>
  		      <td class="smalltext"></td>
		      <td class="smalltext">
			 <input i18n:attr="value" class="smalltext" name="Login" type="submit">
			    <xsl:attribute name="value">login_actiontext1</xsl:attribute>
			 </input>
		      </td>
		      <td>
			 <input i18n:attr="value" class="smalltext" name="Reset" type="reset">
			    <xsl:attribute name="value">login_actiontext2</xsl:attribute>
			 </input>
		      </td>
		   </tr>
		</table>
	</td>
	</tr>

	<xsl:choose>
	   <xsl:when test="error">
	      <tr class="field_middle_bg">
	         <td colspan="2">
		        <p class="smalltext" align="center">
			    <img align="middle" border="0" hspace="5" src="images/gnome/dialog-warning.png" />

		            <span class="bold">
		            	<i18n:text>LoginError</i18n:text>
			   </span>.
			</p>
 			<xsl:comment>Error content: <xsl:value-of select="error/content"/></xsl:comment>
 			<xsl:comment>Error stack: <xsl:value-of select="error/stack"/></xsl:comment>
		 </td>
	      </tr>
	   </xsl:when>
	        
	   <xsl:when test="timeout">
	      <tr class="field_middle_bg">
	         <td colspan="2">
		    <table class="smalltext">
		      <tr>
		        <td rowspan="2">
			    <img align="middle" border="0" hspace="5" src="images/gnome/dialog-warning.png"/>
			</td>
			<td rowspan="2" class="bold">
			   <i18n:text>nosession_title</i18n:text>
			</td>
			<td>
		            <i18n:text>nosession_explanation</i18n:text>
			</td>
		      </tr>
		      <tr>
		        <td><i18n:text>nosession_hint</i18n:text>
			</td>
		      </tr>
		   </table>
		 </td>
	      </tr>
	   </xsl:when>

	   <xsl:otherwise>

	<tr>
	  <td colspan="2">

		<table cellspacing="0" cellpadding="10" width="100%">
		   <!-- row with information -->
		   <tr class="field_dark_bg">
		      <td class="smalltext" align="center" valign="middle">
                         <a class="bold">
                            <xsl:attribute name="href">
                               <xsl:value-of select="$projecthome_link"/>
                            </xsl:attribute>
			    <i18n:text>login_footertext1</i18n:text>
                         </a>
			 &#160;<i18n:text>login_footertext2</i18n:text>
		      </td>
		      <td class="smalltext" align="center" valign="middle">
			 <a>
			    <xsl:attribute name="href">
				<xsl:value-of select="$companyhome_link"/>
			    </xsl:attribute>
			    <img alt="logo" src="images/jatec_logo.png" border="0" />
			 </a>
		      </td>
		      <td class="smalltext" align="center" valign="middle">
			 <a>
			    <xsl:attribute name="href">
				<xsl:value-of select="$partner_link"/>
			    </xsl:attribute>
			    <img alt="logo" src="images/politux_logo.png" border="0" />
			 </a>
		      </td>
		   </tr>
		</table>
	      </td>
	   </tr>		
	        </xsl:otherwise>

	  </xsl:choose>

	</table>		
	</form>
      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>
