<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:template match="message">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<fo:layout-master-set>
				<!-- Layout der Seiten -->
				<fo:simple-page-master master-name="page" page-height="29.7cm" page-width="21cm" margin-top="1cm" margin-bottom="2cm" margin-left="2.5cm" margin-right="2.5cm">
					<fo:region-before extent="10cm"/>
					<fo:region-body margin-top="3cm" margin-bottom="2cm" background-repeat="no-repeat" background-color="transparent" background-position-horizontal="center" background-position-vertical="center"/>
					<fo:region-after extent="1.5cm"/>
				</fo:simple-page-master>
				<fo:page-sequence-master master-name="all">
					<fo:repeatable-page-master-alternatives>
						<fo:conditional-page-master-reference master-reference="page" page-position="first"/>
					</fo:repeatable-page-master-alternatives>
				</fo:page-sequence-master>
			</fo:layout-master-set>

			<fo:page-sequence master-reference="all" initial-page-number="1">
				<!-- fo:static-content muss vor fo:flow stehen -->
				<fo:static-content flow-name="xsl-region-before">
					<fo:block text-align="center">
						<!-- example for external graphic with full path name
						<fo:external-graphic height="10">
							<xsl:attribute name="src"><xsl:value-of select="normalize-space(blabla/imagefilepath)"></xsl:value-of>/logo.png</xsl:attribute>
						</fo:external-graphic>
						 -->
						<xsl:value-of select="normalize-space(title)" />
					</fo:block>
					<!-- eine ausgezogene Linie -->
					<fo:block text-align="center">
						<fo:leader leader-pattern="rule" rule-style="solid" leader-length="14cm" rule-thickness="0.25pt"/>
					</fo:block>
				</fo:static-content>
				<fo:static-content flow-name="xsl-region-after">
					<fo:block>
						<fo:leader leader-pattern="rule" rule-style="solid" leader-length="20cm"/>
					</fo:block>
					<fo:table>
						<fo:table-column column-width="80mm"/>
						<fo:table-column column-width="80mm"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block font-size="11pt" text-align="right" font-family="Times New Roman">
												<xsl:value-of select="normalize-space(message/subject)"></xsl:value-of>&#160;<fo:page-number/>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<!-- body -->
				<fo:flow flow-name="xsl-region-body">


				<!-- ======================
				jwk: header stuff (from, to ...)
				=========================== -->

				<fo:table>
					<fo:table-column column-width="30mm"/>
					<fo:table-column column-width="80mm"/>
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" font-weight="bold" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(headertext8)"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(message/subject)"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" font-weight="bold" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(headertext2)"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(message/from)"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" font-weight="bold" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(headertext3)"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(message/to)"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" font-weight="bold" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(headertext4)"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(message/reply-to)"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" font-weight="bold" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(headertext5)"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(message/cc)"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
						<fo:table-row>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" font-weight="bold" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(headertext6)"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" space-before.optimum="5pt">
									<xsl:value-of select="normalize-space(message/date)"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>


					<fo:block font-size="12pt" space-before.optimum="15pt" text-align="left" font-family="Times New Roman" font-weight="bold">
						<xsl:value-of select="normalize-space(headertext1)" />
					</fo:block>


					<!-- eine ausgezogene Linie -->
					<fo:block>
						<fo:leader leader-pattern="rule" rule-style="solid" leader-length="20cm"/>
					</fo:block>


					<!-- ==============
					  Message body
					=================== -->
				<fo:table>
				   <fo:table-column column-width="160mm"/>
				   <fo:table-body>
					<xsl:for-each select="message/body/line">
					  <fo:table-row>
						<fo:table-cell>
						   <fo:block font-size="11pt" space-before.optimum="0pt" text-align="left" font-family="Times New Roman" margin-left="0.5cm" linefeed-treatment="preserve" white-space-collapse="false" white-space-treatment="preserve">
						      <xsl:value-of select="content" />
					           </fo:block>
						</fo:table-cell>
					  </fo:table-row>
					</xsl:for-each>
				   </fo:table-body>
				</fo:table>


					<fo:block>
						<fo:leader leader-pattern="rule" rule-style="solid" leader-length="20cm"/>
					</fo:block>
					<!--
					    Attachments 
					-->
				<fo:table>
					<fo:table-column column-width="30mm"/>
					<fo:table-column column-width="80mm"/>
					<fo:table-body>
						<xsl:for-each select="message/attachment">

							<fo:table-row>
								<fo:table-cell>
									<fo:block font-size="12pt" text-align="right" font-family="Times New Roman" margin-left="0.5cm" space-before.optimum="10pt" font-weight="bold">
										<xsl:value-of select="normalize-space(../../partheader/headertext)" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block font-size="12pt" text-align="left" font-family="Times New Roman" margin-left="0.5cm" space-before.optimum="10pt" font-weight="bold">
										<xsl:value-of select="position()" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell>
									<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" margin-left="0.5cm" space-before.optimum="5pt">
										<xsl:value-of select="normalize-space(../../bodytext3)" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" margin-left="0.5cm" space-before.optimum="5pt">
										<xsl:value-of select="normalize-space(filename)" />
										<xsl:if test="not(filename)">
											<xsl:value-of select="../emptyfilename" />
										</xsl:if>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell>
									<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" margin-left="0.5cm" space-before.optimum="5pt">
										<xsl:value-of select="normalize-space(../../bodytext4)" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" margin-left="0.5cm" space-before.optimum="5pt">
										<xsl:value-of select="normalize-space(type)" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

							<fo:table-row>
								<fo:table-cell>
									<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" margin-left="0.5cm" space-before.optimum="5pt">
										<xsl:value-of select="normalize-space(../../bodytext5)" />
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block font-size="11pt" text-align="left" font-family="Times New Roman" margin-left="0.5cm" space-before.optimum="5pt">
										<xsl:value-of select="normalize-space(size)" />
									</fo:block>
								</fo:table-cell>
							</fo:table-row>

						</xsl:for-each>

					</fo:table-body>
				</fo:table>


				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
