<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet 
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
 >

<xsl:template match="page/behavior">
 <content>

   <xsl:variable name="update_action"
       select="'userbehavior.xsl?act=userbehavior'"/>
	  

	  
   <!-- Header stuff -->
   <table cellpadding="4" cellspacing="2" border="0" width="100%">
    <tbody>
      <!-- Header row 1 -->
      <tr>
	<td class="simpletext" height="22">
		<img align="middle" hspace="5" src="images/gnome/configuration-32.png"/>
		<i18n:text>behavior_headertext1</i18n:text>
	</td>
	<td class="simpletext" align="right">
	 <xsl:choose>
	  <xsl:when test="update/ok">
	       <img align="middle" border="0" src="images/gnome/dialog-info.png" />
	       &#160;<i18n:text>general_update_ok</i18n:text>
	  </xsl:when>
	  <xsl:otherwise>
		<span class="infotext">
		  <xsl:choose>
		    <xsl:when test="userpreferencesstate/@status = 'available'">
                       <i18n:text>setupuser_available</i18n:text>
                    </xsl:when>
		    <xsl:when test="userpreferencesstate/@status = 'empty'">
                       <i18n:text>setupuser_empty</i18n:text></xsl:when>
		    <xsl:when test="userpreferencesstate/@status = 'notavailable'">
                       <i18n:text>setupuser_notavailable</i18n:text></xsl:when>
		  </xsl:choose>
		</span>
	  </xsl:otherwise>
	 </xsl:choose>
	</td>

      </tr>
    </tbody>
   </table>

	<form method="post">
	   <xsl:attribute name="action">
	      <xsl:value-of select="$update_action"/>
	   </xsl:attribute>

	   <table cellpadding="4" cellspacing="2" border="0" width="100%">
	   <tbody>

		<!-- Initial folder row -->
		<tr class="field_light_bg">
			<td class="simpletext" align="center">
			   <i18n:text>behavior_folderoptions_text1</i18n:text>
			</td>
			<td class="simpletext">
				<select class="simpletext" name="initialFolder">
			        <xsl:for-each select="folderoptions/destination">
					<option>
						<xsl:attribute name="value">
							<xsl:value-of select="normalize-space(folderNr)" />
						</xsl:attribute>
						<xsl:if test="isInitial">
							<xsl:attribute name="selected">selected</xsl:attribute>
						</xsl:if>
						<!-- display name, if present
		-->
		                                <xsl:choose>
                                                   <xsl:when test="folderName">
			        		      <xsl:value-of select="normalize-space(folderName)" />
		                                   </xsl:when>
						   <xsl:otherwise>
						      <i18n:text>behavior_folderoptions_nonetext</i18n:text>
						   </xsl:otherwise>
						</xsl:choose>
					</option>
	       			</xsl:for-each>
				</select>
			</td>
			<td class="simpletext" align="left">
			   <i18n:text>behavior_folderoptions_help</i18n:text>
			</td>
		</tr>

		<!-- reply option -->
		<tr class="field_middle_bg">
			<td class="simpletext" align="center">
			   <i18n:text>behavior_replytoheader</i18n:text>
			</td>
			<td class="simpletext">
			    <img hspace="3" border="0" src="images/gnome/reply_to_all-16.png"/>
			    <input class="simpletext" name="replyToAll" value="true" type="checkbox">
				<xsl:if test="replyto/@set = 'true'">
				   <xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
			    </input>
			    <i18n:text>behavior_replytoall</i18n:text>
			</td>
			<td class="simpletext" align="left">
			   <i18n:text>behavior_replytohelp</i18n:text>
			</td>
		</tr>

		<!-- forwarding option -->
		<tr class="field_light_bg">
			<td class="simpletext" align="center">
			   <i18n:text>behavior_forwardheader</i18n:text>
			</td>
			<td class="simpletext">
			    <input class="simpletext" name="forwardAsAttachment" value="true" type="checkbox">
				<xsl:if test="forward/@set = 'true'">
				   <xsl:attribute name="checked">checked</xsl:attribute>
				</xsl:if>
			    </input>
			    <i18n:text>behavior_forwardattachmentset</i18n:text>
			</td>
			<td class="simpletext" align="left">
			   <i18n:text>behavior_forwardhelp</i18n:text>
			</td>
		</tr>

		<!-- nb of messages option -->
		<tr class="field_middle_bg">
			<td class="simpletext" align="center">
			   <i18n:text>behavior_nb_per_screen_header</i18n:text>
			</td>
			<td class="simpletext">
			    <input class="simpletext" name="nbMsgsPerScreen"
		maxlength="3" size="2">
		                <xsl:attribute name="value">
				   <xsl:value-of
		select="normalize-space(nbPerScreen/@value)"/>
		                </xsl:attribute>
			    </input>
			</td>
			<td class="simpletext" align="left">
			   <i18n:text>behavior_nb_per_screen_help</i18n:text>
			</td>
		</tr>

		<!-- Sent folder option -->
		<tr class="field_light_bg">
			<td class="simpletext" align="center">
			   <i18n:text>behavior_sentfolder</i18n:text>
			</td>
			<td class="simpletext">
				<select class="simpletext" name="sentFolder">
			        <xsl:for-each select="folderoptions/destination">
					<option>
						<xsl:attribute name="value">
							<xsl:value-of select="normalize-space(folderNr)" />
						</xsl:attribute>
						<xsl:if test="isSent">
							<xsl:attribute name="selected">selected</xsl:attribute>
						</xsl:if>
			        		<xsl:value-of select="normalize-space(folderName)" />
					</option>
	       			</xsl:for-each>
				</select>
			</td>
			<td class="simpletext" align="left">
			   <i18n:text>behavior_sentfolder_help</i18n:text>
			</td>
		</tr>

	   </tbody>
	   </table>

	   <p class="simpletext" align="center">
		<input name="store" class="simpletext" type="submit"
		       i18n:attr="value" value="general_store_action_text" >
		</input>
	   </p>

	</form>

  </content>
</xsl:template>

   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
   <xsl:template match="@*|node()">
      <xsl:copy>
         <xsl:apply-templates select="@*|node()"/>
      </xsl:copy>
   </xsl:template>
   <xsl:template match="text()">
      <xsl:value-of select="."/>
   </xsl:template>

</xsl:stylesheet>
