/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.util.Comparator;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.GeneralStore;
import net.jatec.ironmailer.controller.MailServerConnection;
import net.jatec.ironmailer.model.ApplicationConfiguration;
import net.jatec.ironmailer.model.Contact;
import net.jatec.ironmailer.model.ContactComparator;
import net.jatec.ironmailer.model.ContactDuplicateException;
import net.jatec.ironmailer.model.ContactList;
import net.jatec.ironmailer.model.ModelException;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class ContactListController {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$ContactListController == null ? (class$net$jatec$ironmailer$controller$ContactListController = ContactListController.class$((String)"net.jatec.ironmailer.controller.ContactListController")) : class$net$jatec$ironmailer$controller$ContactListController));
    private ContactList userContactList;
    private GeneralStore userContactListStore;
    private MailServerConnection serverConnection;
    private ApplicationConfiguration applicationConfiguration;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$ContactListController;
    static /* synthetic */ Class class$net$jatec$ironmailer$model$ContactList;

    public ContactListController(MailServerConnection mailServerConnection, ApplicationConfiguration applicationConfiguration) {
        this.serverConnection = mailServerConnection;
        this.applicationConfiguration = applicationConfiguration;
    }

    public ContactList getContactList() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getContactList() called, is null? " + (this.userContactList == null)));
        }
        return this.userContactList;
    }

    public void close() throws ControllerException {
        if (this.userContactListStore != null) {
            this.userContactListStore.close();
        }
    }

    public void addContact(Contact contact) throws ControllerException, ContactDuplicateException {
        this.log.debug((Object)"addContact() called");
        this.initContactList();
        this.userContactList.addContact(contact);
        this.store();
    }

    public void setContact(int n, Contact contact) throws ControllerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("setContact() called with contactNr=" + n));
        }
        this.userContactList.setContact(n, contact);
        this.store();
    }

    public void deleteContact(int n) throws ControllerException {
        this.log.debug((Object)"deleteContact() called");
        if (this.userContactList == null) {
            throw new ControllerException("setup error: calling delete contact before reading contact list");
        }
        this.userContactList.deleteContact(n);
        this.store();
    }

    public void sort(String string, boolean bl) throws ControllerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("sort called on field " + string + ", ascending? " + bl));
        }
        ContactComparator contactComparator = null;
        try {
            contactComparator = new ContactComparator(string, bl);
        }
        catch (ModelException modelException) {
            throw new ControllerException("could not get comparator for field " + string, (Throwable)modelException);
        }
        this.userContactList.sort((Comparator)contactComparator);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"done sorting, writing to store");
        }
        this.store();
    }

    private void store() throws ControllerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("store() called, contact list has " + this.userContactList.getLength() + " elements."));
        }
        this.getUserContactListStore().writeAsXml("ContactList", (Object)this.userContactList, ContactList.TYPES);
    }

    public void initContactList() throws ControllerException {
        if (this.userContactList == null) {
            this.userContactList = (ContactList)this.getUserContactListStore().getObject("ContactList", class$net$jatec$ironmailer$model$ContactList == null ? (class$net$jatec$ironmailer$model$ContactList = ContactListController.class$((String)"net.jatec.ironmailer.model.ContactList")) : class$net$jatec$ironmailer$model$ContactList);
            if (this.userContactList != null) {
                this.log.debug((Object)"getUserContactList() : read an existing list from store");
            } else {
                this.log.debug((Object)"getUserContactList() : no existing list in store, creating a new (empty) one");
                this.userContactList = new ContactList();
            }
        }
    }

    private GeneralStore getUserContactListStore() throws ControllerException {
        if (this.userContactListStore == null) {
            this.userContactListStore = new GeneralStore(this.serverConnection, this.applicationConfiguration.getUserContactsFolder());
        }
        return this.userContactListStore;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

