/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.util.Iterator;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.search.SearchTerm;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.MailboxController;
import net.jatec.ironmailer.model.MailFolderHeader;
import net.jatec.ironmailer.model.SearchMessagesResults;
import org.apache.log4j.Logger;

public class MailSearcher {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$MailSearcher == null ? (class$net$jatec$ironmailer$controller$MailSearcher = MailSearcher.class$((String)"net.jatec.ironmailer.controller.MailSearcher")) : class$net$jatec$ironmailer$controller$MailSearcher));
    private MailboxController mc;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$MailSearcher;

    public MailSearcher(MailboxController mailboxController) {
        this.mc = mailboxController;
    }

    public SearchMessagesResults searchMessages(SearchTerm searchTerm) throws ControllerException {
        if (searchTerm == null) {
            throw new IllegalArgumentException("at least one search term must be given");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"searchMessages() called");
        }
        SearchMessagesResults searchMessagesResults = new SearchMessagesResults(searchTerm);
        int n = 0;
        Iterator iterator = this.mc.getMailboxOverview().getMailFolderHeaders().iterator();
        while (iterator.hasNext()) {
            MailFolderHeader mailFolderHeader = (MailFolderHeader)iterator.next();
            if (mailFolderHeader.isSelectable()) {
                Folder folder = mailFolderHeader.getFolder();
                if (!folder.isOpen()) {
                    this.mc.setMailFolder(n, true);
                }
                try {
                    Message[] messageArray = folder.search(searchTerm);
                    if (messageArray != null && messageArray.length > 0) {
                        int[] nArray = new int[messageArray.length];
                        for (int i = 0; i < nArray.length; ++i) {
                            nArray[i] = messageArray[i].getMessageNumber();
                        }
                        searchMessagesResults.add(n, mailFolderHeader.getName(), nArray);
                    }
                }
                catch (MessagingException messagingException) {
                    throw new ControllerException("error searching on term " + searchTerm + " in folder " + folder.getName(), (Throwable)messagingException);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new ControllerException("error searching on term " + searchTerm + " in folder " + folder.getName(), (Throwable)illegalStateException);
                }
            }
            ++n;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("searchMessages() returning " + searchMessagesResults.toString()));
        }
        return searchMessagesResults;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

