/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.controller;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import net.jatec.ironmailer.controller.BackendException;
import net.jatec.ironmailer.controller.ControllerException;
import net.jatec.ironmailer.controller.FolderManager;
import net.jatec.ironmailer.controller.MailboxFetcher;
import net.jatec.ironmailer.controller.UserInstallationException;
import net.jatec.ironmailer.framework.MailTools;
import net.jatec.ironmailer.model.ApplicationConfiguration;
import net.jatec.ironmailer.model.MailFolder;
import net.jatec.ironmailer.model.MailFolderHeader;
import net.jatec.ironmailer.model.MailMessage;
import net.jatec.ironmailer.model.MailboxOverview;
import net.jatec.ironmailer.model.MessageHeader;
import net.jatec.ironmailer.model.ModelException;
import org.apache.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public class MailboxController {
    private static final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$controller$MailboxController == null ? (class$net$jatec$ironmailer$controller$MailboxController = MailboxController.class$((String)"net.jatec.ironmailer.controller.MailboxController")) : class$net$jatec$ironmailer$controller$MailboxController));
    private MailboxOverview mailboxOverview;
    private Hashtable mailFolders;
    private Hashtable mailMessages;
    private ApplicationConfiguration applicationConfiguration;
    private Store store;
    static /* synthetic */ Class class$net$jatec$ironmailer$controller$MailboxController;

    public MailboxController(Store store, ApplicationConfiguration applicationConfiguration) throws ControllerException {
        this.store = store;
        this.applicationConfiguration = applicationConfiguration;
        this.setMailboxOverview(true);
    }

    public MailboxOverview getMailboxOverview() {
        return this.mailboxOverview;
    }

    public void setMailboxOverview(boolean bl) throws ControllerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setMailboxOverview() called, refresh=" + bl));
        }
        try {
            if (this.mailboxOverview == null || bl) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"setMailboxOverview() creating overview");
                }
                if (bl) {
                    this.closeCache(true);
                }
                this.mailboxOverview = new MailboxFetcher().createMailboxOverview(this.store, this.applicationConfiguration);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"setMailboxOverview() successfully created overview");
                }
            }
        }
        catch (UserInstallationException userInstallationException) {
            throw new ControllerException("user installation is fishy", (Throwable)userInstallationException);
        }
        catch (MessagingException messagingException) {
            throw MailboxController.messaging2controller((String)"error in setMailboxOverview", (MessagingException)messagingException);
        }
    }

    public void closeCache(boolean bl) {
        if (this.mailFolders != null) {
            Enumeration enumeration = this.mailFolders.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ((MailFolder)enumeration.nextElement()).close(true);
                }
                catch (FolderNotFoundException folderNotFoundException) {
                }
                catch (MessagingException messagingException) {
                    log.warn((Object)("unexpected exception while closing cache (ignoring): " + enumeration));
                }
            }
            this.mailFolders = null;
        }
        this.mailMessages = null;
        this.mailboxOverview = null;
    }

    public void setMailFolder(int n, boolean bl) throws ControllerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setMailFolder() called for nr " + n + ", forceRefresh? " + bl));
        }
        if (this.mailFolders == null) {
            this.mailFolders = new Hashtable();
        }
        if (!bl && (MailFolder)this.mailFolders.get(new Integer(n)) != null) {
            log.debug((Object)"setMailFolder() not doing anything, folder is in cache");
            return;
        }
        try {
            MailFolder mailFolder;
            MailFolderHeader mailFolderHeader;
            if (log.isDebugEnabled()) {
                log.debug((Object)"setMailFolder() creating folder information");
            }
            if ((mailFolderHeader = this.getMailboxOverview().getMailFolderHeader(n)) == null) {
                throw new ControllerException("something fishy: could not retrieve mail folder header for number " + n);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"setMailFolder() got mail folder header");
            }
            if ((mailFolder = new MailFolder(mailFolderHeader)) == null) {
                throw new ControllerException("something fishy: could not instantiate MailFolder object for number " + n);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"setMailFolder() instantiated MailFolder object");
            }
            this.mailFolders.put(new Integer(n), mailFolder);
            if (log.isDebugEnabled()) {
                log.debug((Object)("setMailFolder() successful for folder " + mailFolder.getMailFolderHeader().getName() + ", isOpen? " + mailFolder.getMailFolderHeader().getFolder().isOpen()));
            }
        }
        catch (MessagingException messagingException) {
            throw MailboxController.messaging2controller((String)("could not retrieve folder information for nr " + n), (MessagingException)messagingException);
        }
        catch (ModelException modelException) {
            throw new ControllerException("error initializing model for nr " + n, (Throwable)modelException);
        }
    }

    public MailFolder getMailFolder(int n) {
        MailFolder mailFolder;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMailFolder() called for nr " + n));
        }
        if (this.mailFolders == null) {
            log.warn((Object)("getMailFolder() returning null for nr " + n + ", this is probably a setup error: check the GUI"));
            mailFolder = null;
        } else {
            mailFolder = (MailFolder)this.mailFolders.get(new Integer(n));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMailFolder() returning " + mailFolder));
        }
        return mailFolder;
    }

    public MessageHeader getMessageHeader(int n, int n2) throws ControllerException {
        MailFolder mailFolder = this.getMailFolder(n);
        if (mailFolder == null) {
            throw new ControllerException("getMessageHeader() internal error: mail folder for nb " + n + " is not there." + n, null);
        }
        MessageHeader messageHeader = (MessageHeader)mailFolder.getMessageHeaders().get(n2);
        if (messageHeader == null) {
            throw new ControllerException("unexpected error: no header for message nr " + n2, null);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMessageHeader() successful reading from folder " + mailFolder.getMailFolderHeader().getName()));
        }
        return messageHeader;
    }

    public void setMessage(int n, int n2) throws ControllerException {
        Hashtable<Integer, MailMessage> hashtable;
        log.debug((Object)("setMessage() called with parameters folderNr=" + n + " and p_messageNr=" + n2));
        int n3 = n2 - 1;
        MailFolder mailFolder = this.getMailFolder(n);
        if (mailFolder == null) {
            throw new ControllerException("setMessage() got illegal folder selected, number " + n, null);
        }
        if (this.mailMessages == null) {
            this.mailMessages = new Hashtable();
        }
        if ((hashtable = (Hashtable<Integer, MailMessage>)this.mailMessages.get(mailFolder)) != null && (MailMessage)hashtable.get(new Integer(n3)) != null) {
            return;
        }
        log.debug((Object)"setMessage() fetching fresh message...");
        try {
            MessageHeader messageHeader = this.getMessageHeader(n, n3);
            MailMessage mailMessage = new MailMessage(messageHeader);
            if (hashtable == null) {
                hashtable = new Hashtable<Integer, MailMessage>();
            }
            hashtable.put(new Integer(n3), mailMessage);
            this.mailMessages.put(new Integer(n), hashtable);
        }
        catch (MessagingException messagingException) {
            throw MailboxController.messaging2controller((String)("could not retrieve message for folderNr " + n + ", messageNr=" + n3), (MessagingException)messagingException);
        }
        this.setMailFolder(n, true);
        log.debug((Object)"setMessage() successful");
    }

    public MailMessage getMailMessage(int n, int n2) {
        log.debug((Object)("getMailMessage() called with folderNr=" + n + " and messageNr=" + n2));
        int n3 = n2 - 1;
        MailMessage mailMessage = null;
        if (this.mailMessages != null) {
            Hashtable hashtable = (Hashtable)this.mailMessages.get(new Integer(n));
            if (hashtable != null) {
                mailMessage = (MailMessage)hashtable.get(new Integer(n3));
            } else {
                log.warn((Object)"getMailMessage() internal setup error, messagesInFolder is null");
            }
        } else {
            log.warn((Object)"getMailMessage() internal setup error, mailMessages is null");
        }
        log.debug((Object)("getMailMessage() returning, is null? " + (mailMessage == null)));
        return mailMessage;
    }

    public void setFlag(int n, int n2, Flags.Flag flag, boolean bl) throws ControllerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setFlag() called with parameters folderNr=" + n + ", gui_messageNr=" + n2 + ", flag to set=" + flag + ", value=" + bl));
        }
        try {
            MessageHeader messageHeader = this.getMessageHeader(n, n2 - 1);
            MimeMessage mimeMessage = messageHeader.getMessage();
            mimeMessage.setFlag(flag, bl);
        }
        catch (MessagingException messagingException) {
            throw MailboxController.messaging2controller((String)("error setting flag " + flag), (MessagingException)messagingException);
        }
        this.setMailFolder(n, true);
        log.debug((Object)"setFlag() done");
    }

    public void setMessagesFlag(int n, int[] nArray, String string, boolean bl) throws ControllerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setMessagesFlag() called with parameters folderNr=" + n + ", flag to set: " + string + "nb of messages handled " + nArray.length));
        }
        if (nArray.length > 0) {
            Flags.Flag flag = MailTools.getStringAsFlag((String)string);
            if (flag == null) {
                throw new ControllerException("illegal flag setting: no support for flag called " + string, null);
            }
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    int n2 = nArray[i];
                    int n3 = n2 - 1;
                    MessageHeader messageHeader = this.getMessageHeader(n, n3);
                    MimeMessage mimeMessage = messageHeader.getMessage();
                    mimeMessage.setFlag(flag, bl);
                }
            }
            catch (MessagingException messagingException) {
                throw MailboxController.messaging2controller((String)("error setting flag " + string), (MessagingException)messagingException);
            }
            this.setMailFolder(n, true);
        }
        log.debug((Object)"setMessageFlag() done");
    }

    public void copyOrMoveMessages(int n, int n2, int[] nArray, boolean bl) throws ControllerException {
        if (n < 0) {
            throw new ControllerException("illegal usage: fromFolderNr may not be negative");
        }
        if (n2 < 0) {
            throw new ControllerException("illegal usage: toFolderNr may not be negative");
        }
        if (nArray == null) {
            throw new ControllerException("illegal usage: no msgIndices provided");
        }
        log.debug((Object)("copyOrMoveMessages() called from folder " + n + " to folder nr " + n2 + " isCopy?" + bl + " for " + nArray.length + " messages"));
        MailFolder mailFolder = this.getMailFolder(n);
        Message[] messageArray = new Message[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i] - 1;
            log.debug((Object)("copyOrMoveMessages() marking message nr " + n3));
            messageArray[i] = mailFolder.getMessageHeader(n3).getMessage();
        }
        Folder folder = mailFolder.getMailFolderHeader().getFolder();
        Folder folder2 = this.getMailboxOverview().getMailFolderHeader(n2).getFolder();
        if (bl) {
            log.debug((Object)("copyOrMoveMessages() performing copy of " + messageArray.length + " messages"));
            try {
                folder.copyMessages(messageArray, folder2);
            }
            catch (MessagingException messagingException) {
                throw MailboxController.messaging2controller((String)"error copying messages", (MessagingException)messagingException);
            }
        } else {
            log.debug((Object)("copyOrMoveMessages() performing move of " + messageArray.length + " messages"));
            FolderManager.moveMessages((Folder)folder, (Folder)folder2, (Message[])messageArray);
        }
        this.setMailboxOverview(true);
        this.setMailFolder(n, true);
        this.setMailFolder(n2, true);
    }

    public static ControllerException messaging2controller(String string, MessagingException messagingException) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("messaging2controller: got MessagingException " + (Object)((Object)messagingException)));
        }
        ControllerException controllerException = new ControllerException(string, (Throwable)messagingException);
        Exception exception = messagingException.getNextException();
        if (exception != null && exception instanceof IOException) {
            controllerException = new BackendException(string, (Throwable)exception);
        }
        return controllerException;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

