/*
 * Decompiled with CFR 0.152.
 */
package net.jatec.ironmailer.model;

import javax.mail.Folder;
import javax.mail.FolderNotFoundException;
import javax.mail.MessagingException;
import net.jatec.ironmailer.model.ModelException;
import org.apache.log4j.Logger;

public class MailFolderHeader {
    private final Logger log = Logger.getLogger((Class)(class$net$jatec$ironmailer$model$MailFolderHeader == null ? (class$net$jatec$ironmailer$model$MailFolderHeader = MailFolderHeader.class$((String)"net.jatec.ironmailer.model.MailFolderHeader")) : class$net$jatec$ironmailer$model$MailFolderHeader));
    public static final String PRIMARY_FOLDER_NAME = "INBOX";
    private String name;
    private int nbMessages;
    private int nbNewMessages;
    private Folder folder;
    private int level;
    private boolean isDeleteable;
    private boolean isEmpty;
    private boolean holdsMessages;
    private boolean holdsFolders;
    private boolean isSelectable;
    private boolean isPrimary;
    private boolean isLastLeaf;
    private MailFolderHeader[] subfolders;
    private static final String BACKEND_UNCLEAN_EXCEPTION = "not a selectable mailbox";
    static /* synthetic */ Class class$net$jatec$ironmailer$model$MailFolderHeader;

    public MailFolderHeader(Folder folder, int n) throws FolderNotFoundException, MessagingException, ModelException {
        this.log.debug((Object)"MailFolderHeader() called");
        this.folder = folder;
        this.level = n;
        this.name = folder.getFullName();
        int n2 = folder.getType();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("MailFolderHeader() got folder name=" + this.name + ", type=" + n2 + ", full name is " + folder.getFullName() + ", url name is " + folder.getURLName()));
        }
        this.holdsMessages = (n2 & 1) != 0;
        this.holdsFolders = (n2 & 2) != 0;
        this.isSelectable = this.checkSelectable(folder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("MailFolderHeader() isSelectable=" + this.isSelectable));
        }
        if (this.isSelectable) {
            this.nbMessages = folder.getMessageCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("MailFolderHeader() got message count: " + this.nbMessages));
            }
            this.nbNewMessages = folder.getUnreadMessageCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("MailFolderHeader() got new message count: " + this.nbNewMessages));
            }
        }
        this.isPrimary = this.name != null && this.name.toUpperCase().equals(PRIMARY_FOLDER_NAME);
        this.isDeleteable = !this.isPrimary;
        this.isEmpty = this.nbMessages <= 0;
        this.subfolders = new MailFolderHeader[0];
        this.log.debug((Object)("MailFolderHeader() done, was folder opened? " + folder.isOpen()));
    }

    public boolean holdsFolders() {
        return this.holdsFolders;
    }

    public boolean holdsMessages() {
        return this.holdsMessages;
    }

    public String getName() {
        return this.name;
    }

    public int getNbMessages() {
        return this.nbMessages;
    }

    public int getNbNewMessages() {
        return this.nbNewMessages;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isDeleteable() {
        return this.isDeleteable;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isPrimary() {
        return this.isPrimary;
    }

    public boolean isSelectable() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("isSelectable() called for " + this.name + ", returning " + this.isSelectable));
        }
        return this.isSelectable;
    }

    public void setLastLeaf(boolean bl) {
        this.isLastLeaf = bl;
    }

    public boolean isLastLeaf() {
        return this.isLastLeaf;
    }

    public boolean hasSubfolders() {
        return this.subfolders != null && this.subfolders.length > 0;
    }

    public MailFolderHeader[] getSubfolders() {
        return this.subfolders;
    }

    public void setSubfolders(MailFolderHeader[] mailFolderHeaderArray) {
        this.subfolders = mailFolderHeaderArray;
    }

    private boolean checkSelectable(Folder folder) throws MessagingException {
        try {
            int n = folder.getMessageCount();
            return true;
        }
        catch (MessagingException messagingException) {
            if (messagingException.getMessage().indexOf(BACKEND_UNCLEAN_EXCEPTION) >= 0) {
                this.log.info((Object)("working around strange backend behaviour, trying to open folder " + this.name + " raises exception, instead just setting selectable to false"));
                return false;
            }
            throw messagingException;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name + "\t" + this.nbMessages + "/" + this.nbNewMessages);
        stringBuffer.append(" isLastLeaf? " + this.isLastLeaf);
        if (this.subfolders != null && this.subfolders.length > 0) {
            stringBuffer.append(", has " + this.subfolders.length + " subfolders:\n");
            for (int i = 0; i < this.subfolders.length; ++i) {
                stringBuffer.append("subfolder nb " + (i + 1) + ": ").append(this.subfolders[i].toString()).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

