<?xml version="1.0" encoding="ISO-8859-15"?>
<!-- 
 *   Copyright (C) 2002, 2003, 2004 Jatec AG, Switzerland
 *
 * This file is part of IronMailer.
 *
 * IronMailer is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

   <xsl:template match="page/addresses">
      <content>

	<xsl:variable name="contactlink"
	  select="'contact.xsl?act=contact&amp;new=true'"/>
	<xsl:variable name="edit_link_prefix"
	  select="'contact.xsl?act=contact&amp;edit=true&amp;contactNr='"/>
	<xsl:variable name="link_to_delete"
	  select="'addresses.xsl?act=addresses&amp;delete=true&amp;contactNr='" />
	<xsl:variable name="compose_link"
	  select="'compose.xsl?act=compose&amp;toContact='"/>
	<xsl:variable name="compose_post"
	  select="'compose.xsl?act=compose&amp;toList=true'"/>

	<!-- header table -->
        <table cellpadding="2" cellspacing="1" border="0" width="100%">
	   <tr>
	      <td class="simpletext">
  		<img align="middle" border="0" hspace="5" src="images/gnome/addresses.png" />    
		<xsl:value-of select="normalize-space(header)"/>
	      </td>
	      <td class="simpletext" align="right">
		 <a>
	            <xsl:attribute name="href">
		       <xsl:value-of select="$contactlink"/>
		    </xsl:attribute> 
		    <img align="middle" border="0" hspace="5"
		    src="images/gnome/new_16.png" />
		    <xsl:value-of select="normalize-space(addnewtext)"/>
                  </a>
	      </td>
	   </tr>
 	</table>

	<!-- table for the contacts -->
	<xsl:choose>
	   <xsl:when test="isempty">
	      <p class="simpletext">
	        <xsl:value-of select="normalize-space(isempty/text)" />
	      </p>
	   </xsl:when>
	   <xsl:otherwise>
             <form method="post">
		<xsl:attribute name="action">
		   <xsl:value-of select="$compose_post" />
		</xsl:attribute>

	      <table cellpadding="2" cellspacing="1" border="0" width="100%">
              <tbody>
		<!-- column headers -->
                <tr class="bg_for_invert">
		    <td class="white_text">&#160;</td>
                    <td class="white_text"><xsl:value-of select="normalize-space(emailheader)" /></td>
                    <td class="white_text"><xsl:value-of select="normalize-space(nameheader)" /></td>
		    <td class="white_text"><xsl:value-of select="normalize-space(nicknameheader)" /></td>
		    <td class="white_text" align="center"><xsl:value-of select="normalize-space(editheader)" /></td>
		    <td class="white_text" align="center"><xsl:value-of select="normalize-space(deleteheader)" /></td>
                </tr>

		<!-- List of contacts -->
		<xsl:for-each select="contact">
		  <tr>
		    <xsl:attribute name="class">
		      <xsl:choose>
		        <xsl:when test="position() mod 2">field_light_bg</xsl:when>
		        <xsl:otherwise>field_middle_bg</xsl:otherwise>
		      </xsl:choose>
		    </xsl:attribute>
		    <td align="center" width="5%">
                    	<input class="simpletext" name="checkeditem" type="checkbox">
                    	   <xsl:attribute name="value">
                    		<xsl:value-of select="normalize-space(nr)" />
                    	   </xsl:attribute>
			</input>
		    </td>
		    <td class="simpletext">
		       <a>
		          <xsl:attribute name="href">
		             <xsl:value-of select="concat($compose_link,normalize-space(nr))"/>
			  </xsl:attribute>
			  <xsl:value-of select="normalize-space(email)"/>
		       </a>
		    </td>
		    <td class="simpletext"><xsl:value-of select="normalize-space(name)"/></td>
		    <td class="simpletext"><xsl:value-of select="normalize-space(nickname)"/></td>
                    <td class="simpletext" align="center">
			<a>
			  <xsl:attribute name="href">
			    <xsl:value-of select="concat($edit_link_prefix,normalize-space(nr))"/>
			  </xsl:attribute>
			  <img src="images/gnome/edit_16.png" border="0"/>
			</a>
                    </td>
                    <td class="simpletext" align="center">
			<a>
			  <xsl:attribute name="href">
			    <xsl:value-of select="concat($link_to_delete,normalize-space(nr))"/>
			  </xsl:attribute>
			  <img src="images/gnome/delete_16.png" border="0"/>
			</a>
                    </td>
		  </tr>
		</xsl:for-each>

		<!-- action row -->
		<tr>
		   <!-- span on leftmost columns only, to achieve sort of
		        center left positioning -->
		   <td align="center" colspan="2">
		      <input class="simpletext" type="submit">
                         <xsl:attribute name="name">selectaddr</xsl:attribute>
	                 <xsl:attribute name="value"><xsl:value-of select="normalize-space(composetext)"/></xsl:attribute>
                      </input>
		   </td>
		</tr>

	      </tbody>
	      </table>
             </form>
	   </xsl:otherwise>
	</xsl:choose>

      </content>
   </xsl:template>
	
   <!-- stuff to pass on the rest of the content 
        (i.e., any parts that this stylesheet is not concerned with) -->
  <xsl:template match="@*|node()">
    <xsl:copy>
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  <xsl:template match="text()">
    <xsl:value-of select="."/>
  </xsl:template>

</xsl:stylesheet>
