/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.store.impl;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.store.Store;
import org.apache.excalibur.store.StoreJanitor;

public class StoreJanitorImpl
extends AbstractLogEnabled
implements StoreJanitor,
Parameterizable,
ThreadSafe,
Runnable,
Startable {
    private boolean doRun = false;
    private int minFreeMemory = -1;
    private int maxHeapSize = -1;
    private int threadInterval = -1;
    private int minThreadInterval = 500;
    private boolean adaptiveThreadInterval = false;
    private int priority = -1;
    private double fraction;
    private Runtime jvm;
    private ArrayList storelist;
    private int index = -1;
    protected boolean invokeGC = false;

    public void parameterize(Parameters params) throws ParameterException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Configure StoreJanitorImpl");
        }
        this.setJVM(Runtime.getRuntime());
        this.setMinFreeMemory(params.getParameterAsInteger("freememory", 0x100000));
        this.setMaxHeapSize(params.getParameterAsInteger("heapsize", 0x3C00000));
        this.setThreadInterval(params.getParameterAsInteger("cleanupthreadinterval", 10) * 1000);
        this.setAdaptiveThreadInterval(params.getParameterAsBoolean("adaptivethreadinterval", false));
        this.setPriority(params.getParameterAsInteger("threadpriority", Thread.currentThread().getPriority()));
        int percent = params.getParameterAsInteger("percent_to_free", 10);
        this.invokeGC = params.getParameterAsBoolean("invokegc", this.invokeGC);
        if (this.getMinFreeMemory() < 1) {
            throw new ParameterException("StoreJanitorImpl freememory parameter has to be greater then 1");
        }
        if (this.getMaxHeapSize() < 1) {
            throw new ParameterException("StoreJanitorImpl heapsize parameter has to be greater then 1");
        }
        if (this.getThreadInterval() < 1) {
            throw new ParameterException("StoreJanitorImpl cleanupthreadinterval parameter has to be greater then 1");
        }
        if (this.getPriority() < 1 || this.getPriority() > 10) {
            throw new ParameterException("StoreJanitorImpl threadpriority has to be between 1 and 10");
        }
        if (percent > 100 && percent < 1) {
            throw new ParameterException("StoreJanitorImpl percent_to_free, has to be between 1 and 100");
        }
        this.fraction = (double)percent / 100.0;
        this.setStoreList(new ArrayList());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("minimum free memory=" + this.getMinFreeMemory());
            this.getLogger().debug("heapsize=" + this.getMaxHeapSize());
            this.getLogger().debug("thread interval=" + this.getThreadInterval());
            this.getLogger().debug("priority=" + this.getPriority());
            this.getLogger().debug("percent=" + percent);
            this.getLogger().debug("invoke gc=" + this.invokeGC);
        }
    }

    public void start() {
        this.doRun = true;
        Thread checker = new Thread(this);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Intializing checker thread");
        }
        checker.setPriority(this.getPriority());
        checker.setDaemon(true);
        checker.setName("checker");
        checker.start();
    }

    public void stop() {
        this.doRun = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean firstRun = true;
        long inUse = this.memoryInUse();
        long interval = Long.MAX_VALUE;
        long maxRateOfChange = 1L;
        while (this.doRun) {
            if (this.getAdaptiveThreadInterval()) {
                long change = this.memoryInUse() - inUse;
                long rateOfChange = this.longDiv(change * 1000L, interval);
                if (maxRateOfChange < rateOfChange) {
                    maxRateOfChange = (maxRateOfChange + rateOfChange) / 2L;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Waking after " + interval + "ms, in use change " + change + "b to " + this.memoryInUse() + "b, rate " + rateOfChange + "b/sec, max rate " + maxRateOfChange + "b/sec");
                }
            }
            if (this.memoryLow()) {
                if (this.invokeGC) {
                    this.freePhysicalMemory();
                }
                StoreJanitorImpl change = this;
                synchronized (change) {
                    if (!this.invokeGC || this.memoryLow() && this.getStoreList().size() > 0) {
                        this.freeMemory();
                        this.setIndex(this.getIndex() + 1);
                    }
                }
            }
            if (this.getAdaptiveThreadInterval()) {
                interval = this.minTimeToFill(maxRateOfChange) * 1000L / 2L;
                if (interval > (long)this.threadInterval) {
                    interval = this.threadInterval;
                } else if (interval < (long)this.minThreadInterval) {
                    interval = this.minThreadInterval;
                }
                inUse = this.memoryInUse();
            } else {
                interval = this.threadInterval;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Sleeping for " + interval + "ms");
            }
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
            if (!firstRun) continue;
            firstRun = false;
            inUse = this.memoryInUse();
        }
    }

    private boolean memoryLow() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("JVM Memory total: " + this.getJVM().totalMemory() + ", free: " + this.getJVM().freeMemory());
        }
        if (this.getJVM().totalMemory() >= (long)this.getMaxHeapSize() && this.getJVM().freeMemory() < (long)this.getMinFreeMemory()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Memory is low!");
            }
            return true;
        }
        return false;
    }

    private long memoryInUse() {
        return this.jvm.totalMemory() - this.jvm.freeMemory();
    }

    private long minTimeToFill(long rate) {
        return this.longDiv(this.jvm.freeMemory(), rate);
    }

    private long longDiv(long top, long bottom) {
        try {
            return top / bottom;
        }
        catch (Exception e) {
            return top > 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }

    public synchronized void register(Store store) {
        this.getStoreList().add(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Registered store instance " + store + ". Stores now: " + this.getStoreList().size());
        }
    }

    public synchronized void unregister(Store store) {
        ((AbstractCollection)this.getStoreList()).remove(store);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Unregistered store instance " + store + ". Stores now: " + this.getStoreList().size());
        }
    }

    public Iterator iterator() {
        return ((AbstractList)this.getStoreList()).iterator();
    }

    private void freeMemory() {
        try {
            if (this.getIndex() < this.getStoreList().size()) {
                if (this.getIndex() == -1) {
                    this.setIndex(0);
                }
            } else {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Restarting from the beginning");
                }
                this.setIndex(0);
            }
            Store store = (Store)this.getStoreList().get(this.getIndex());
            int limit = this.calcToFree(store);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Freeing " + limit + " items from store N " + this.getIndex());
            }
            int i = 0;
            while (i < limit) {
                try {
                    store.free();
                }
                catch (OutOfMemoryError e) {
                    this.getLogger().error("OutOfMemoryError in freeMemory()");
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error in freeMemory()", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.getLogger().error("OutOfMemoryError in freeMemory()");
        }
    }

    private int calcToFree(Store store) {
        int cnt = store.size();
        if (cnt < 0) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Unknown size of the store: " + store);
            }
            return 0;
        }
        int res = (int)((double)cnt * this.fraction);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Calculating size for store " + store + " with size " + cnt + " : " + res);
        }
        return res;
    }

    private void freePhysicalMemory() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Invoking garbage collection. Memory total: " + this.getJVM().totalMemory() + ", free: " + this.getJVM().freeMemory());
        }
        this.getJVM().runFinalization();
        this.getJVM().gc();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Garbage collection complete. Memory total: " + this.getJVM().totalMemory() + ", free: " + this.getJVM().freeMemory());
        }
    }

    private int getMinFreeMemory() {
        return this.minFreeMemory;
    }

    private void setMinFreeMemory(int _freememory) {
        this.minFreeMemory = _freememory;
    }

    private int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    private void setMaxHeapSize(int _heapsize) {
        this.maxHeapSize = _heapsize;
    }

    private int getPriority() {
        return this.priority;
    }

    private void setPriority(int _priority) {
        this.priority = _priority;
    }

    private int getThreadInterval() {
        return this.threadInterval;
    }

    private void setThreadInterval(int _threadInterval) {
        this.threadInterval = _threadInterval;
    }

    private boolean getAdaptiveThreadInterval() {
        return this.adaptiveThreadInterval;
    }

    private void setAdaptiveThreadInterval(boolean _adaptiveThreadInterval) {
        this.adaptiveThreadInterval = _adaptiveThreadInterval;
    }

    private Runtime getJVM() {
        return this.jvm;
    }

    private void setJVM(Runtime _jvm) {
        this.jvm = _jvm;
    }

    private ArrayList getStoreList() {
        return this.storelist;
    }

    private void setStoreList(ArrayList _storelist) {
        this.storelist = _storelist;
    }

    private void setIndex(int _index) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting index=" + _index);
        }
        this.index = _index;
    }

    private int getIndex() {
        return this.index;
    }
}

