/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.impl.FileSource;
import org.apache.excalibur.source.impl.URLSource;

public class URLSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
ThreadSafe {
    protected Source createURLSource(URL url, Map parameters) throws MalformedURLException, IOException {
        URLSource result = new URLSource();
        result.init(url, parameters);
        return result;
    }

    protected Source createFileSource(String uri) throws MalformedURLException, IOException {
        return new FileSource(uri);
    }

    public Source getSource(String uri, Map parameters) throws MalformedURLException, IOException {
        URL url;
        if (this.getLogger().isDebugEnabled()) {
            String message = "Creating source object for " + uri;
            this.getLogger().debug(message);
        }
        if (uri.startsWith("file:")) {
            return this.createFileSource(uri);
        }
        try {
            url = new URL(uri);
        }
        catch (MalformedURLException mue) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("URL " + uri + " is malformed. Assuming it's a file path.", (Throwable)mue);
            }
            return this.createFileSource(uri);
        }
        return this.createURLSource(url, parameters);
    }

    public void release(Source source) {
    }
}

