/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceSelector;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ServiceableAction;
import org.apache.cocoon.components.modules.output.OutputModule;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public class PropagatorAction
extends ServiceableAction
implements Configurable,
ThreadSafe {
    private static final String OUTPUT_MODULE_ROLE = OutputModule.ROLE;
    private static final String OUTPUT_MODULE_SELECTOR = OUTPUT_MODULE_ROLE + "Selector";
    private static final String ACTION_PREFIX = "PropagatorAction:";
    private static final String CONFIG_STORE_EMPTY = "store-empty-parameters";
    private static final String CONFIG_OUTPUT_MODULE = "output-module";
    private boolean storeEmpty = true;
    private Configuration outputConf = null;
    private String outputName = null;
    private static final String outputHint = "request-attr";
    private List defaults = null;

    public void configure(Configuration config) throws ConfigurationException {
        this.outputConf = config.getChild(CONFIG_OUTPUT_MODULE);
        this.outputName = this.outputConf.getAttribute("name", outputHint);
        this.storeEmpty = config.getChild(CONFIG_STORE_EMPTY).getValueAsBoolean(this.storeEmpty);
        Configuration[] dflts = config.getChild("defaults").getChildren("default");
        if (dflts != null) {
            this.defaults = new ArrayList(dflts.length);
            for (int i = 0; i < dflts.length; ++i) {
                this.defaults.add(new Entry(dflts[i].getAttribute("name"), dflts[i].getAttribute("value")));
            }
        } else {
            this.defaults = new ArrayList(0);
        }
    }

    private Object[] readParameters(Parameters param) {
        String outputName = param.getParameter("PropagatorAction:output-module", null);
        Boolean storeEmpty = new Boolean(param.getParameterAsBoolean("PropagatorAction:store-empty-parameters", this.storeEmpty));
        param.removeParameter("PropagatorAction:output-module");
        param.removeParameter("PropagatorAction:store-empty-parameters");
        return new Object[]{outputName, storeEmpty};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        HashMap<String, String> actionMap;
        ServiceSelector outputSelector;
        block12: {
            OutputModule output = null;
            outputSelector = null;
            Object[] obj = this.readParameters(parameters);
            String outputName = (String)obj[0];
            boolean storeEmpty = (Boolean)obj[1];
            Configuration outputConf = null;
            if (outputName == null) {
                outputName = this.outputName;
                outputConf = this.outputConf;
            }
            actionMap = new HashMap<String, String>();
            try {
                try {
                    outputSelector = (ServiceSelector)this.manager.lookup(OUTPUT_MODULE_SELECTOR);
                    if (outputName != null && outputSelector != null && outputSelector.isSelectable((Object)outputName)) {
                        output = (OutputModule)outputSelector.select((Object)outputName);
                        String[] names = parameters.getNames();
                        for (int i = 0; i < names.length; ++i) {
                            String sessionParamName = names[i];
                            String value = parameters.getParameter(sessionParamName);
                            if (!storeEmpty && (value == null || value.equals(""))) continue;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Propagating value " + value + " to output module" + sessionParamName);
                            }
                            output.setAttribute(outputConf, objectModel, sessionParamName, value);
                            actionMap.put(sessionParamName, value);
                        }
                        Iterator i = this.defaults.iterator();
                        while (i.hasNext()) {
                            Entry entry = (Entry)i.next();
                            if (actionMap.containsKey(entry.key)) continue;
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Propagating default value " + entry.value + " to session attribute " + entry.key);
                            }
                            output.setAttribute(outputConf, objectModel, entry.key, entry.value);
                            actionMap.put(entry.key, entry.value);
                        }
                        output.commit(outputConf, objectModel);
                    }
                }
                catch (Exception e) {
                    if (output == null) throw e;
                    output.rollback(outputConf, objectModel, e);
                    throw e;
                }
                Object var18_19 = null;
                if (outputSelector == null) return Collections.unmodifiableMap(actionMap);
                if (output == null) break block12;
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                if (outputSelector == null) throw throwable;
                if (output != null) {
                    outputSelector.release((Object)output);
                }
                this.manager.release((Object)outputSelector);
                throw throwable;
            }
            outputSelector.release((Object)output);
        }
        this.manager.release((Object)outputSelector);
        return Collections.unmodifiableMap(actionMap);
    }

    private class Entry {
        public String key = null;
        public String value = null;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

