/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xslt.XSLTProcessor;
import org.apache.excalibur.xml.xslt.XSLTProcessorException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Logicsheet
extends AbstractLogEnabled {
    private SourceResolver resolver;
    private String systemId;
    protected Map namespaceURIs = new HashMap();
    private ComponentManager manager;

    public Logicsheet(Source source, ComponentManager manager, SourceResolver resolver) throws SAXException, IOException, ProcessingException {
        this.resolver = resolver;
        this.systemId = source.getURI();
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logicsheet(String systemId, ComponentManager manager, SourceResolver resolver) throws SAXException, IOException, SourceException, ProcessingException {
        this.resolver = resolver;
        this.manager = manager;
        Source source = null;
        try {
            source = this.resolver.resolveURI(systemId);
            this.systemId = source.getURI();
        }
        finally {
            this.resolver.release(source);
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public Map getNamespaceURIs() throws ProcessingException {
        this.getTransformerHandler();
        return this.namespaceURIs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TransformerHandler getTransformerHandler() throws ProcessingException {
        TransformerHandler transformerHandler;
        XSLTProcessor xsltProcessor = null;
        Source source = null;
        try {
            try {
                xsltProcessor = (XSLTProcessor)this.manager.lookup(XSLTProcessor.ROLE);
                source = this.resolver.resolveURI(this.systemId);
                SaveNamespaceFilter saveNSFilter = new SaveNamespaceFilter(this.namespaceURIs);
                transformerHandler = xsltProcessor.getTransformerHandler(source, (XMLFilter)saveNSFilter);
                Object var6_10 = null;
            }
            catch (ComponentException e) {
                throw new ProcessingException("Could not obtain XSLT processor", e);
            }
            catch (MalformedURLException e) {
                throw new ProcessingException("Could not resolve " + this.systemId, e);
            }
            catch (SourceException e) {
                throw SourceUtil.handle("Could not resolve " + this.systemId, e);
            }
            catch (IOException e) {
                throw new ProcessingException("Could not resolve " + this.systemId, e);
            }
            catch (XSLTProcessorException e) {
                throw new ProcessingException("Could not transform " + this.systemId, e);
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.manager.release((Component)xsltProcessor);
            this.resolver.release(source);
            throw throwable;
        }
        this.manager.release((Component)xsltProcessor);
        this.resolver.release(source);
        return transformerHandler;
    }

    protected class SaveNamespaceFilter
    extends XMLFilterImpl {
        private Map originalNamepaceURIs;

        public SaveNamespaceFilter(Map originalNamepaceURIs) {
            this.originalNamepaceURIs = originalNamepaceURIs;
        }

        public void setParent(XMLReader reader) {
            super.setParent(reader);
            reader.setContentHandler(this);
        }

        public void startDocument() throws SAXException {
            super.startDocument();
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.originalNamepaceURIs.put(uri, prefix);
            super.startPrefixMapping(prefix, uri);
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
        }
    }
}

