/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation.helpers;

import java.util.ArrayList;
import java.util.Map;
import org.apache.cocoon.transformation.helpers.EventRecorder;
import org.apache.cocoon.transformation.helpers.NOPRecorder;
import org.apache.xerces.dom.AttributeMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MirrorRecorder
extends NOPRecorder
implements EventRecorder,
Cloneable {
    private ArrayList events = new ArrayList();

    public MirrorRecorder() {
    }

    public MirrorRecorder(Node n) {
        if (n != null) {
            NodeList childs = n.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                try {
                    this.nodeToEvents(childs.item(i));
                    continue;
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
        }
    }

    private void nodeToEvents(Node n) throws SAXException {
        switch (n.getNodeType()) {
            case 1: {
                Attributes attrs;
                if (n.getAttributes() instanceof AttributeMap) {
                    NamedNodeMap map = n.getAttributes();
                    attrs = new AttributesImpl();
                    for (int i = 0; i < map.getLength(); ++i) {
                        Node node = map.item(i);
                        ((AttributesImpl)attrs).addAttribute(node.getNamespaceURI(), node.getLocalName(), node.getNodeName(), "CDATA", node.getNodeValue());
                    }
                } else {
                    attrs = (Attributes)((Object)n.getAttributes());
                }
                this.startElement(n.getNamespaceURI(), n.getNodeName(), n.getNodeName(), attrs);
                if (n.hasChildNodes()) {
                    NodeList childs = n.getChildNodes();
                    for (int i = 0; i < childs.getLength(); ++i) {
                        this.nodeToEvents(childs.item(i));
                    }
                }
                this.endElement(n.getNamespaceURI(), n.getNodeName(), n.getNodeName());
                break;
            }
            case 3: 
            case 4: {
                this.characters(n.getNodeValue());
            }
        }
    }

    public MirrorRecorder(MirrorRecorder n) {
        for (int i = 0; i < n.events.size(); ++i) {
            EventRecorder e = (EventRecorder)n.events.get(i);
            this.events.add(e.clone());
        }
    }

    public Object clone() {
        return new MirrorRecorder(this);
    }

    public void startElement(String namespace, String name, String raw, Attributes attr) throws SAXException {
        this.events.add(new StartEvent(namespace, name, raw, attr));
    }

    public void endElement(String namespace, String name, String raw) throws SAXException {
        this.events.add(new EndEvent(namespace, name, raw));
    }

    public void characters(char[] ary, int start, int length) throws SAXException {
        this.characters(new String(ary, start, length));
    }

    public void characters(String tmp) throws SAXException {
        int i = 0;
        int j = 0;
        while (tmp.length() > 0) {
            if ((i = tmp.indexOf(123, i)) == -1) {
                this.events.add(new CharacterEvent(tmp));
                return;
            }
            if (i >= 0) {
                this.events.add(new CharacterEvent(tmp.substring(0, i)));
            }
            if ((j = tmp.indexOf(125, i)) == -1) continue;
            this.events.add(new NullEvent(tmp.substring(i + 1, j)));
            tmp = tmp.substring(j + 1, tmp.length());
            i = 0;
        }
    }

    public void send(ContentHandler handler) throws SAXException {
        for (int i = 0; i < this.events.size(); ++i) {
            ((EventRecorder)this.events.get(i)).send(handler);
        }
    }

    public void send(ContentHandler handler, Map params) throws SAXException {
        for (int i = 0; i < this.events.size(); ++i) {
            if (this.events.get(i) instanceof NullEvent) {
                EventRecorder param = (EventRecorder)params.get(((NullEvent)this.events.get(i)).name());
                if (param == null) continue;
                param.send(handler);
                continue;
            }
            ((EventRecorder)this.events.get(i)).send(handler);
        }
    }

    public String text() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.events.size(); ++i) {
            s.append(this.events.get(i).toString());
        }
        return s.toString();
    }

    public String toString() {
        StringBuffer s = new StringBuffer("MirrorRecorder: ");
        s.append(String.valueOf(this.events.size()) + " event(s)");
        s.append("\ntext: ");
        for (int i = 0; i < this.events.size(); ++i) {
            if (!(this.events.get(i) instanceof CharacterEvent)) continue;
            s.append(this.events.get(i).toString());
        }
        return s.toString();
    }

    public void recycle() {
        this.events.clear();
    }

    public boolean empty() {
        return this.events.size() == 0;
    }

    class CharacterEvent
    implements EventRecorder {
        private String ch;

        public CharacterEvent(char[] ary, int start, int length) {
            this.ch = new String(ary, start, length);
        }

        public Object clone() {
            return new CharacterEvent(this.ch.toCharArray(), 0, this.ch.length());
        }

        public CharacterEvent(String str) {
            this.ch = str;
        }

        public void send(ContentHandler handler) throws SAXException {
            handler.characters(this.ch.toCharArray(), 0, this.ch.length());
        }

        public String toString() {
            return this.ch;
        }
    }

    class EndEvent
    implements EventRecorder {
        protected String uri;
        protected String name;
        protected String raw;

        public EndEvent(String namespace, String name, String raw) {
            this.uri = namespace;
            this.name = name;
            this.raw = raw;
        }

        public Object clone() {
            return new EndEvent(this.uri, this.name, this.raw);
        }

        public void send(ContentHandler handler) throws SAXException {
            handler.endElement(this.uri, this.name, this.raw);
        }

        public String toString() {
            return "</" + this.raw + ">";
        }
    }

    class StartEvent
    implements EventRecorder {
        protected String uri;
        protected String name;
        protected String raw;
        protected Attributes attr;

        public StartEvent(String namespace, String name, String raw, Attributes attr) {
            this.uri = namespace;
            this.name = name;
            this.raw = raw;
            this.attr = attr;
        }

        public void send(ContentHandler handler) throws SAXException {
            handler.startElement(this.uri, this.name, this.raw, this.attr);
        }

        public Object clone() {
            return new StartEvent(this.uri, this.name, this.raw, new AttributesImpl(this.attr));
        }

        public String toString() {
            StringBuffer str = new StringBuffer("<" + this.raw);
            if (this.attr != null) {
                for (int i = 0; i < this.attr.getLength(); ++i) {
                    str.append(" " + this.attr.getQName(i) + "=\"" + this.attr.getValue(i) + "\"");
                }
            }
            return str.append(">").toString();
        }
    }

    class NullEvent
    implements EventRecorder {
        private String s;

        public NullEvent(String s) {
            this.s = s;
        }

        public String name() {
            return this.s;
        }

        public void send(ContentHandler handler) throws SAXException {
        }

        public Object clone() {
            return new NullEvent(this.s);
        }

        public String toString() {
            return "{" + this.s + "}";
        }
    }
}

