/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Assignment
extends Expression {
    public Expression lhs;
    public Expression expression;

    public Assignment(Expression lhs, Expression expression, int sourceEnd) {
        this.lhs = lhs;
        lhs.bits |= 0x2000;
        this.expression = expression;
        this.sourceStart = lhs.sourceStart;
        this.sourceEnd = sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return ((Reference)this.lhs).analyseAssignment(currentScope, flowContext, flowInfo, this, false).unconditionalInits();
    }

    void checkAssignmentEffect(BlockScope scope) {
        Binding left = this.getDirectBinding(this.lhs);
        if (left != null && left == this.getDirectBinding(this.expression)) {
            scope.problemReporter().assignmentHasNoEffect(this, left.shortReadableName());
            this.bits |= 0x20000000;
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if ((this.bits & 0x20000000) != 0) {
            if (valueRequired) {
                this.expression.generateCode(currentScope, codeStream, true);
            }
        } else {
            ((Reference)this.lhs).generateAssignment(currentScope, codeStream, this, valueRequired);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    Binding getDirectBinding(Expression someExpression) {
        if (someExpression instanceof SingleNameReference) {
            return ((SingleNameReference)someExpression).binding;
        }
        if (someExpression instanceof FieldReference) {
            FieldReference fieldRef = (FieldReference)someExpression;
            if (fieldRef.receiver.isThis() && !(fieldRef.receiver instanceof QualifiedThisReference)) {
                return fieldRef.binding;
            }
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = AstNode.NotAConstant;
        if (!(this.lhs instanceof Reference)) {
            scope.problemReporter().expressionShouldBeAVariable(this.lhs);
        }
        this.resolvedType = this.lhs.resolveType(scope);
        TypeBinding rhsType = this.expression.resolveType(scope);
        if (this.resolvedType == null || rhsType == null) {
            return null;
        }
        this.checkAssignmentEffect(scope);
        if (this.expression.isConstantValueOfTypeAssignableToType(rhsType, this.resolvedType) || this.resolvedType.isBaseType() && BaseTypeBinding.isWidening(this.resolvedType.id, rhsType.id) || rhsType.isCompatibleWith(this.resolvedType)) {
            this.expression.implicitWidening(this.resolvedType, rhsType);
            return this.resolvedType;
        }
        scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.expression, rhsType, this.resolvedType);
        return this.resolvedType;
    }

    public String toString(int tab) {
        return String.valueOf(AstNode.tabString(tab)) + this.toStringExpressionNoParenthesis();
    }

    public String toStringExpression() {
        return "(" + this.toStringExpressionNoParenthesis() + ")";
    }

    public String toStringExpressionNoParenthesis() {
        return String.valueOf(this.lhs.toStringExpression()) + " " + "=" + (this.expression.constant != null && this.expression.constant != AstNode.NotAConstant ? " /*cst:" + this.expression.constant.toString() + "*/ " : " ") + this.expression.toStringExpression();
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.lhs.traverse(visitor, scope);
            this.expression.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

