/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.core.index.IEntryResult;
import org.eclipse.jdt.internal.core.index.impl.IndexInput;
import org.eclipse.jdt.internal.core.index.impl.IndexedFile;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;

public class MethodDeclarationPattern
extends MethodPattern {
    public MethodDeclarationPattern(char[] selector, int matchMode, boolean isCaseSensitive, char[] declaringQualification, char[] declaringSimpleName, char[] returnQualification, char[] returnSimpleName, char[][] parameterQualifications, char[][] parameterSimpleNames) {
        super(matchMode, isCaseSensitive);
        this.selector = isCaseSensitive ? selector : CharOperation.toLowerCase(selector);
        this.declaringQualification = isCaseSensitive ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        this.declaringSimpleName = isCaseSensitive ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        this.returnQualification = isCaseSensitive ? returnQualification : CharOperation.toLowerCase(returnQualification);
        char[] cArray = this.returnSimpleName = isCaseSensitive ? returnSimpleName : CharOperation.toLowerCase(returnSimpleName);
        if (parameterSimpleNames != null) {
            this.parameterQualifications = new char[parameterSimpleNames.length][];
            this.parameterSimpleNames = new char[parameterSimpleNames.length][];
            int i = 0;
            int max = parameterSimpleNames.length;
            while (i < max) {
                this.parameterQualifications[i] = isCaseSensitive ? parameterQualifications[i] : CharOperation.toLowerCase(parameterQualifications[i]);
                this.parameterSimpleNames[i] = isCaseSensitive ? parameterSimpleNames[i] : CharOperation.toLowerCase(parameterSimpleNames[i]);
                ++i;
            }
        }
        this.needsResolve = this.needsResolve();
    }

    public void decodeIndexEntry(IEntryResult entryResult) {
        char[] word = entryResult.getWord();
        int size = word.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf('/', word);
        this.decodedParameterCount = Integer.parseInt(new String(word, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
        this.decodedSelector = CharOperation.subarray(word, IIndexConstants.METHOD_DECL.length, lastSeparatorIndex);
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] references, IndexInput input, IJavaSearchScope scope) throws IOException {
        int i = 0;
        int max = references.length;
        while (i < max) {
            String path;
            IndexedFile file = input.getIndexedFile(references[i]);
            if (file != null && scope.encloses(path = IndexedFile.convertPath(file.getPath()))) {
                requestor.acceptMethodDeclaration(path, this.decodedSelector, this.decodedParameterCount);
            }
            ++i;
        }
    }

    public String getPatternName() {
        return "MethodDeclarationPattern: ";
    }

    public char[] indexEntryPrefix() {
        return AbstractIndexer.bestMethodDeclarationPrefix(this.selector, this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length, this.matchMode, this.isCaseSensitive);
    }

    protected int matchContainer() {
        return 2;
    }

    public boolean matchesBinary(Object binaryInfo, Object enclosingBinaryInfo) {
        int parameterCount;
        String returnTypeSignature;
        if (!(binaryInfo instanceof IBinaryMethod)) {
            return false;
        }
        IBinaryMethod method = (IBinaryMethod)binaryInfo;
        if (!this.matchesName(this.selector, method.getSelector())) {
            return false;
        }
        IBinaryType declaringType = (IBinaryType)enclosingBinaryInfo;
        if (declaringType != null) {
            char[] declaringTypeName = (char[])declaringType.getName().clone();
            CharOperation.replace(declaringTypeName, '/', '.');
            if (!this.matchesType(this.declaringSimpleName, this.declaringQualification, declaringTypeName)) {
                return false;
            }
        }
        String methodDescriptor = new String(method.getMethodDescriptor()).replace('/', '.');
        if (this.declaringSimpleName == null && !this.matchesType(this.returnSimpleName, this.returnQualification, (returnTypeSignature = Signature.toString(Signature.getReturnType(methodDescriptor))).toCharArray())) {
            return false;
        }
        int n = parameterCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (parameterCount > -1) {
            String[] arguments = Signature.getParameterTypes(methodDescriptor);
            int argumentCount = arguments.length;
            if (parameterCount != argumentCount) {
                return false;
            }
            int i = 0;
            while (i < parameterCount) {
                char[] type = this.parameterSimpleNames[i];
                char[] qualification = this.parameterQualifications[i];
                if (!this.matchesType(type, qualification, Signature.toString(arguments[i]).toCharArray())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public int matchLevel(AstNode node, boolean resolve) {
        int parameterCount;
        char[][] methodReturnTypeName;
        char[] sourceName;
        if (!(node instanceof MethodDeclaration)) {
            return 0;
        }
        MethodDeclaration method = (MethodDeclaration)node;
        if (resolve) {
            return this.matchLevel(method.binding);
        }
        if (!this.matchesName(this.selector, method.selector)) {
            return 0;
        }
        TypeReference methodReturnType = method.returnType;
        if (methodReturnType != null && !this.matchesName(this.returnSimpleName, sourceName = this.toArrayName((methodReturnTypeName = methodReturnType.getTypeName())[methodReturnTypeName.length - 1], methodReturnType.dimensions()))) {
            return 0;
        }
        int n = parameterCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (parameterCount > -1) {
            int argumentCount;
            int n2 = argumentCount = method.arguments == null ? 0 : method.arguments.length;
            if (parameterCount != argumentCount) {
                return 0;
            }
        }
        return this.needsResolve ? 1 : 2;
    }

    public int matchLevel(Binding binding) {
        int parameterCount;
        if (binding == null) {
            return 3;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding method = (MethodBinding)binding;
        if (!this.matchesName(this.selector, method.selector)) {
            return 0;
        }
        ReferenceBinding declaringType = method.declaringClass;
        int level = !method.isStatic() && !method.isPrivate() ? this.matchLevelAsSubtype(declaringType, this.declaringSimpleName, this.declaringQualification) : this.matchLevelForType(this.declaringSimpleName, this.declaringQualification, declaringType);
        if (level == 0) {
            return 0;
        }
        if (this.declaringSimpleName == null) {
            int newLevel = this.matchLevelForType(this.returnSimpleName, this.returnQualification, method.returnType);
            switch (newLevel) {
                case 0: {
                    return 0;
                }
                case 2: {
                    break;
                }
                default: {
                    level = newLevel;
                }
            }
        }
        int n = parameterCount = this.parameterSimpleNames == null ? -1 : this.parameterSimpleNames.length;
        if (parameterCount > -1) {
            int argumentCount;
            int n2 = argumentCount = method.parameters == null ? 0 : method.parameters.length;
            if (parameterCount != argumentCount) {
                return 0;
            }
            int i = 0;
            while (i < parameterCount) {
                char[] qualification = this.parameterQualifications[i];
                char[] type = this.parameterSimpleNames[i];
                int newLevel = this.matchLevelForType(type, qualification, method.parameters[i]);
                switch (newLevel) {
                    case 0: {
                        return 0;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        level = newLevel;
                    }
                }
                ++i;
            }
        }
        return level;
    }
}

