/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.eval;

import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.eval.CodeSnippetCodeStream;
import org.eclipse.jdt.internal.eval.CodeSnippetScope;
import org.eclipse.jdt.internal.eval.EvaluationConstants;
import org.eclipse.jdt.internal.eval.EvaluationContext;

public class CodeSnippetSingleNameReference
extends SingleNameReference
implements EvaluationConstants,
InvocationSite,
ProblemReasons {
    EvaluationContext evaluationContext;
    FieldBinding delegateThis;

    public CodeSnippetSingleNameReference(char[] source, long pos, EvaluationContext evaluationContext) {
        super(source, pos);
        this.evaluationContext = evaluationContext;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.binding;
                if (!fieldBinding.isBlankFinal() || !currentScope.allowBlankFinalFieldAssignment(fieldBinding) || flowInfo.isDefinitelyAssigned(fieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                    currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                }
                if (flowInfo.isReachable()) {
                    localBinding.useFlag = 1;
                    break;
                }
                if (localBinding.useFlag != 0) break;
                localBinding.useFlag = 2;
            }
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        if (this.delegateThis == null) {
            return super.checkFieldAccess(scope);
        }
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        this.bits &= 0xFFFFFFF8;
        this.bits |= 1;
        if (!fieldBinding.isStatic() && this.evaluationContext.isStatic) {
            scope.problemReporter().staticFieldAccessToNonStaticVariable(this, fieldBinding);
            this.constant = AstNode.NotAConstant;
            return null;
        }
        this.constant = FieldReference.getConstantFor(fieldBinding, this, true, scope);
        if (this.isFieldUseDeprecated(fieldBinding, scope)) {
            scope.problemReporter().deprecatedField(fieldBinding, this);
        }
        return fieldBinding.type;
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
        if (assignment.expression.isCompactableOperation()) {
            SingleNameReference variableReference;
            BinaryExpression operation = (BinaryExpression)assignment.expression;
            if (operation.left instanceof SingleNameReference) {
                variableReference = (SingleNameReference)operation.left;
                if (variableReference.binding == this.binding) {
                    variableReference.generateCompoundAssignment(currentScope, codeStream, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], operation.right, (operation.bits & 0xFC0) >> 6, operation.left.implicitConversion, valueRequired);
                    return;
                }
            }
            int operator = (operation.bits & 0xFC0) >> 6;
            if (operation.right instanceof SingleNameReference && (operator == 14 || operator == 15)) {
                variableReference = (SingleNameReference)operation.right;
                if (variableReference.binding == this.binding && operation.left.constant != AstNode.NotAConstant && operation.left.implicitConversion >> 4 != 11 && operation.right.implicitConversion >> 4 != 11) {
                    variableReference.generateCompoundAssignment(currentScope, codeStream, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], operation.left, operator, operation.right.implicitConversion, valueRequired);
                    return;
                }
            }
        }
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                    if (!fieldBinding.isStatic()) {
                        if ((this.bits & 0x1FE0) != 0) {
                            ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                            Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                            codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                        } else {
                            this.generateReceiver(codeStream);
                        }
                    }
                    assignment.expression.generateCode(currentScope, codeStream, true);
                    this.fieldStore(codeStream, fieldBinding, null, valueRequired);
                    if (valueRequired) {
                        codeStream.generateImplicitConversion(assignment.implicitConversion);
                    }
                } else {
                    ((CodeSnippetCodeStream)codeStream).generateEmulationForField(fieldBinding);
                    if (!fieldBinding.isStatic()) {
                        if ((this.bits & 0x1FE0) != 0) {
                            currentScope.problemReporter().needImplementation();
                        } else {
                            this.generateReceiver(codeStream);
                        }
                    } else {
                        codeStream.aconst_null();
                    }
                    assignment.expression.generateCode(currentScope, codeStream, true);
                    if (valueRequired) {
                        if (fieldBinding.type == BaseTypes.LongBinding || fieldBinding.type == BaseTypes.DoubleBinding) {
                            codeStream.dup2_x2();
                        } else {
                            codeStream.dup_x2();
                        }
                    }
                    ((CodeSnippetCodeStream)codeStream).generateEmulatedWriteAccessForField(fieldBinding);
                    if (valueRequired) {
                        codeStream.generateImplicitConversion(assignment.implicitConversion);
                    }
                }
                return;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (localBinding.resolvedPosition == -1) {
                    if (assignment.expression.constant != AstNode.NotAConstant) {
                        if (valueRequired) {
                            codeStream.generateConstant(assignment.expression.constant, assignment.implicitConversion);
                        }
                    } else {
                        assignment.expression.generateCode(currentScope, codeStream, true);
                        if (valueRequired) {
                            codeStream.generateImplicitConversion(assignment.implicitConversion);
                        } else if (localBinding.type == BaseTypes.LongBinding || localBinding.type == BaseTypes.DoubleBinding) {
                            codeStream.pop2();
                        } else {
                            codeStream.pop();
                        }
                    }
                    return;
                }
                assignment.expression.generateCode(currentScope, codeStream, true);
                codeStream.store(localBinding, valueRequired);
                if ((this.bits & 8) != 0) {
                    localBinding.recordInitializationStartPC(codeStream.position);
                }
                if (!valueRequired) break;
                codeStream.generateImplicitConversion(assignment.implicitConversion);
            }
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != AstNode.NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        } else {
            switch (this.bits & 7) {
                case 1: {
                    if (!valueRequired) break;
                    FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                    if (fieldBinding.constant == AstNode.NotAConstant) {
                        if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                            boolean isStatic = fieldBinding.isStatic();
                            if (!isStatic) {
                                if ((this.bits & 0x1FE0) != 0) {
                                    ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                                    Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                                    codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                                } else {
                                    this.generateReceiver(codeStream);
                                }
                            }
                            if (isStatic) {
                                codeStream.getstatic(fieldBinding);
                            } else {
                                codeStream.getfield(fieldBinding);
                            }
                        } else {
                            if (!fieldBinding.isStatic()) {
                                if ((this.bits & 0x1FE0) != 0) {
                                    currentScope.problemReporter().needImplementation();
                                } else {
                                    this.generateReceiver(codeStream);
                                }
                            } else {
                                codeStream.aconst_null();
                            }
                            ((CodeSnippetCodeStream)codeStream).generateEmulatedReadAccessForField(fieldBinding);
                        }
                        codeStream.generateImplicitConversion(this.implicitConversion);
                        break;
                    }
                    codeStream.generateConstant(fieldBinding.constant, this.implicitConversion);
                    break;
                }
                case 2: {
                    LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                    if (!valueRequired) break;
                    if ((this.bits & 0x1FE0) != 0) {
                        Object[] path = currentScope.getEmulationPath(localBinding);
                        codeStream.generateOuterAccess(path, this, localBinding, currentScope);
                    } else {
                        codeStream.load(localBinding);
                    }
                    codeStream.generateImplicitConversion(this.implicitConversion);
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, MethodBinding writeAccessor, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.isStatic()) {
                    if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                        codeStream.getstatic(fieldBinding);
                        break;
                    }
                    ((CodeSnippetCodeStream)codeStream).generateEmulationForField(fieldBinding);
                    codeStream.aconst_null();
                    codeStream.aconst_null();
                    ((CodeSnippetCodeStream)codeStream).generateEmulatedReadAccessForField(fieldBinding);
                    break;
                }
                if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                    if ((this.bits & 0x1FE0) != 0) {
                        ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                        Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                        codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                    } else {
                        this.generateReceiver(codeStream);
                    }
                    codeStream.dup();
                    codeStream.getfield(fieldBinding);
                    break;
                }
                if ((this.bits & 0x1FE0) != 0) {
                    currentScope.problemReporter().needImplementation();
                }
                ((CodeSnippetCodeStream)codeStream).generateEmulationForField(fieldBinding);
                this.generateReceiver(codeStream);
                codeStream.dup();
                ((CodeSnippetCodeStream)codeStream).generateEmulatedReadAccessForField(fieldBinding);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                switch (localBinding.type.id) {
                    case 11: {
                        codeStream.generateStringAppend(currentScope, this, expression);
                        if (valueRequired) {
                            codeStream.dup();
                        }
                        codeStream.store(localBinding, false);
                        return;
                    }
                    case 10: {
                        int increment;
                        Constant assignConstant = expression.constant;
                        if (assignConstant == AstNode.NotAConstant || assignConstant.typeID() == 9 || assignConstant.typeID() == 8 || (increment = assignConstant.intValue()) != (short)increment) break;
                        switch (operator) {
                            case 14: {
                                codeStream.iinc(localBinding.resolvedPosition, increment);
                                if (valueRequired) {
                                    codeStream.load(localBinding);
                                }
                                return;
                            }
                            case 13: {
                                codeStream.iinc(localBinding.resolvedPosition, -increment);
                                if (valueRequired) {
                                    codeStream.load(localBinding);
                                }
                                return;
                            }
                        }
                    }
                }
                codeStream.load(localBinding);
            }
        }
        int operationTypeID = this.implicitConversion >> 4;
        if (operationTypeID == 11 || operationTypeID == 1) {
            codeStream.generateStringAppend(currentScope, null, expression);
        } else {
            codeStream.generateImplicitConversion(this.implicitConversion);
            if (expression == IntLiteral.One) {
                codeStream.generateConstant(expression.constant, this.implicitConversion);
            } else {
                expression.generateCode(currentScope, codeStream, true);
            }
            codeStream.sendOperator(operator, operationTypeID);
            codeStream.generateImplicitConversion(assignmentImplicitConversion);
        }
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                    this.fieldStore(codeStream, fieldBinding, writeAccessor, valueRequired);
                } else {
                    if (valueRequired) {
                        if (fieldBinding.type == BaseTypes.LongBinding || fieldBinding.type == BaseTypes.DoubleBinding) {
                            codeStream.dup2_x2();
                        } else {
                            codeStream.dup_x2();
                        }
                    }
                    ((CodeSnippetCodeStream)codeStream).generateEmulatedWriteAccessForField(fieldBinding);
                }
                return;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (valueRequired) {
                    if (localBinding.type == BaseTypes.LongBinding || localBinding.type == BaseTypes.DoubleBinding) {
                        codeStream.dup2();
                    } else {
                        codeStream.dup();
                    }
                }
                codeStream.store(localBinding, false);
            }
        }
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
        switch (this.bits & 7) {
            case 1: {
                FieldBinding fieldBinding = (FieldBinding)this.codegenBinding;
                if (fieldBinding.canBeSeenBy(this.getReceiverType(currentScope), this, currentScope)) {
                    if (fieldBinding.isStatic()) {
                        codeStream.getstatic(fieldBinding);
                    } else {
                        if ((this.bits & 0x1FE0) != 0) {
                            ReferenceBinding targetType = currentScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                            Object[] emulationPath = currentScope.getEmulationPath(targetType, true, false);
                            codeStream.generateOuterAccess(emulationPath, this, targetType, currentScope);
                        } else {
                            this.generateReceiver(codeStream);
                        }
                        codeStream.dup();
                        codeStream.getfield(fieldBinding);
                    }
                    if (valueRequired) {
                        if (fieldBinding.isStatic()) {
                            if (fieldBinding.type == BaseTypes.LongBinding || fieldBinding.type == BaseTypes.DoubleBinding) {
                                codeStream.dup2();
                            } else {
                                codeStream.dup();
                            }
                        } else if (fieldBinding.type == BaseTypes.LongBinding || fieldBinding.type == BaseTypes.DoubleBinding) {
                            codeStream.dup2_x1();
                        } else {
                            codeStream.dup_x1();
                        }
                    }
                    codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
                    codeStream.sendOperator(postIncrement.operator, fieldBinding.type.id);
                    codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
                    this.fieldStore(codeStream, fieldBinding, null, false);
                } else {
                    if (fieldBinding.isStatic()) {
                        codeStream.aconst_null();
                    } else if ((this.bits & 0x1FE0) != 0) {
                        currentScope.problemReporter().needImplementation();
                    } else {
                        this.generateReceiver(codeStream);
                    }
                    ((CodeSnippetCodeStream)codeStream).generateEmulatedReadAccessForField(fieldBinding);
                    if (valueRequired) {
                        if (fieldBinding.type == BaseTypes.LongBinding || fieldBinding.type == BaseTypes.DoubleBinding) {
                            codeStream.dup2();
                        } else {
                            codeStream.dup();
                        }
                    }
                    ((CodeSnippetCodeStream)codeStream).generateEmulationForField(fieldBinding);
                    if (fieldBinding.type == BaseTypes.LongBinding || fieldBinding.type == BaseTypes.DoubleBinding) {
                        codeStream.dup_x2();
                        codeStream.pop();
                        if (fieldBinding.isStatic()) {
                            codeStream.aconst_null();
                        } else {
                            this.generateReceiver(codeStream);
                        }
                        codeStream.dup_x2();
                        codeStream.pop();
                    } else {
                        codeStream.dup_x1();
                        codeStream.pop();
                        if (fieldBinding.isStatic()) {
                            codeStream.aconst_null();
                        } else {
                            this.generateReceiver(codeStream);
                        }
                        codeStream.dup_x1();
                        codeStream.pop();
                    }
                    codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
                    codeStream.sendOperator(postIncrement.operator, fieldBinding.type.id);
                    codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
                    ((CodeSnippetCodeStream)codeStream).generateEmulatedWriteAccessForField(fieldBinding);
                }
                return;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.codegenBinding;
                if (localBinding.type == BaseTypes.IntBinding) {
                    if (valueRequired) {
                        codeStream.load(localBinding);
                    }
                    if (postIncrement.operator == 14) {
                        codeStream.iinc(localBinding.resolvedPosition, 1);
                        break;
                    }
                    codeStream.iinc(localBinding.resolvedPosition, -1);
                    break;
                }
                codeStream.load(localBinding);
                if (valueRequired) {
                    if (localBinding.type == BaseTypes.LongBinding || localBinding.type == BaseTypes.DoubleBinding) {
                        codeStream.dup2();
                    } else {
                        codeStream.dup();
                    }
                }
                codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
                codeStream.sendOperator(postIncrement.operator, localBinding.type.id);
                codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
                codeStream.store(localBinding, false);
            }
        }
    }

    public void generateReceiver(CodeStream codeStream) {
        codeStream.aload_0();
        if (this.delegateThis != null) {
            codeStream.getfield(this.delegateThis);
        }
    }

    public TypeBinding getReceiverType(BlockScope currentScope) {
        if (this.receiverType != null) {
            return this.receiverType;
        }
        Scope scope = currentScope.parent;
        while (true) {
            switch (scope.kind) {
                case 3: {
                    this.receiverType = ((ClassScope)scope).referenceContext.binding;
                    return this.receiverType;
                }
            }
            scope = scope.parent;
        }
    }

    public TypeBinding reportError(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.binding instanceof ProblemFieldBinding && ((ProblemFieldBinding)this.binding).problemId() == 1 && this.evaluationContext.declaringTypeName != null) {
            this.delegateThis = scope.getField(scope.enclosingSourceType(), EvaluationConstants.DELEGATE_THIS, this);
            if (this.delegateThis != null) {
                this.codegenBinding = this.binding = scope.getField(this.delegateThis.type, this.token, this);
                if (!this.binding.isValidBinding()) {
                    return super.reportError(scope);
                }
                return this.checkFieldAccess(scope);
            }
        }
        if (this.binding instanceof ProblemBinding && ((ProblemBinding)this.binding).problemId() == 1 && this.evaluationContext.declaringTypeName != null) {
            this.delegateThis = scope.getField(scope.enclosingSourceType(), EvaluationConstants.DELEGATE_THIS, this);
            if (this.delegateThis != null) {
                FieldBinding fieldBinding = scope.getField(this.delegateThis.type, this.token, this);
                if (!fieldBinding.isValidBinding()) {
                    if (((ProblemFieldBinding)fieldBinding).problemId() == 2) {
                        CodeSnippetScope localScope = new CodeSnippetScope(scope);
                        this.codegenBinding = this.binding = localScope.getFieldForCodeSnippet(this.delegateThis.type, this.token, this);
                        return this.checkFieldAccess(scope);
                    }
                    return super.reportError(scope);
                }
                this.codegenBinding = this.binding = fieldBinding;
                return this.checkFieldAccess(scope);
            }
        }
        return super.reportError(scope);
    }
}

