/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;

public class TableColumn
extends FObj {
    Length columnWidthPropVal;
    int columnWidth;
    int columnOffset;
    int numColumnsRepeated;
    int iColumnNumber;
    boolean setup = false;
    AreaContainer areaContainer;

    public static FObj.Maker maker() {
        return new Maker();
    }

    public TableColumn(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
        if (!(parent instanceof Table)) {
            throw new FOPException("A table column must be child of fo:table, not " + parent.getName(), systemId, line, column);
        }
    }

    public String getName() {
        return "fo:table-column";
    }

    public Length getColumnWidthAsLength() {
        return this.columnWidthPropVal;
    }

    public int getColumnWidth() {
        return this.columnWidth;
    }

    public void setColumnWidth(int columnWidth) {
        this.columnWidth = columnWidth;
    }

    public int getColumnNumber() {
        return this.iColumnNumber;
    }

    public int getNumColumnsRepeated() {
        return this.numColumnsRepeated;
    }

    public void doSetup(Area area) throws FOPException {
        BorderAndPadding bap = this.propMgr.getBorderAndPadding();
        BackgroundProps bProps = this.propMgr.getBackgroundProps();
        this.iColumnNumber = this.properties.get("column-number").getNumber().intValue();
        this.numColumnsRepeated = this.properties.get("number-columns-repeated").getNumber().intValue();
        this.columnWidthPropVal = this.properties.get("column-width").getLength();
        this.columnWidth = this.columnWidthPropVal.mvalue();
        String id = this.properties.get("id").getString();
        try {
            area.getIDReferences().initializeID(id, area);
        }
        catch (FOPException e) {
            if (!e.isLocationSet()) {
                e.setLocation(this.systemId, this.line, this.column);
            }
            throw e;
        }
        this.setup = true;
    }

    public int layout(Area area) throws FOPException {
        if (this.marker == -1001) {
            return 1;
        }
        if (this.marker == -1000 && !this.setup) {
            this.doSetup(area);
        }
        if (this.columnWidth > 0) {
            this.areaContainer = new AreaContainer(this.propMgr.getFontState(area.getFontInfo()), this.columnOffset, 0, this.columnWidth, area.getContentHeight(), 88);
            this.areaContainer.foCreator = this;
            this.areaContainer.setPage(area.getPage());
            this.areaContainer.setBorderAndPadding(this.propMgr.getBorderAndPadding());
            this.areaContainer.setBackground(this.propMgr.getBackgroundProps());
            this.areaContainer.setHeight(area.getHeight());
            area.addChild(this.areaContainer);
        }
        return 1;
    }

    public void setColumnOffset(int columnOffset) {
        this.columnOffset = columnOffset;
    }

    public void setHeight(int height) {
        if (this.areaContainer != null) {
            this.areaContainer.setMaxHeight(height);
            this.areaContainer.setHeight(height);
        }
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new TableColumn(parent, propertyList, systemId, line, column);
        }
    }
}

