/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import com.coyotegulch.jisp.DuplicateKey;
import com.coyotegulch.jisp.HashIndexBucket;
import com.coyotegulch.jisp.HashIndexHeader;
import com.coyotegulch.jisp.KeyNotFound;
import com.coyotegulch.jisp.KeyObject;
import com.coyotegulch.jisp.ObjectDatabaseFile;
import com.coyotegulch.jisp.ObjectIndex;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class HashIndex
implements ObjectIndex {
    private static final long NULL_POS = -1L;
    private String m_name;
    private ObjectDatabaseFile m_file;
    private HashIndexHeader m_header;

    public HashIndex(String string, int n, int n2, KeyObject keyObject) throws IOException, ClassNotFoundException {
        this.m_name = new String(string);
        this.m_file = new ObjectDatabaseFile(string, true);
        this.m_header = new HashIndexHeader();
        this.m_header.m_nBuckets = n > 0 ? n : 101;
        this.m_header.m_bucketPos = new long[this.m_header.m_nBuckets];
        int n3 = 0;
        while (n3 < this.m_header.m_nBuckets) {
            this.m_header.m_bucketPos[n3] = -1L;
            ++n3;
        }
        this.m_header.m_nullKey = keyObject.makeNullKey();
        this.m_header.m_padding = n2 / n + 1;
        if (this.m_header.m_padding < 10) {
            this.m_header.m_padding = 10;
        }
        this.m_file.rewind();
        this.m_file.writeObject(this.m_header);
    }

    public HashIndex(String string) throws IOException, ClassNotFoundException {
        this.m_file = new ObjectDatabaseFile(string, false);
        this.m_file.rewind();
        this.m_header = (HashIndexHeader)this.m_file.readObject();
    }

    public void insertKey(KeyObject keyObject, long l) throws IOException, DuplicateKey, ClassNotFoundException {
        boolean bl;
        int n;
        int n2 = keyObject.hashCode() % this.m_header.m_nBuckets;
        HashIndexBucket hashIndexBucket = null;
        if (this.m_header.m_bucketPos[n2] == -1L) {
            hashIndexBucket = new HashIndexBucket();
            hashIndexBucket.m_key = new KeyObject[this.m_header.m_padding];
            hashIndexBucket.m_pos = new long[this.m_header.m_padding];
            n = 0;
            while (n < this.m_header.m_padding) {
                hashIndexBucket.m_key[n] = this.m_header.m_nullKey.makeNullKey();
                hashIndexBucket.m_pos[n] = -1L;
                ++n;
            }
            hashIndexBucket.m_empty = this.m_header.m_padding;
            bl = true;
        } else {
            this.m_file.seek(this.m_header.m_bucketPos[n2]);
            hashIndexBucket = (HashIndexBucket)this.m_file.readObject();
            bl = false;
        }
        if (hashIndexBucket.m_empty == 0) {
            int n3 = hashIndexBucket.m_key.length + this.m_header.m_padding;
            KeyObject[] keyObjectArray = new KeyObject[n3];
            long[] lArray = new long[n3];
            int n4 = 0;
            while (n4 < n3) {
                if (n4 >= hashIndexBucket.m_key.length) {
                    keyObjectArray[n4] = this.m_header.m_nullKey.makeNullKey();
                    lArray[n4] = -1L;
                } else {
                    keyObjectArray[n4] = hashIndexBucket.m_key[n4];
                    lArray[n4] = hashIndexBucket.m_pos[n4];
                }
                ++n4;
            }
            n = hashIndexBucket.m_key.length;
            hashIndexBucket.m_key = keyObjectArray;
            hashIndexBucket.m_pos = lArray;
            hashIndexBucket.m_empty = this.m_header.m_padding - 1;
            hashIndexBucket.m_key[n] = keyObject;
            hashIndexBucket.m_pos[n] = l;
            this.m_file.seek(this.m_header.m_bucketPos[n2]);
            this.m_file.delete();
            this.m_header.m_bucketPos[n2] = this.m_file.writeObject(hashIndexBucket);
            this.m_file.rewind();
            this.m_file.rewriteObject(this.m_header);
        } else {
            n = 0;
            while (hashIndexBucket.m_pos[n] != -1L) {
                ++n;
            }
            hashIndexBucket.m_key[n] = keyObject;
            hashIndexBucket.m_pos[n] = l;
            --hashIndexBucket.m_empty;
            if (bl) {
                this.m_header.m_bucketPos[n2] = this.m_file.writeObject(hashIndexBucket);
                this.m_file.rewind();
                this.m_file.rewriteObject(this.m_header);
            } else {
                this.m_file.seek(this.m_header.m_bucketPos[n2]);
                this.m_file.rewriteObject(hashIndexBucket);
            }
        }
    }

    public void replaceKey(KeyObject keyObject, long l) throws IOException, ClassNotFoundException {
        try {
            this.removeKey(keyObject);
        }
        catch (KeyNotFound keyNotFound) {
            // empty catch block
        }
        this.insertKey(keyObject, l);
    }

    public void storeKey(KeyObject keyObject, long l) throws IOException, ClassNotFoundException {
        this.replaceKey(keyObject, l);
    }

    public long findKey(KeyObject keyObject) throws KeyNotFound, IOException, ClassNotFoundException {
        int n = keyObject.hashCode() % this.m_header.m_nBuckets;
        HashIndexBucket hashIndexBucket = null;
        if (this.m_header.m_bucketPos[n] == -1L) {
            throw new KeyNotFound();
        }
        this.m_file.seek(this.m_header.m_bucketPos[n]);
        hashIndexBucket = (HashIndexBucket)this.m_file.readObject();
        boolean bl = false;
        int n2 = 0;
        while (n2 < hashIndexBucket.m_key.length) {
            if (hashIndexBucket.m_key[n2] != null && keyObject.compareTo(hashIndexBucket.m_key[n2]) == 0) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw new KeyNotFound();
        }
        return hashIndexBucket.m_pos[n2];
    }

    public void removeKey(KeyObject keyObject) throws IOException, ClassNotFoundException {
        int n = keyObject.hashCode() % this.m_header.m_nBuckets;
        HashIndexBucket hashIndexBucket = null;
        if (this.m_header.m_bucketPos[n] == -1L) {
            throw new KeyNotFound();
        }
        this.m_file.seek(this.m_header.m_bucketPos[n]);
        hashIndexBucket = (HashIndexBucket)this.m_file.readObject();
        boolean bl = false;
        int n2 = 0;
        while (n2 < hashIndexBucket.m_key.length) {
            if (hashIndexBucket.m_key[n2] != null && keyObject.compareTo(hashIndexBucket.m_key[n2]) == 0) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (!bl) {
            throw new KeyNotFound();
        }
        hashIndexBucket.m_key[n2] = this.m_header.m_nullKey.makeNullKey();
        hashIndexBucket.m_pos[n2] = -1L;
        ++hashIndexBucket.m_empty;
        this.m_file.seek(this.m_header.m_bucketPos[n]);
        this.m_file.delete();
        this.m_header.m_bucketPos[n] = this.m_file.writeObject(hashIndexBucket);
        this.m_file.rewind();
        this.m_file.rewriteObject(this.m_header);
    }

    public void optimize() throws IOException, ClassNotFoundException {
        Serializable serializable;
        String string = "" + System.currentTimeMillis() + ".tmp";
        ObjectDatabaseFile objectDatabaseFile = new ObjectDatabaseFile(string, true);
        HashIndexHeader hashIndexHeader = new HashIndexHeader();
        hashIndexHeader.m_nBuckets = this.m_header.m_nBuckets;
        hashIndexHeader.m_nullKey = this.m_header.m_nullKey.makeNullKey();
        hashIndexHeader.m_padding = this.m_header.m_padding;
        hashIndexHeader.m_bucketPos = (long[])this.m_header.m_bucketPos.clone();
        objectDatabaseFile.rewind();
        objectDatabaseFile.writeObject(hashIndexHeader);
        int n = 0;
        while (n < this.m_header.m_nBuckets) {
            if (this.m_header.m_bucketPos[n] != -1L) {
                this.m_file.seek(this.m_header.m_bucketPos[n]);
                serializable = (HashIndexBucket)this.m_file.readObject();
                hashIndexHeader.m_bucketPos[n] = objectDatabaseFile.writeObject(serializable);
            }
            ++n;
        }
        objectDatabaseFile.rewind();
        objectDatabaseFile.rewriteObject(hashIndexHeader);
        objectDatabaseFile.close();
        this.m_file.close();
        this.m_file = null;
        serializable = new File(this.m_name);
        serializable.delete();
        File file = new File(string);
        file.renameTo((File)serializable);
        this.m_file = new ObjectDatabaseFile(this.m_name, false);
        this.m_header = hashIndexHeader;
    }

    public void close() throws IOException {
        if (this.m_file != null) {
            this.m_file.close();
            this.m_file = null;
        }
    }
}

