/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.image.rendered;

import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.ext.awt.image.rendered.AbstractRed;
import org.apache.batik.ext.awt.image.rendered.CachableRed;

public class ColorMatrixRed
extends AbstractRed {
    private float[][] matrix;

    public float[][] getMatrix() {
        return this.copyMatrix(this.matrix);
    }

    public void setMatrix(float[][] fArray) {
        float[][] fArray2 = this.copyMatrix(fArray);
        if (fArray2 == null) {
            throw new IllegalArgumentException();
        }
        if (fArray2.length != 4) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < 4; ++i) {
            if (fArray2[i].length == 5) continue;
            throw new IllegalArgumentException("" + i + " : " + fArray2[i].length);
        }
        this.matrix = fArray;
    }

    private float[][] copyMatrix(float[][] fArray) {
        if (fArray == null) {
            return null;
        }
        float[][] fArrayArray = new float[fArray.length][];
        for (int i = 0; i < fArray.length; ++i) {
            if (fArray[i] == null) continue;
            fArrayArray[i] = new float[fArray[i].length];
            System.arraycopy(fArray[i], 0, fArrayArray[i], 0, fArray[i].length);
        }
        return fArrayArray;
    }

    public ColorMatrixRed(CachableRed cachableRed, float[][] fArray) {
        this.setMatrix(fArray);
        ColorModel colorModel = GraphicsUtil.Linear_sRGB_Unpre;
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(cachableRed.getWidth(), cachableRed.getHeight());
        this.init(cachableRed, cachableRed.getBounds(), colorModel, sampleModel, cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().elementAt(0);
        writableRaster = cachableRed.copyData(writableRaster);
        ColorModel colorModel = cachableRed.getColorModel();
        GraphicsUtil.coerceData(writableRaster, colorModel, false);
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        int n3 = writableRaster.getWidth();
        int n4 = writableRaster.getHeight();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getBankData()[0];
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)writableRaster.getSampleModel();
        int n5 = dataBufferInt.getOffset() + singlePixelPackedSampleModel.getOffset(n - writableRaster.getSampleModelTranslateX(), n2 - writableRaster.getSampleModelTranslateY());
        int n6 = ((SinglePixelPackedSampleModel)writableRaster.getSampleModel()).getScanlineStride();
        int n7 = n6 - n3;
        int n8 = n5;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        float f = this.matrix[0][0] / 255.0f;
        float f2 = this.matrix[0][1] / 255.0f;
        float f3 = this.matrix[0][2] / 255.0f;
        float f4 = this.matrix[0][3] / 255.0f;
        float f5 = this.matrix[0][4] / 255.0f;
        float f6 = this.matrix[1][0] / 255.0f;
        float f7 = this.matrix[1][1] / 255.0f;
        float f8 = this.matrix[1][2] / 255.0f;
        float f9 = this.matrix[1][3] / 255.0f;
        float f10 = this.matrix[1][4] / 255.0f;
        float f11 = this.matrix[2][0] / 255.0f;
        float f12 = this.matrix[2][1] / 255.0f;
        float f13 = this.matrix[2][2] / 255.0f;
        float f14 = this.matrix[2][3] / 255.0f;
        float f15 = this.matrix[2][4] / 255.0f;
        float f16 = this.matrix[3][0] / 255.0f;
        float f17 = this.matrix[3][1] / 255.0f;
        float f18 = this.matrix[3][2] / 255.0f;
        float f19 = this.matrix[3][3] / 255.0f;
        float f20 = this.matrix[3][4] / 255.0f;
        for (n17 = 0; n17 < n4; ++n17) {
            for (n18 = 0; n18 < n3; ++n18) {
                n19 = nArray[n8];
                n12 = n19 >>> 24;
                n9 = n19 >> 16 & 0xFF;
                n10 = n19 >> 8 & 0xFF;
                n11 = n19 & 0xFF;
                n13 = (int)((f * (float)n9 + f2 * (float)n10 + f3 * (float)n11 + f4 * (float)n12 + f5) * 255.0f);
                n14 = (int)((f6 * (float)n9 + f7 * (float)n10 + f8 * (float)n11 + f9 * (float)n12 + f10) * 255.0f);
                n15 = (int)((f11 * (float)n9 + f12 * (float)n10 + f13 * (float)n11 + f14 * (float)n12 + f15) * 255.0f);
                n16 = (int)((f16 * (float)n9 + f17 * (float)n10 + f18 * (float)n11 + f19 * (float)n12 + f20) * 255.0f);
                if ((n13 & 0xFFFFFF00) != 0) {
                    int n20 = n13 = (n13 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                if ((n14 & 0xFFFFFF00) != 0) {
                    int n21 = n14 = (n14 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                if ((n15 & 0xFFFFFF00) != 0) {
                    int n22 = n15 = (n15 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                if ((n16 & 0xFFFFFF00) != 0) {
                    n16 = (n16 & Integer.MIN_VALUE) != 0 ? 0 : 255;
                }
                nArray[n8++] = n16 << 24 | n13 << 16 | n14 << 8 | n15;
            }
            n8 += n7;
        }
        return writableRaster;
    }
}

