/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayTypeReference
extends SingleTypeReference {
    public int dimensions;

    public ArrayTypeReference(char[] source, int dim, long pos) {
        super(source, pos);
        this.dimensions = dim;
    }

    public ArrayTypeReference(char[] source, TypeBinding tb, int dim, long pos) {
        super(source, tb, pos);
        this.dimensions = dim;
    }

    public int dimensions() {
        return this.dimensions;
    }

    public TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        return scope.createArray(scope.getType(this.token), this.dimensions);
    }

    public String toStringExpression(int tab) {
        String s = super.toStringExpression(tab);
        if (this.dimensions == 1) {
            return String.valueOf(s) + "[]";
        }
        int i = 1;
        while (i <= this.dimensions) {
            s = String.valueOf(s) + "[]";
            ++i;
        }
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }
}

