/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Case
extends Statement {
    public Expression constantExpression;
    public CaseLabel targetLabel;

    public Case(int sourceStart, Expression constantExpression) {
        this.constantExpression = constantExpression;
        this.sourceEnd = constantExpression.sourceEnd;
        this.sourceStart = sourceStart;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpression.constant == AstNode.NotAConstant) {
            currentScope.problemReporter().caseExpressionMustBeConstant(this.constantExpression);
        }
        this.constantExpression.analyseCode(currentScope, flowContext, flowInfo);
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        this.targetLabel.place();
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void resolve(BlockScope scope) {
    }

    public Constant resolveCase(BlockScope scope, TypeBinding switchType, SwitchStatement switchStatement) {
        switchStatement.cases[switchStatement.caseCount++] = this;
        TypeBinding caseType = this.constantExpression.resolveType(scope);
        if (caseType == null || switchType == null) {
            return null;
        }
        if (this.constantExpression.isConstantValueOfTypeAssignableToType(caseType, switchType)) {
            return this.constantExpression.constant;
        }
        if (caseType.isCompatibleWith(switchType)) {
            return this.constantExpression.constant;
        }
        scope.problemReporter().typeMismatchErrorActualTypeExpectedType(this.constantExpression, caseType, switchType);
        return null;
    }

    public String toString(int tab) {
        String s = AstNode.tabString(tab);
        s = String.valueOf(s) + "case " + this.constantExpression.toStringExpression() + " : ";
        return s;
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.constantExpression.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }
}

