/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.index.IQueryResult;
import org.eclipse.jdt.internal.core.index.impl.IFileDocument;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;
import org.eclipse.jdt.internal.core.util.SimpleLookupTable;

public class IndexBinaryFolder
extends IndexRequest {
    IFolder folder;

    public IndexBinaryFolder(IFolder folder, IndexManager manager) {
        super(folder.getFullPath(), manager);
        this.folder = folder;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexBinaryFolder) {
            return this.folder.equals((Object)((IndexBinaryFolder)o).folder);
        }
        return false;
    }

    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.folder.isAccessible()) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.indexPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                this.saveIfNecessary(index, monitor);
                IQueryResult[] results = index.queryInDocumentNames("");
                int max = results == null ? 0 : results.length;
                final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                if (max == 0) {
                    this.folder.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            if (IndexBinaryFolder.this.isCancelled) {
                                return false;
                            }
                            if (proxy.getType() == 1) {
                                IResource resource;
                                if (Util.isClassFileName(proxy.getName()) && (resource = proxy.requestResource()).getLocation() != null) {
                                    String name = new IFileDocument((IFile)resource).getName();
                                    indexedFileNames.put(name, resource);
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                } else {
                    int i = 0;
                    while (i < max) {
                        indexedFileNames.put(results[i].getPath(), "DELETED");
                        ++i;
                    }
                    final long indexLastModified = index.getIndexFile().lastModified();
                    this.folder.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            if (IndexBinaryFolder.this.isCancelled) {
                                return false;
                            }
                            if (proxy.getType() == 1) {
                                IResource resource;
                                IPath path;
                                if (Util.isClassFileName(proxy.getName()) && (path = (resource = proxy.requestResource()).getLocation()) != null) {
                                    String name;
                                    indexedFileNames.put(name, indexedFileNames.get(name = new IFileDocument((IFile)resource).getName()) == null || indexLastModified < path.toFile().lastModified() ? resource : "OK");
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                }
                Object[] names = indexedFileNames.keyTable;
                Object[] values = indexedFileNames.valueTable;
                boolean shouldSave = false;
                int i = 0;
                int length = names.length;
                while (i < length) {
                    String name = (String)names[i];
                    if (name != null) {
                        if (this.isCancelled) {
                            Object var14_18 = null;
                            monitor.exitRead();
                            return false;
                        }
                        Object value = values[i];
                        if (value != "OK") {
                            shouldSave = true;
                            if (value == "DELETED") {
                                this.manager.remove(name, this.indexPath);
                            } else {
                                this.manager.addBinary((IFile)value, this.indexPath);
                            }
                        }
                    }
                    ++i;
                }
                if (shouldSave) {
                    this.manager.request(new SaveIndex(this.indexPath, this.manager));
                }
            }
            catch (CoreException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.folder + " because of the following exception:");
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.indexPath);
                Object var14_19 = null;
                monitor.exitRead();
                return false;
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    JobManager.verbose("-> failed to index " + this.folder + " because of the following exception:");
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.indexPath);
                Object var14_20 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            monitor.exitRead();
            throw throwable;
        }
        Object var14_22 = null;
        monitor.exitRead();
        return true;
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing binary folder " + this.folder.getFullPath();
    }
}

