/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.AbstractSyntaxTreeVisitorAdapter;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.LocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.util.HashtableOfLong;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;

public class MatchSet {
    MatchLocator locator;
    int matchContainer;
    boolean cuHasBeenResolved = false;
    Map matchingNodes = new HashMap(5);
    HashtableOfLong matchingNodesKeys = new HashtableOfLong(5);
    Map potentialMatchingNodes = new HashMap(5);
    HashtableOfLong potentialMatchingNodesKeys = new HashtableOfLong(5);

    public MatchSet(MatchLocator locator) {
        this.locator = locator;
        this.matchContainer = locator.pattern.matchContainer();
    }

    public void addPossibleMatch(AstNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        AstNode existing = (AstNode)this.potentialMatchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.potentialMatchingNodes.remove(existing);
        }
        this.potentialMatchingNodes.put(node, new Integer(1));
        this.potentialMatchingNodesKeys.put(key, node);
    }

    public void addTrustedMatch(AstNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        AstNode existing = (AstNode)this.matchingNodesKeys.get(key);
        if (existing != null && existing.getClass().equals(node.getClass())) {
            this.matchingNodes.remove(existing);
        }
        this.matchingNodes.put(node, new Integer(2));
        this.matchingNodesKeys.put(key, node);
    }

    public void checkMatching(AstNode node) {
        this.locator.pattern.matchCheck(node, this);
    }

    public boolean isEmpty() {
        return this.potentialMatchingNodes.size() == 0 && this.matchingNodes.size() == 0;
    }

    private AstNode[] matchingNodes(int start, int end) {
        return this.nodesInRange(start, end, this.matchingNodes);
    }

    public boolean needsResolve() {
        return this.potentialMatchingNodes.size() > 0;
    }

    private AstNode[] nodesInRange(int start, int end, Map set) {
        ArrayList<AstNode> nodes = new ArrayList<AstNode>();
        Iterator keys = set.keySet().iterator();
        while (keys.hasNext()) {
            AstNode node = (AstNode)keys.next();
            if (start > node.sourceStart || node.sourceEnd > end) continue;
            nodes.add(node);
        }
        Object[] result = new AstNode[nodes.size()];
        nodes.toArray(result);
        Util.Comparer comparer = new Util.Comparer(){

            public int compare(Object o1, Object o2) {
                AstNode node1 = (AstNode)o1;
                AstNode node2 = (AstNode)o2;
                return node1.sourceStart - node2.sourceStart;
            }
        };
        Util.sort(result, comparer);
        return result;
    }

    private AstNode[] potentialMatchingNodes(int start, int end) {
        return this.nodesInRange(start, end, this.potentialMatchingNodes);
    }

    public Integer removePossibleMatch(AstNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        this.potentialMatchingNodesKeys.put(key, null);
        return (Integer)this.potentialMatchingNodes.remove(node);
    }

    public Integer removeTrustedMatch(AstNode node) {
        long key = ((long)node.sourceStart << 32) + (long)node.sourceEnd;
        this.matchingNodesKeys.put(key, null);
        return (Integer)this.matchingNodes.remove(node);
    }

    private void reportMatching(AbstractMethodDeclaration method, IJavaElement parent, boolean typeInHierarchy) throws CoreException {
        if ((method.bits & 2) != 0) {
            LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor();
            localDeclarationVisitor.enclosingElement = parent instanceof IType ? this.locator.createMethodHandle(method, (IType)parent) : parent;
            try {
                method.traverse((IAbstractSyntaxTreeVisitor)localDeclarationVisitor, (ClassScope)null);
            }
            catch (WrappedCoreException e) {
                throw e.coreException;
            }
        }
        if (typeInHierarchy) {
            AstNode[] nodes = this.matchingNodes(method.declarationSourceStart, method.declarationSourceEnd);
            int i = 0;
            while (i < nodes.length) {
                AstNode node = nodes[i];
                Integer level = (Integer)this.matchingNodes.get(node);
                if ((this.matchContainer & 8) != 0) {
                    this.locator.reportReference(node, method, parent, level == 2 ? 0 : 1);
                    this.matchingNodes.remove(node);
                }
                ++i;
            }
        }
        if (this.potentialMatchingNodes(method.declarationSourceStart, method.declarationSourceEnd).length == 0) {
            method.statements = null;
        }
    }

    public void reportMatching(CompilationUnitDeclaration unit) throws CoreException {
        TypeDeclaration[] types;
        ImportReference[] imports;
        Integer level;
        ImportReference pkg;
        if (this.cuHasBeenResolved) {
            Iterator potentialMatches = this.potentialMatchingNodes.keySet().iterator();
            while (potentialMatches.hasNext()) {
                int level2;
                AstNode node = (AstNode)potentialMatches.next();
                if (node instanceof ImportReference) {
                    if (this.locator.hierarchyResolver != null) continue;
                    ImportReference importRef = (ImportReference)node;
                    Binding binding = importRef.onDemand ? unit.scope.getTypeOrPackage(CharOperation.subarray(importRef.tokens, 0, importRef.tokens.length)) : unit.scope.getTypeOrPackage(importRef.tokens);
                    level2 = this.locator.pattern.matchLevel(binding);
                    if (level2 != 2 && level2 != 3) continue;
                    IJavaElement importHandle = this.locator.createImportHandle(importRef);
                    this.locator.pattern.matchReportImportRef(importRef, binding, importHandle, level2 == 2 ? 0 : 1, this.locator);
                    continue;
                }
                level2 = this.locator.pattern.matchLevel(node, true);
                if (level2 != 2 && level2 != 3) continue;
                this.matchingNodes.put(node, new Integer(level2));
            }
            this.potentialMatchingNodes = new HashMap();
        }
        if ((pkg = unit.currentPackage) != null && (level = (Integer)this.matchingNodes.remove(pkg)) != null && (this.matchContainer & 1) != 0) {
            this.locator.reportPackageDeclaration(pkg);
        }
        if (!this.cuHasBeenResolved && (imports = unit.imports) != null) {
            int i = 0;
            while (i < imports.length) {
                ImportReference importRef = imports[i];
                level = (Integer)this.matchingNodes.remove(importRef);
                if (level != null && (this.matchContainer & 1) != 0) {
                    this.locator.reportImport(importRef, level == 2 ? 0 : 1);
                }
                ++i;
            }
        }
        if ((types = unit.types) != null) {
            int i = 0;
            while (i < types.length) {
                TypeDeclaration type = types[i];
                level = (Integer)this.matchingNodes.remove(type);
                if (level != null && (this.matchContainer & 1) != 0) {
                    this.locator.reportTypeDeclaration(type, null, level == 2 ? 0 : 1);
                }
                this.reportMatching(type, null);
                ++i;
            }
        }
    }

    private void reportMatching(FieldDeclaration field, IJavaElement parent, TypeDeclaration type, boolean typeInHierarchy) throws CoreException {
        if (typeInHierarchy) {
            AstNode[] nodes = this.matchingNodes(field.declarationSourceStart, field.declarationSourceEnd);
            int i = 0;
            while (i < nodes.length) {
                AstNode node = nodes[i];
                Integer level = (Integer)this.matchingNodes.get(node);
                if ((this.matchContainer & 4) != 0) {
                    this.locator.reportReference(node, type, field, parent, level == 2 ? 0 : 1);
                    this.matchingNodes.remove(node);
                }
                ++i;
            }
        }
        if ((field.bits & 2) != 0) {
            LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor();
            localDeclarationVisitor.enclosingElement = parent instanceof IType ? (field.isField() ? (IJavaElement)this.locator.createFieldHandle(field, (IType)parent) : (IJavaElement)this.locator.createInitializerHandle(type, field, (IType)parent)) : parent;
            try {
                field.traverse((IAbstractSyntaxTreeVisitor)localDeclarationVisitor, null);
            }
            catch (WrappedCoreException e) {
                throw e.coreException;
            }
        }
    }

    public void reportMatching(TypeDeclaration type, IJavaElement parent) throws CoreException {
        MemberTypeDeclaration[] memberTypes;
        AbstractMethodDeclaration[] methods;
        Integer level;
        IJavaElement enclosingElement;
        boolean typeInHierarchy;
        boolean bl = typeInHierarchy = this.locator.hierarchyResolver == null || type.binding == null || this.locator.hierarchyResolver.subOrSuperOfFocus(type.binding);
        if (parent == null) {
            enclosingElement = this.locator.createTypeHandle(type.name);
        } else if (parent instanceof IType) {
            enclosingElement = this.locator.createTypeHandle((IType)parent, type.name);
            if (enclosingElement == null) {
                return;
            }
        } else {
            enclosingElement = parent;
        }
        FieldDeclaration[] fields = type.fields;
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                FieldDeclaration field = fields[i];
                level = (Integer)this.matchingNodes.remove(field);
                if (level != null && typeInHierarchy && (this.matchContainer & 2) != 0) {
                    this.locator.reportFieldDeclaration(field, enclosingElement, level == 2 ? 0 : 1);
                }
                this.reportMatching(field, enclosingElement, type, typeInHierarchy);
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            int i = 0;
            while (i < methods.length) {
                AbstractMethodDeclaration method = methods[i];
                level = (Integer)this.matchingNodes.remove(method);
                if (level != null && typeInHierarchy && (this.matchContainer & 2) != 0) {
                    this.locator.reportMethodDeclaration(method, enclosingElement, level == 2 ? 0 : 1);
                }
                this.reportMatching(method, enclosingElement, typeInHierarchy);
                ++i;
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            while (i < memberTypes.length) {
                MemberTypeDeclaration memberType = memberTypes[i];
                level = (Integer)this.matchingNodes.remove(memberType);
                if (level != null && typeInHierarchy && (this.matchContainer & 2) != 0) {
                    this.locator.reportTypeDeclaration(memberType, enclosingElement, level == 2 ? 0 : 1);
                }
                this.reportMatching(memberType, enclosingElement);
                ++i;
            }
        }
        if (type instanceof AnonymousLocalTypeDeclaration) {
            TypeReference superType = ((AnonymousLocalTypeDeclaration)type).allocation.type;
            if (superType != null && (level = (Integer)this.matchingNodes.remove(superType)) != null && (this.matchContainer & 2) != 0) {
                this.locator.reportSuperTypeReference(superType, enclosingElement, level == 2 ? 0 : 1);
            }
        } else {
            TypeReference[] superInterfaces;
            TypeReference superClass = type.superclass;
            if (superClass != null && (level = (Integer)this.matchingNodes.remove(superClass)) != null && (this.matchContainer & 2) != 0) {
                this.locator.reportSuperTypeReference(superClass, enclosingElement, level == 2 ? 0 : 1);
            }
            if ((superInterfaces = type.superInterfaces) != null) {
                int i = 0;
                while (i < superInterfaces.length) {
                    TypeReference superInterface = superInterfaces[i];
                    level = (Integer)this.matchingNodes.get(superInterface);
                    if (level != null && (this.matchContainer & 2) != 0) {
                        this.locator.reportSuperTypeReference(superInterface, enclosingElement, level == 2 ? 0 : 1);
                    }
                    ++i;
                }
            }
        }
    }

    public String toString() {
        int accuracy;
        Object value;
        AstNode node;
        StringBuffer result = new StringBuffer();
        result.append("Exact matches:");
        Iterator iter = this.matchingNodes.keySet().iterator();
        while (iter.hasNext()) {
            result.append("\n");
            node = (AstNode)iter.next();
            value = this.matchingNodes.get(node);
            if (value instanceof Integer) {
                result.append('\t');
                accuracy = (Integer)value;
                switch (accuracy) {
                    case 0: {
                        result.append("IMPOSSIBLE_MATCH: ");
                        break;
                    }
                    case 1: {
                        result.append("POSSIBLE_MATCH: ");
                        break;
                    }
                    case 3: {
                        result.append("INACCURATE_MATCH: ");
                        break;
                    }
                    case 2: {
                        result.append("ACCURATE_MATCH: ");
                    }
                }
            }
            result.append(node.toString(0));
        }
        result.append("\nPotential matches:");
        iter = this.potentialMatchingNodes.keySet().iterator();
        while (iter.hasNext()) {
            result.append("\n");
            node = (AstNode)iter.next();
            value = this.potentialMatchingNodes.get(node);
            if (value instanceof Integer) {
                result.append("\t");
                accuracy = (Integer)value;
                switch (accuracy) {
                    case 0: {
                        result.append("IMPOSSIBLE_MATCH: ");
                        break;
                    }
                    case 1: {
                        result.append("POSSIBLE_MATCH: ");
                        break;
                    }
                    case 3: {
                        result.append("INACCURATE_MATCH: ");
                        break;
                    }
                    case 2: {
                        result.append("ACCURATE_MATCH: ");
                    }
                }
            }
            result.append(node.toString(0));
        }
        return result.toString();
    }

    public class LocalDeclarationVisitor
    extends AbstractSyntaxTreeVisitorAdapter {
        IJavaElement enclosingElement;

        public boolean visit(AnonymousLocalTypeDeclaration anonymousTypeDeclaration, BlockScope scope) {
            try {
                MatchSet.this.reportMatching(anonymousTypeDeclaration, this.enclosingElement);
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
            return false;
        }

        public boolean visit(LocalTypeDeclaration typeDeclaration, BlockScope scope) {
            try {
                Integer level = (Integer)MatchSet.this.matchingNodes.remove(typeDeclaration);
                if (level != null) {
                    MatchSet.this.locator.reportTypeDeclaration(typeDeclaration, this.enclosingElement, level == 2 ? 0 : 1);
                }
                MatchSet.this.reportMatching(typeDeclaration, this.enclosingElement);
                return false;
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }

        public boolean visit(MemberTypeDeclaration typeDeclaration, ClassScope scope) {
            try {
                MatchSet.this.reportMatching(typeDeclaration, this.enclosingElement);
                return false;
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }
    }

    public class WrappedCoreException
    extends RuntimeException {
        public CoreException coreException;

        public WrappedCoreException(CoreException coreException) {
            this.coreException = coreException;
        }
    }
}

